/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.jexl342.ReferenceUberspect;

public class ReferenceSetExecutor
implements JexlPropertySet {
    private final ReferenceUberspect.ReferenceHandler handler;
    private final JexlPropertySet setter;

    public ReferenceSetExecutor(ReferenceUberspect.ReferenceHandler referenceHandler, JexlPropertySet jexlSet) {
        if (referenceHandler == null || jexlSet == null) {
            throw new IllegalArgumentException("handler and setter cant be null");
        }
        this.handler = referenceHandler;
        this.setter = jexlSet;
    }

    protected Object getReference(Object opt) {
        return this.handler.callGet(opt);
    }

    public Object invoke(Object opt, Object arg) throws Exception {
        Object obj = this.getReference(opt);
        return this.setter.invoke(obj, arg);
    }

    public Object tryInvoke(Object opt, Object key, Object arg) throws JexlException.TryFailed {
        Object obj = this.getReference(opt);
        return obj == opt ? JexlEngine.TRY_FAILED : (obj == null ? null : this.setter.tryInvoke(key, obj, arg));
    }

    public boolean tryFailed(Object rval) {
        return this.setter.tryFailed(rval);
    }

    public boolean isCacheable() {
        return this.setter.isCacheable();
    }
}

