/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.scripting;

import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.jexl3.scripting.JexlScriptEngine;
import org.apache.commons.jexl3.scripting.JexlScriptEngineFactory;
import org.junit.Assert;
import org.junit.Test;

public class JexlScriptEngineTest {
    private static final List<String> NAMES = Arrays.asList("JEXL", "Jexl", "jexl", "JEXL2", "Jexl2", "jexl2", "JEXL3", "Jexl3", "jexl3");
    private static final List<String> EXTENSIONS = Arrays.asList("jexl", "jexl2", "jexl3");
    private static final List<String> MIMES = Arrays.asList("application/x-jexl", "application/x-jexl2", "application/x-jexl3");

    @Test
    public void testScriptEngineFactory() throws Exception {
        JexlScriptEngineFactory factory = new JexlScriptEngineFactory();
        Assert.assertEquals((Object)"JEXL Engine", (Object)factory.getParameter("javax.script.engine"));
        Assert.assertEquals((Object)"3.2", (Object)factory.getParameter("javax.script.engine_version"));
        Assert.assertEquals((Object)"JEXL", (Object)factory.getParameter("javax.script.language"));
        Assert.assertEquals((Object)"3.2", (Object)factory.getParameter("javax.script.language_version"));
        Assert.assertNull((Object)factory.getParameter("THREADING"));
        Assert.assertEquals(NAMES, (Object)factory.getParameter("javax.script.name"));
        Assert.assertEquals(EXTENSIONS, (Object)factory.getExtensions());
        Assert.assertEquals(MIMES, (Object)factory.getMimeTypes());
        Assert.assertEquals((Object)"42;", (Object)factory.getProgram(new String[]{"42"}));
        Assert.assertEquals((Object)"str.substring(3,4)", (Object)factory.getMethodCallSyntax("str", "substring", new String[]{"3", "4"}));
    }

    @Test
    public void testScriptingGetBy() throws Exception {
        ScriptEngine engine;
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        for (String name : NAMES) {
            engine = manager.getEngineByName(name);
            Assert.assertNotNull((String)"Engine should not be null (name)", (Object)engine);
        }
        for (String extension : EXTENSIONS) {
            engine = manager.getEngineByExtension(extension);
            Assert.assertNotNull((String)"Engine should not be null (extension)", (Object)engine);
        }
        for (String mime : MIMES) {
            engine = manager.getEngineByMimeType(mime);
            Assert.assertNotNull((String)"Engine should not be null (mime)", (Object)engine);
        }
    }

    @Test
    public void testScripting() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Integer initialValue = 123;
        Assert.assertEquals((Object)initialValue, (Object)engine.eval("123"));
        Assert.assertEquals((Object)initialValue, (Object)engine.eval("0;123"));
        long time1 = System.currentTimeMillis();
        Long time2 = (Long)engine.eval("sys=context.class.forName(\"java.lang.System\");now=sys.currentTimeMillis();");
        Assert.assertTrue((String)"Must take some time to process this", (time1 <= time2 ? 1 : 0) != 0);
        engine.put("value", initialValue);
        Assert.assertEquals((Object)initialValue, (Object)engine.get("value"));
        Integer newValue = 124;
        Assert.assertEquals((Object)newValue, (Object)engine.eval("old=value;value=value+1"));
        Assert.assertEquals((Object)initialValue, (Object)engine.get("old"));
        Assert.assertEquals((Object)newValue, (Object)engine.get("value"));
        Assert.assertEquals((Object)engine.getContext(), (Object)engine.get("context"));
        Assert.assertEquals((Object)engine.getContext().getReader(), (Object)engine.eval("JEXL.in"));
        Assert.assertEquals((Object)engine.getContext().getWriter(), (Object)engine.eval("JEXL.out"));
        Assert.assertEquals((Object)engine.getContext().getErrorWriter(), (Object)engine.eval("JEXL.err"));
        Assert.assertEquals(System.class, (Object)engine.eval("JEXL.System"));
    }

    @Test
    public void testNulls() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("jexl3");
        Assert.assertNotNull((String)"Engine should not be null (name)", (Object)engine);
        try {
            engine.eval((String)null);
            Assert.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            engine.eval((Reader)null);
            Assert.fail((String)"Should have caused NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testScopes() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("JEXL");
        Assert.assertNotNull((String)"Engine should not be null (JEXL)", (Object)engine);
        manager.put("global", 1);
        engine.put("local", 10);
        manager.put("both", 7);
        engine.put("both", 7);
        engine.eval("local=local+1");
        engine.eval("global=global+1");
        engine.eval("both=both+1");
        engine.eval("newvar=42;");
        Assert.assertEquals((Object)2, (Object)manager.get("global"));
        Assert.assertEquals((Object)11, (Object)engine.get("local"));
        Assert.assertEquals((Object)7, (Object)manager.get("both"));
        Assert.assertEquals((Object)8, (Object)engine.get("both"));
        Assert.assertEquals((Object)42, (Object)engine.get("newvar"));
        Assert.assertNull((Object)manager.get("newvar"));
    }

    @Test
    public void testDottedNames() throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        Assert.assertNotNull((String)"Manager should not be null", (Object)manager);
        ScriptEngine engine = manager.getEngineByName("JEXL");
        Assert.assertNotNull((String)"Engine should not be null (JEXL)", (Object)engine);
        engine.eval("this.is.a.test=null");
        Assert.assertNull((Object)engine.get("this.is.a.test"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)engine.eval("empty(this.is.a.test)"));
        Object mymap = engine.eval("testmap={ 'key1' : 'value1', 'key2' : 'value2' }");
        Assert.assertTrue((boolean)(mymap instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)mymap).size());
    }

    @Test
    public void testDirectNew() throws Exception {
        JexlScriptEngine engine = new JexlScriptEngine();
        Integer initialValue = 123;
        Assert.assertEquals((Object)initialValue, (Object)engine.eval("123"));
    }
}

