/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleListModel
extends Model<SerializableList<? extends Role>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ReviewMgr reviewMgr;
    @SpringBean
    private DelReviewMgr delReviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)RoleListModel.class.getName());
    private Role role;
    private SerializableList<? extends Role> roles = null;
    private boolean isAdmin;

    public RoleListModel(boolean isAdmin, Session session) {
        Injector.get().inject((Object)this);
        this.isAdmin = isAdmin;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public RoleListModel(Role role, boolean isAdmin, Session session) {
        Injector.get().inject((Object)this);
        this.role = role;
        this.isAdmin = isAdmin;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public SerializableList<? extends Role> getObject() {
        if (this.roles != null) {
            LOG.debug(".getObject count: " + this.roles.size());
            return this.roles;
        }
        if (this.role == null) {
            LOG.debug(".getObject null");
            this.roles = new SerializableList(new ArrayList());
        } else {
            LOG.debug(".getObject roleNm: " + this.role.getName());
            this.roles = this.isAdmin ? new SerializableList(this.getAdminList(this.role.getName())) : new SerializableList(this.getList(this.role.getName()));
        }
        return this.roles;
    }

    public void setObject(SerializableList<? extends Role> object) {
        LOG.debug(".setObject count: " + object.size());
        this.roles = object;
    }

    public void detach() {
        this.roles = null;
        this.role = null;
    }

    private List<Role> getList(String szRoleNm) {
        List rolesList = null;
        try {
            LOG.debug(".getList roleNm: " + szRoleNm);
            rolesList = this.reviewMgr.findRoles(szRoleNm);
            if (CollectionUtils.isNotEmpty((Collection)rolesList)) {
                Collections.sort(rolesList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return rolesList;
    }

    private List<AdminRole> getAdminList(String szRoleNm) {
        List rolesList = null;
        try {
            LOG.debug(".getList roleNm: " + szRoleNm);
            rolesList = this.delReviewMgr.findRoles(szRoleNm);
            if (CollectionUtils.isNotEmpty((Collection)rolesList)) {
                Collections.sort(rolesList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getAdminList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return rolesList;
    }
}

