/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;

public abstract class AbstractElementSerializer<T>
implements ElementSerializer<T> {
    private final Comparator<T> comparator;
    private Class<?> type;

    public AbstractElementSerializer(Comparator<T> comparator) {
        this.comparator = comparator;
        Class<?> comparatorClass = comparator.getClass();
        Type[] types = comparatorClass.getGenericInterfaces();
        if (types[0] instanceof Class) {
            this.type = (Class)types[0];
        } else {
            Type[] argumentTypes = ((ParameterizedType)types[0]).getActualTypeArguments();
            if (argumentTypes != null && argumentTypes.length > 0) {
                if (argumentTypes[0] instanceof Class) {
                    this.type = (Class)argumentTypes[0];
                } else if (argumentTypes[0] instanceof GenericArrayType) {
                    Class clazz = (Class)((GenericArrayType)argumentTypes[0]).getGenericComponentType();
                    this.type = Array.newInstance(clazz, 0).getClass();
                }
            }
        }
    }

    @Override
    public int compare(T type1, T type2) {
        return this.comparator.compare(type1, type2);
    }

    @Override
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }
}

