/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db.context;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.empire.db.DBCommand;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBUtils;
import org.apache.empire.db.context.DBRollbackHandler;
import org.apache.empire.db.context.DBRollbackManager;
import org.apache.empire.db.exceptions.EmpireSQLException;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBContextBase
implements DBContext {
    private static final Logger log = LoggerFactory.getLogger(DBContextBase.class);
    private DBUtils utils = null;
    private boolean noRollbackManagerWarnOnce = true;

    protected DBUtils createUtils() {
        return new DBUtils(this);
    }

    protected void setUtils(DBUtils utils) {
        if (utils == null) {
            throw new InvalidArgumentException("utils", utils);
        }
        if (this.utils != utils) {
            this.utils = utils;
        }
    }

    @Override
    public DBUtils getUtils() {
        if (this.utils == null) {
            this.utils = this.createUtils();
        }
        return this.utils;
    }

    protected abstract Connection getConnection(boolean var1);

    protected abstract DBRollbackManager getRollbackManager(boolean var1);

    @Override
    public Connection getConnection() {
        return this.getConnection(true);
    }

    public abstract boolean isPreparedStatementsEnabled();

    @Override
    public final DBCommand createCommand() {
        return this.getDbms().createCommand(this.isPreparedStatementsEnabled());
    }

    @Override
    public final int executeSQL(String sqlCmd, Object[] sqlParams) {
        if (this.utils == null) {
            this.setUtils(this.getUtils());
        }
        return this.utils.executeSQL(sqlCmd, sqlParams, null);
    }

    @Override
    public final int executeInsert(DBCommand cmd) {
        if (this.utils == null) {
            this.setUtils(this.getUtils());
        }
        return this.utils.executeSQL(cmd.getInsert(), cmd.getParamValues(), null);
    }

    @Override
    public final int executeInsertInto(DBTable table, DBCommand cmd) {
        if (this.utils == null) {
            this.setUtils(this.getUtils());
        }
        return this.utils.executeSQL(cmd.getInsertInto(table), cmd.getParamValues(), null);
    }

    @Override
    public final int executeUpdate(DBCommand cmd) {
        if (this.utils == null) {
            this.setUtils(this.getUtils());
        }
        return this.utils.executeSQL(cmd.getUpdate(), cmd.getParamValues(), null);
    }

    @Override
    public final int executeDelete(DBTable from, DBCommand cmd) {
        if (this.utils == null) {
            this.setUtils(this.getUtils());
        }
        return this.utils.executeSQL(cmd.getDelete(from), cmd.getParamValues(), null);
    }

    @Override
    public void commit() {
        try {
            DBRollbackManager dbrm;
            Connection conn = this.getConnection(false);
            if (conn == null) {
                log.info("No Connection to commmit changes");
                return;
            }
            DBRollbackManager dBRollbackManager = dbrm = this.isRollbackHandlingEnabled() ? this.getRollbackManager(false) : null;
            if (dbrm != null) {
                dbrm.releaseConnection(conn, DBRollbackManager.ReleaseAction.Discard);
            }
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this.getDbms(), sqle);
        }
    }

    @Override
    public void rollback() {
        try {
            DBRollbackManager dbrm;
            Connection conn = this.getConnection(false);
            if (conn == null) {
                log.info("No Connection to rollback changes");
                return;
            }
            log.info("Database rollback issued!");
            conn.rollback();
            DBRollbackManager dBRollbackManager = dbrm = this.isRollbackHandlingEnabled() ? this.getRollbackManager(false) : null;
            if (dbrm != null) {
                dbrm.releaseConnection(conn, DBRollbackManager.ReleaseAction.Rollback);
            }
            return;
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this.getDbms(), sqle);
        }
    }

    @Override
    public void appendRollbackHandler(DBRollbackHandler handler) {
        if (handler == null || handler.getObject() == null) {
            throw new InvalidArgumentException("handler", handler);
        }
        if (!this.isRollbackHandlingEnabled()) {
            log.warn("*** Rollback handling is disabled for this context. AppendRollbackHandler must not be called! ***");
            return;
        }
        DBRollbackManager dbrm = this.getRollbackManager(true);
        if (dbrm != null) {
            dbrm.appendHandler(this.getConnection(true), handler);
        } else if (this.noRollbackManagerWarnOnce) {
            log.warn("*** No DBRollbackManager provided! Rollbacks will be disabled. ***");
            this.noRollbackManagerWarnOnce = false;
        }
    }

    @Override
    public void removeRollbackHandler(DBObject object) {
        if (object == null) {
            throw new InvalidArgumentException("object", object);
        }
        if (!this.isRollbackHandlingEnabled()) {
            log.warn("*** Rollback handling is disabled for this context. RemoveRollbackHandler should not be called! ***");
            return;
        }
        DBRollbackManager dbrm = this.getRollbackManager(false);
        if (dbrm != null) {
            dbrm.removeHandler(this.getConnection(false), object);
        }
    }

    @Override
    public void discard() {
    }

    protected void closeConnection() {
        try {
            Connection conn = this.getConnection(false);
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            throw new EmpireSQLException(this.getDbms(), sqle);
        }
    }
}

