/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.ops4j.pax.logging.PaxLogger;

public abstract class Category {
    protected PaxLogger m_delegate;

    public Category(PaxLogger delegate) {
        this.m_delegate = delegate;
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void debug(Object message) {
        if (this.m_delegate.isDebugEnabled() && message != null) {
            this.m_delegate.debug(message.toString(), null);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.m_delegate.isDebugEnabled()) {
            if (message != null) {
                this.m_delegate.debug(message.toString(), t);
            } else {
                this.m_delegate.debug(null, t);
            }
        }
    }

    public void error(Object message) {
        if (this.m_delegate.isErrorEnabled() && message != null) {
            this.m_delegate.error(message.toString(), null);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.m_delegate.isErrorEnabled()) {
            if (message != null) {
                this.m_delegate.error(message.toString(), t);
            } else {
                this.m_delegate.error(null, t);
            }
        }
    }

    public void fatal(Object message) {
        if (this.m_delegate.isFatalEnabled() && message != null) {
            this.m_delegate.fatal(message.toString(), null);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.m_delegate.isFatalEnabled()) {
            if (message != null) {
                this.m_delegate.fatal(message.toString(), t);
            } else {
                this.m_delegate.fatal(null, t);
            }
        }
    }

    public static Category getInstance(String name) {
        return Logger.getLogger(name);
    }

    public static Category getInstance(Class clazz) {
        return Logger.getLogger(clazz);
    }

    public final String getName() {
        return this.m_delegate.getName();
    }

    public void info(Object message) {
        if (this.m_delegate.isInfoEnabled() && message != null) {
            this.m_delegate.inform(message.toString(), null);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.m_delegate.isInfoEnabled()) {
            if (message != null) {
                this.m_delegate.inform(message.toString(), t);
            } else {
                this.m_delegate.inform(null, t);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public boolean isEnabledFor(Priority priority) {
        if (priority == null) {
            return false;
        }
        switch (priority.level) {
            case 50000: {
                return this.m_delegate.isFatalEnabled();
            }
            case 40000: {
                return this.m_delegate.isErrorEnabled();
            }
            case 30000: {
                return this.m_delegate.isWarnEnabled();
            }
            case 20000: {
                return this.m_delegate.isInfoEnabled();
            }
            case 10000: {
                return this.m_delegate.isDebugEnabled();
            }
            case -2147483648: 
            case 5000: {
                return this.m_delegate.isTraceEnabled();
            }
        }
        return false;
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public void log(Priority priority, Object msg) {
        this.log(priority, msg, null);
    }

    public void log(Priority priority, Object message, Throwable t) {
        if (priority == null) {
            return;
        }
        switch (priority.level) {
            case 50000: {
                this.fatal(message, t);
                break;
            }
            case 40000: {
                this.error(message, t);
                break;
            }
            case 30000: {
                this.warn(message, t);
                break;
            }
            case 20000: {
                this.info(message, t);
                break;
            }
            case 10000: {
                this.debug(message, t);
                break;
            }
            case -2147483648: 
            case 5000: {
                this.trace(message, t);
                break;
            }
        }
    }

    protected abstract void trace(Object var1, Throwable var2);

    public void log(String callerFQCN, Priority level, Object message, Throwable t) {
        this.log(level, message, t);
    }

    public static void shutdown() {
    }

    public void warn(Object message) {
        if (this.m_delegate.isWarnEnabled() && message != null) {
            this.m_delegate.warn(message.toString(), null);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.m_delegate.isWarnEnabled()) {
            if (message != null) {
                this.m_delegate.warn(message.toString(), t);
            } else {
                this.m_delegate.warn(null, t);
            }
        }
    }
}

