/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.agent;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.aries.jmx.JMXThreadFactory;
import org.apache.aries.jmx.Logger;
import org.apache.aries.jmx.MBeanHandler;
import org.apache.aries.jmx.MBeanServiceTracker;
import org.apache.aries.jmx.agent.JMXAgent;
import org.apache.aries.jmx.agent.JMXAgentContext;
import org.apache.aries.jmx.cm.ConfigurationAdminMBeanHandler;
import org.apache.aries.jmx.framework.BundleStateMBeanHandler;
import org.apache.aries.jmx.framework.FrameworkMBeanHandler;
import org.apache.aries.jmx.framework.PackageStateMBeanHandler;
import org.apache.aries.jmx.framework.ServiceStateMBeanHandler;
import org.apache.aries.jmx.permissionadmin.PermissionAdminMBeanHandler;
import org.apache.aries.jmx.provisioning.ProvisioningServiceMBeanHandler;
import org.apache.aries.jmx.useradmin.UserAdminMBeanHandler;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class JMXAgentImpl
implements JMXAgent {
    private ServiceTracker mbeanServiceTracker;
    private Set<MBeanHandler> mbeansHandlers;
    private JMXAgentContext agentContext;
    private Logger logger;
    private ExecutorService registrationExecutor;

    public JMXAgentImpl(Logger logger) {
        this.logger = logger;
        this.mbeansHandlers = new HashSet<MBeanHandler>();
        this.registrationExecutor = Executors.newSingleThreadExecutor(new JMXThreadFactory("JMX OSGi Agent"));
    }

    public void start() {
        this.logger.log(3, "Starting JMX OSGi agent");
        BundleContext bc = this.agentContext.getBundleContext();
        FrameworkMBeanHandler frameworkHandler = new FrameworkMBeanHandler(bc, this.logger);
        frameworkHandler.open();
        this.mbeansHandlers.add(frameworkHandler);
        BundleStateMBeanHandler bundleStateHandler = new BundleStateMBeanHandler(bc, this.logger);
        bundleStateHandler.open();
        this.mbeansHandlers.add(bundleStateHandler);
        ServiceStateMBeanHandler serviceStateHandler = new ServiceStateMBeanHandler(bc, this.logger);
        serviceStateHandler.open();
        this.mbeansHandlers.add(serviceStateHandler);
        PackageStateMBeanHandler packageStateHandler = new PackageStateMBeanHandler(bc, this.logger);
        packageStateHandler.open();
        this.mbeansHandlers.add(packageStateHandler);
        PermissionAdminMBeanHandler permissionAdminHandler = new PermissionAdminMBeanHandler(this.agentContext);
        permissionAdminHandler.open();
        this.mbeansHandlers.add(permissionAdminHandler);
        UserAdminMBeanHandler userAdminHandler = new UserAdminMBeanHandler(this.agentContext);
        userAdminHandler.open();
        this.mbeansHandlers.add(userAdminHandler);
        ConfigurationAdminMBeanHandler configAdminHandler = new ConfigurationAdminMBeanHandler(this.agentContext);
        configAdminHandler.open();
        this.mbeansHandlers.add(configAdminHandler);
        ProvisioningServiceMBeanHandler provServiceHandler = new ProvisioningServiceMBeanHandler(this.agentContext);
        provServiceHandler.open();
        this.mbeansHandlers.add(provServiceHandler);
        this.mbeanServiceTracker = new MBeanServiceTracker(this.agentContext);
        this.mbeanServiceTracker.open();
    }

    public void registerMBeans(MBeanServer server) {
        for (MBeanHandler mbeanHandler : this.mbeansHandlers) {
            String name = mbeanHandler.getName();
            StandardMBean mbean = mbeanHandler.getMbean();
            if (mbean == null) continue;
            try {
                this.logger.log(3, "Registering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.registerMBean(mbean, new ObjectName(name));
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.log(1, "MBean is already registered", e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.log(1, "MBean is not compliant MBean", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname", e);
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null", e);
            }
        }
    }

    public void unregisterMBeans(MBeanServer server) {
        for (MBeanHandler mBeanHandler : this.mbeansHandlers) {
            try {
                String name = mBeanHandler.getName();
                StandardMBean mbean = mBeanHandler.getMbean();
                if (mbean == null) continue;
                this.logger.log(3, "Unregistering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                server.unregisterMBean(new ObjectName(name));
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't unregister MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "Mbena doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to unregister with no valid objectname", e);
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null ", e);
            }
            catch (Exception e) {
                this.logger.log(1, "Cannot unregister MBean: " + mBeanHandler, e);
            }
        }
    }

    public void registerMBean(MBeanHandler mBeanHandler) {
        Object[] servers = this.getMBeanServers();
        if (servers == null) {
            this.logger.log(2, "There are no MBean servers registred, can't register MBeans");
            return;
        }
        for (Object server : servers) {
            String name = mBeanHandler.getName();
            StandardMBean mbean = mBeanHandler.getMbean();
            try {
                this.logger.log(3, "Registering " + mbean.getMBeanInterface().getName() + " to MBeanServer " + server + " with name " + name);
                ((MBeanServer)server).registerMBean(mbean, new ObjectName(name));
            }
            catch (InstanceAlreadyExistsException e) {
                this.logger.log(1, "MBean is already registered", e);
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (NotCompliantMBeanException e) {
                this.logger.log(1, "MBean is not compliant MBean, Stopping registration", e);
                return;
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
    }

    public void unregisterMBean(String name) {
        Object[] servers;
        for (Object server : servers = this.getMBeanServers()) {
            try {
                this.logger.log(3, "Unregistering mbean  to MBeanServer " + server + " with name " + name);
                ((MBeanServer)server).unregisterMBean(new ObjectName(name));
            }
            catch (MBeanRegistrationException e) {
                this.logger.log(1, "Can't register MBean", e);
            }
            catch (InstanceNotFoundException e) {
                this.logger.log(1, "Mbena doesn't exist in the repository", e);
            }
            catch (MalformedObjectNameException e) {
                this.logger.log(1, "Try to register with no valid objectname, Stopping registration", e);
                return;
            }
            catch (NullPointerException e) {
                this.logger.log(1, "Name of objectname can't be null, Stopping registration", e);
                return;
            }
        }
    }

    public void stop() {
        this.logger.log(3, "Stopping JMX OSGi agent");
        this.mbeanServiceTracker.close();
        for (MBeanHandler mBeanHandler : this.mbeansHandlers) {
            mBeanHandler.close();
        }
        if (this.registrationExecutor != null && !this.registrationExecutor.isShutdown()) {
            this.registrationExecutor.shutdown();
        }
    }

    public JMXAgentContext getAgentContext() {
        return this.agentContext;
    }

    public void setAgentContext(JMXAgentContext agentContext) {
        this.agentContext = agentContext;
    }

    private Object[] getMBeanServers() {
        return this.mbeanServiceTracker.getServices();
    }

    public ExecutorService getRegistrationExecutor() {
        return this.registrationExecutor;
    }
}

