/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.AtomosLayer;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.osgi.annotation.bundle.Header;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.BundleException;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.framework.launch.Framework;

@Header(name="Main-Class", value="org.apache.felix.atomos.Atomos")
@ProviderType
public interface Atomos {
    public static final String ATOMOS_CONTENT_INSTALL = "atomos.content.install";
    public static final String ATOMOS_CONTENT_START = "atomos.content.start";

    public AtomosContent getConnectedContent(String var1);

    public AtomosLayer getBootLayer();

    public ModuleConnector getModuleConnector();

    public AtomosLayer addLayer(List<AtomosLayer> var1, String var2, AtomosLayer.LoaderType var3, Path ... var4);

    public Framework newFramework(Map<String, String> var1);

    public static void main(String ... args) throws BundleException {
        Map<String, String> config = Atomos.getConfiguration(args);
        config.putIfAbsent("atomos.enable.resolution.errors", "true");
        Atomos atomos = Atomos.newAtomos(config);
        Framework framework = atomos.newFramework(config);
        framework.start();
    }

    public static Map<String, String> getConfiguration(String ... args) {
        HashMap<String, String> config = new HashMap<String, String>();
        if (args != null) {
            for (String arg : args) {
                int equals = arg.indexOf(61);
                if (equals == -1) continue;
                String key = arg.substring(0, equals);
                String value = arg.substring(equals + 1);
                config.put(key, value);
            }
        }
        return config;
    }

    public static Atomos newAtomos() {
        return Atomos.newAtomos(AtomosBase.NO_OP_HEADER_PROVIDER);
    }

    public static Atomos newAtomos(HeaderProvider headerProvider) {
        return Atomos.newAtomos(Collections.emptyMap(), headerProvider);
    }

    public static Atomos newAtomos(Map<String, String> configuration) {
        return Atomos.newAtomos(configuration, AtomosBase.NO_OP_HEADER_PROVIDER);
    }

    public static Atomos newAtomos(Map<String, String> configuration, HeaderProvider headerProvider) {
        return AtomosBase.newAtomos(configuration, headerProvider);
    }

    @FunctionalInterface
    @ConsumerType
    public static interface HeaderProvider
    extends BiFunction<String, Map<String, String>, Optional<Map<String, String>>> {
        @Override
        public Optional<Map<String, String>> apply(String var1, Map<String, String> var2);
    }
}

