/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.atomos.Atomos;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.AtomosLayer;
import org.apache.felix.atomos.impl.base.AtomosClassPath;
import org.apache.felix.atomos.impl.base.AtomosCommands;
import org.apache.felix.atomos.impl.base.AtomosFrameworkHooks;
import org.apache.felix.atomos.impl.base.AtomosFrameworkUtilHelper;
import org.apache.felix.atomos.impl.base.AtomosModuleConnector;
import org.apache.felix.atomos.impl.base.AtomosStorage;
import org.apache.felix.atomos.impl.content.ConnectContentCloseableJar;
import org.apache.felix.atomos.impl.content.ConnectContentFile;
import org.apache.felix.atomos.impl.content.ConnectContentIndexed;
import org.apache.felix.atomos.impl.content.ConnectContentJar;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.connect.FrameworkUtilHelper;
import org.osgi.framework.connect.ModuleConnector;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import sun.misc.Signal;

public abstract class AtomosBase
implements Atomos,
SynchronousBundleListener,
FrameworkUtilHelper,
FrameworkListener {
    static final String JAR_PROTOCOL = "jar";
    static final String FILE_PROTOCOL = "file";
    public static final String ATOMOS_PROP_PREFIX = "atomos.";
    public static final String ATOMOS_REPORT_RESOLUTION_PROP = "atomos.enable.resolution.errors";
    public static final String ATOMOS_DEBUG_PROP = "atomos.enable.debug";
    public static final String ATOMOS_INDEX_PATH_PROP = "atomos.index.path";
    public static final String ATOMOS_IGNORE_INDEX = "IGNORE";
    public static final String ATOMOS_BUNDLES_INDEX_DEFAULT = "/atomos/bundles.index";
    public static final String ATOMOS_BUNDLE = "ATOMOS_BUNDLE";
    public static final String ATOMOS_LIB_DIR_PROP = "atomos.lib.dir";
    public static final String ATOMOS_CLASS_PROP = "atomos..class";
    public static final String ATOMOS_RUNTIME_MODULES_CLASS = "org.apache.felix.atomos.impl.modules.AtomosModules";
    public static final String ATOMOS_LIB_DIR = "atomos_lib";
    public static final String GRAAL_NATIVE_IMAGE_KIND = "org.graalvm.nativeimage.kind";
    public static final Atomos.HeaderProvider NO_OP_HEADER_PROVIDER = (l, h) -> Optional.empty();
    private final boolean DEBUG;
    private final boolean REPORT_RESOLUTION_ERRORS;
    private final String indexPath;
    private final AtomicReference<BundleContext> context = new AtomicReference();
    private final AtomicReference<File> storeRoot = new AtomicReference();
    private ServiceRegistration<?> atomosCommandsReg = null;
    private ServiceRegistration<?> atomosReg = null;
    protected final Map<String, String> config = new ConcurrentHashMap<String, String>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, AtomosLayerBase.AtomosContentBase> connectLocationToAtomosContent = new HashMap<String, AtomosLayerBase.AtomosContentBase>();
    private final Map<String, AtomosLayerBase.AtomosContentBase> atomosLocationToAtomosContent = new HashMap<String, AtomosLayerBase.AtomosContentBase>();
    protected final Map<Object, String> atomosKeyToConnectLocation = new HashMap<Object, String>();
    final Map<Long, AtomosLayerBase> idToLayer = new HashMap<Long, AtomosLayerBase>();
    private final Map<AtomosContent, String> atomosContentToConnectLocation = new HashMap<AtomosContent, String>();
    private final Map<String, AtomosLayerBase.AtomosContentBase> connectedLocations = new HashMap<String, AtomosLayerBase.AtomosContentBase>();
    private final Map<String, AtomosLayerBase.AtomosContentIndexed> packageToAtomosContent = new ConcurrentHashMap<String, AtomosLayerBase.AtomosContentIndexed>();
    protected final AtomicLong nextLayerId = new AtomicLong(0L);
    protected final Atomos.HeaderProvider headerProvider;
    final ThreadLocal<Deque<AtomosContent>> managingConnected = ThreadLocal.withInitial(ArrayDeque::new);
    Thread saveOnVMExit = new Thread(() -> {
        try {
            new AtomosStorage(this).saveLayers(this.storeRoot.get());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save atomos.", e);
        }
    });

    public static Atomos newAtomos(Map<String, String> config, Atomos.HeaderProvider headerProvider) {
        String runtimeClass = config.get(ATOMOS_CLASS_PROP);
        if (runtimeClass != null) {
            return AtomosBase.loadRuntime(runtimeClass, config, headerProvider);
        }
        if (config.get(ATOMOS_LIB_DIR_PROP) != null || System.getProperty(GRAAL_NATIVE_IMAGE_KIND) != null) {
            return new AtomosClassPath(config, headerProvider);
        }
        try {
            Class.forName("java.lang.Module");
            return AtomosBase.loadRuntime(ATOMOS_RUNTIME_MODULES_CLASS, config, headerProvider);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new AtomosClassPath(config, headerProvider);
        }
    }

    private static Atomos loadRuntime(String runtimeClass, Map<String, String> config, Atomos.HeaderProvider headerProvider) {
        try {
            return (AtomosBase)Class.forName(runtimeClass).getConstructor(Map.class, Atomos.HeaderProvider.class).newInstance(config, headerProvider);
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof InvocationTargetException && (cause = e.getCause()) instanceof Exception) {
                e = (Exception)cause;
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
    }

    public File findAtomosLibDir() {
        String libDirProp = this.config.get(ATOMOS_LIB_DIR_PROP);
        return new File(libDirProp, ATOMOS_LIB_DIR);
    }

    protected AtomosBase(Map<String, String> config, Atomos.HeaderProvider headerProvider) {
        this.saveConfig(config);
        this.headerProvider = headerProvider;
        this.DEBUG = Boolean.parseBoolean(this.config.get(ATOMOS_DEBUG_PROP));
        this.REPORT_RESOLUTION_ERRORS = Boolean.parseBoolean(this.config.get(ATOMOS_REPORT_RESOLUTION_PROP));
        this.indexPath = this.getIndexPath(this.config.get(ATOMOS_INDEX_PATH_PROP));
        try {
            Signal.handle(new Signal("INT"), sig -> System.exit(0));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String getIndexPath(String indexPath) {
        if (indexPath == null) {
            indexPath = ATOMOS_BUNDLES_INDEX_DEFAULT;
        } else if (!ATOMOS_IGNORE_INDEX.equals(indexPath) && !indexPath.startsWith("/")) {
            indexPath = "/" + indexPath;
        }
        return indexPath;
    }

    protected final void lockWrite() {
        this.lock.writeLock().lock();
    }

    protected final void unlockWrite() {
        this.lock.writeLock().unlock();
    }

    protected final void lockRead() {
        this.lock.readLock().lock();
    }

    protected final void unlockRead() {
        this.lock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final AtomosLayerBase.AtomosContentBase getByConnectLocation(String location, boolean isManaged) {
        this.lockRead();
        try {
            AtomosLayerBase.AtomosContentBase result = null;
            result = isManaged && !"System Bundle".equals(location) ? this.connectedLocations.get(location) : this.connectLocationToAtomosContent.get(location);
            this.debug("Found content %s for location: %s %s", result, location, isManaged);
            AtomosLayerBase.AtomosContentBase atomosContentBase = result;
            return atomosContentBase;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectAtomosContent(String connectLocation, AtomosLayerBase.AtomosContentBase atomosContent) {
        this.debug("Connecting content: %s %s", atomosContent, connectLocation);
        if (connectLocation == null) {
            throw new IllegalArgumentException("A null connect loation is not allowed.");
        }
        this.lockWrite();
        try {
            AtomosContent existing = this.connectLocationToAtomosContent.get(connectLocation);
            if (existing != null && !atomosContent.equals(existing)) {
                throw new IllegalStateException("The bundle location is already used by the AtomosContent " + existing);
            }
            String computeLocation = this.atomosContentToConnectLocation.compute(atomosContent, (c, l) -> l == null ? connectLocation : l);
            if (!Objects.equals(connectLocation, computeLocation)) {
                throw new IllegalStateException("Atomos content location is already set: " + computeLocation);
            }
            this.connectLocationToAtomosContent.put(connectLocation, atomosContent);
            this.atomosKeyToConnectLocation.put(atomosContent.getKey(), connectLocation);
        }
        finally {
            this.unlockWrite();
        }
    }

    void disconnectAtomosContent(AtomosLayerBase.AtomosContentBase atomosContent) {
        this.debug("Disconnecting connent: %s", atomosContent);
        this.lockWrite();
        try {
            if ("System Bundle".equals(atomosContent.getAtomosLocation())) {
                throw new UnsupportedOperationException("Cannot disconnect the system bundle content");
            }
            String removedLocation = this.atomosContentToConnectLocation.remove(atomosContent);
            if (removedLocation != null) {
                this.debug("Disconnecting location: %s %s", removedLocation, atomosContent);
                this.connectLocationToAtomosContent.remove(removedLocation);
                this.atomosKeyToConnectLocation.remove(atomosContent.getKey());
                this.connectedLocations.remove(removedLocation);
            } else {
                this.debug("No connected location found for content: %s", atomosContent);
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    final AtomosLayerBase.AtomosContentBase getByAtomosLocation(String location) {
        this.lockRead();
        try {
            AtomosLayerBase.AtomosContentBase atomosContentBase = this.atomosLocationToAtomosContent.get(location);
            return atomosContentBase;
        }
        finally {
            this.unlockRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final AtomosLayerBase getById(long id) {
        this.lockRead();
        try {
            AtomosLayerBase atomosLayerBase = this.idToLayer.get(id);
            return atomosLayerBase;
        }
        finally {
            this.unlockRead();
        }
    }

    final String getByAtomosContent(AtomosContent atomosContent) {
        this.lockRead();
        try {
            String string = this.atomosContentToConnectLocation.get(atomosContent);
            return string;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public final AtomosContent getConnectedContent(String bundleLocation) {
        return this.getByConnectLocation(bundleLocation, true);
    }

    final Bundle getBundle(AtomosContent atomosContent) {
        BundleContext bc;
        String location = this.getByAtomosContent(atomosContent);
        if (location != null && atomosContent == this.getByConnectLocation(location, true) && (bc = this.context.get()) != null) {
            return bc.getBundle(location);
        }
        return null;
    }

    protected AtomosLayer addLayer(List<AtomosLayer> parents, String name, long id, AtomosLayer.LoaderType loaderType, Path ... paths) {
        throw new UnsupportedOperationException("Cannot add module layers when Atomos is not loaded as module.");
    }

    @Override
    public final AtomosLayer addLayer(List<AtomosLayer> parents, String name, AtomosLayer.LoaderType loaderType, Path ... modulePaths) {
        return this.addLayer(parents, name, -1L, loaderType, modulePaths);
    }

    @Override
    public ModuleConnector getModuleConnector() {
        return new AtomosModuleConnector(this);
    }

    @Override
    public Framework newFramework(Map<String, String> frameworkConfig) {
        frameworkConfig = frameworkConfig == null ? new HashMap<String, String>() : new HashMap<String, String>(frameworkConfig);
        this.populateConfig(frameworkConfig);
        frameworkConfig.putIfAbsent("osgi.console", "");
        return this.findFrameworkFactory().newFramework(frameworkConfig, this.getModuleConnector());
    }

    public abstract ConnectFrameworkFactory findFrameworkFactory();

    protected final BundleContext getBundleContext() {
        return this.context.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Bundle installAtomosContent(String prefix, AtomosLayerBase.AtomosContentBase atomosContent) throws BundleException {
        Bundle existing;
        AtomosLayerBase atomosLayer;
        if (prefix == null) {
            prefix = "atomos";
        }
        if (prefix.indexOf(58) != -1) {
            throw new IllegalArgumentException("The prefix cannot contain ':'");
        }
        prefix = prefix + ':';
        this.debug("Installing atomos content: %s%s", prefix, atomosContent.getAtomosLocation());
        BundleContext bc = this.context.get();
        if (bc == null) {
            throw new IllegalStateException("Framework has not been initialized.");
        }
        String location = atomosContent.getAtomosLocation();
        if (!"System Bundle".equals(location)) {
            location = prefix + location;
        }
        if ((atomosLayer = (AtomosLayerBase)atomosContent.getAtomosLayer()).isNotValid()) {
            throw new BundleException("Atomos layer has been uninstalled.", 2);
        }
        String existingLoc = this.getByAtomosContent(atomosContent);
        if (existingLoc != null && (existing = bc.getBundle(existingLoc)) != null) {
            if ("System Bundle".equals(existingLoc) || existingLoc.equals(location) && atomosContent.getBundle() == existing) {
                return existing;
            }
            throw new BundleException("Atomos content is already connected with bundle: " + existing, 9);
        }
        atomosContent.disconnect();
        atomosContent.connect(location);
        Bundle result = null;
        try {
            result = bc.installBundle(location);
        }
        finally {
            if (atomosLayer.isNotValid() && result != null) {
                result.uninstall();
                result = null;
            }
        }
        return result;
    }

    final AtomosContent currentlyManagingConnected() {
        return this.managingConnected.get().peekLast();
    }

    final void addManagingConnected(AtomosLayerBase.AtomosContentBase atomosBundle, String location) {
        this.lockWrite();
        try {
            this.connectedLocations.compute(location, (l, a) -> {
                if (a == null || a == atomosBundle) {
                    return atomosBundle;
                }
                throw new IllegalStateException("Atomos connect location is already managed by: " + a);
            });
        }
        finally {
            this.unlockWrite();
        }
        if (this.context.get() != null) {
            this.managingConnected.get().addLast(atomosBundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bundleChanged(BundleEvent event) {
        boolean connectionManaged = true;
        String location = event.getBundle().getLocation();
        switch (event.getType()) {
            case 1: 
            case 8: {
                this.addPackages(event.getBundle());
                AtomosLayerBase.AtomosContentBase content = this.getByConnectLocation(location, true);
                if (content != null) {
                    this.debug("Bundle successfully connected %s", content);
                    connectionManaged = this.managingConnected.get().removeLastOccurrence(content);
                    break;
                }
                connectionManaged = false;
                break;
            }
            case 16: {
                connectionManaged = false;
                break;
            }
        }
        if (!connectionManaged) {
            this.lockWrite();
            try {
                this.debug("Removing location %s as a connected location.", location);
                this.connectedLocations.remove(location);
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (this.REPORT_RESOLUTION_ERRORS && event.getType() == 2 && event.getThrowable() instanceof BundleException && ((BundleException)event.getThrowable()).getType() == 4) {
            BundleRevision rev;
            Bundle b = event.getBundle();
            BundleRevision bundleRevision = rev = b == null ? null : (BundleRevision)b.adapt(BundleRevision.class);
            if (rev != null) {
                rev.getCapabilities("osgi.identity").forEach(i -> {
                    List tags = (List)i.getAttributes().get("tags");
                    if (tags != null && tags.contains("osgi.connect")) {
                        System.out.println("Unable to resolve connected bundle: " + event.getThrowable().getMessage());
                    }
                });
            }
        }
    }

    protected final void addAtomosLayer(AtomosLayerBase atomosLayer) {
        this.addingLayer(atomosLayer);
        if (this.idToLayer.putIfAbsent(atomosLayer.getId(), atomosLayer) != null) {
            throw new IllegalStateException("AtomosLayer already exists for id: " + atomosLayer.getId());
        }
        for (AtomosContent atomosContent : atomosLayer.getAtomosContents()) {
            if (this.atomosLocationToAtomosContent.putIfAbsent(atomosContent.getAtomosLocation(), (AtomosLayerBase.AtomosContentBase)atomosContent) != null) {
                throw new IllegalStateException("Atomos content location already exists: " + atomosContent.getAtomosLocation());
            }
            if (!"System Bundle".equals(atomosContent.getAtomosLocation())) continue;
            this.connectAtomosContent("System Bundle", (AtomosLayerBase.AtomosContentBase)atomosContent);
        }
        for (AtomosLayer parent : atomosLayer.getParents()) {
            ((AtomosLayerBase)parent).addChild(atomosLayer);
        }
    }

    protected abstract void addingLayer(AtomosLayerBase var1);

    protected abstract void removedLayer(AtomosLayerBase var1);

    protected static Map<String, String> getRawHeaders(ConnectContent content) {
        return content.getEntry("META-INF/MANIFEST.MF").map(AtomosBase::getRawHeaders).orElse(new HashMap());
    }

    protected static Map<String, String> getRawHeaders(ConnectContent.ConnectEntry mfEntry) {
        Map<String, String> map;
        block8: {
            InputStream in = mfEntry.getInputStream();
            try {
                map = AtomosBase.toMap(new Manifest(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AtomosBase.sneakyThrow(e);
                    return null;
                }
            }
            in.close();
        }
        return map;
    }

    protected static Map<String, String> toMap(Manifest manifest) {
        HashMap<String, String> result = new HashMap<String, String>();
        Attributes attributes = manifest.getMainAttributes();
        for (Object key : attributes.keySet()) {
            String keyString = key.toString();
            result.put(keyString, manifest.getMainAttributes().getValue(keyString));
        }
        return result;
    }

    public final Optional<Bundle> getBundle(Class<?> classFromBundle) {
        BundleContext bc;
        String location = this.getConnectLocation(classFromBundle);
        if (location != null && (bc = this.context.get()) != null) {
            return Optional.ofNullable(bc.getBundle(location));
        }
        return Optional.empty();
    }

    protected final String getConnectLocation(Class<?> classFromBundle) {
        this.lockRead();
        try {
            String string = this.atomosKeyToConnectLocation.get(this.getAtomosKey(classFromBundle));
            return string;
        }
        finally {
            this.unlockRead();
        }
    }

    protected Object getAtomosKey(Class<?> classFromBundle) {
        AtomosLayerBase.AtomosContentIndexed indexed;
        Package pkg = classFromBundle.getPackage();
        if (pkg != null && (indexed = this.packageToAtomosContent.get(pkg.getName())) != null) {
            return indexed;
        }
        return classFromBundle.getProtectionDomain().getCodeSource().getLocation();
    }

    protected abstract void filterBasedOnReadEdges(AtomosContent var1, Collection<BundleCapability> var2);

    protected final void filterNotVisible(AtomosContent atomosContent, Collection<BundleCapability> candidates) {
        if (atomosContent != null) {
            candidates.removeIf(candidate -> !this.isVisible(atomosContent, (BundleCapability)candidate));
        }
    }

    private boolean isVisible(AtomosContent atomosContent, BundleCapability candidate) {
        AtomosLayerBase.AtomosContentBase candidateAtomos = this.getByConnectLocation(candidate.getRevision().getBundle().getLocation(), true);
        if (candidateAtomos == null) {
            return false;
        }
        AtomosLayer thisLayer = atomosContent.getAtomosLayer();
        return this.isInLayerHierarchy(thisLayer, candidateAtomos.getAtomosLayer());
    }

    final boolean isInLayerHierarchy(AtomosLayer thisLayer, AtomosLayer candLayer) {
        if (thisLayer.equals(candLayer)) {
            return true;
        }
        for (AtomosLayer parent : thisLayer.getParents()) {
            if (!this.isInLayerHierarchy(parent, candLayer)) continue;
            return true;
        }
        return false;
    }

    public static <T> Set<T> asSet(Set<? extends T> l) {
        return l;
    }

    protected void start(BundleContext bc) throws BundleException {
        this.debug("Activating Atomos", new Object[0]);
        this.context.set(bc);
        Runtime.getRuntime().addShutdownHook(this.saveOnVMExit);
        AtomosFrameworkUtilHelper.addHelper(this);
        bc.addBundleListener((BundleListener)this);
        bc.addFrameworkListener((FrameworkListener)this);
        for (Bundle b : bc.getBundles()) {
            this.addPackages(b);
        }
        AtomosFrameworkHooks hooks = new AtomosFrameworkHooks(this);
        bc.registerService(ResolverHookFactory.class, (Object)hooks, null);
        bc.registerService(CollisionHook.class, (Object)hooks, null);
        boolean installBundles = Boolean.parseBoolean(this.getProperty(bc, "atomos.content.install", "true"));
        boolean startBundles = Boolean.parseBoolean(this.getProperty(bc, "atomos.content.start", "true"));
        this.installAtomosContents(this.getBootLayer(), installBundles, startBundles);
        this.atomosReg = bc.registerService(Atomos.class, (Object)this, null);
        this.atomosCommandsReg = new AtomosCommands(this).register(bc);
    }

    void addPackages(Bundle b) {
        block5: {
            AtomosLayerBase.AtomosContentBase atomosContent = (AtomosLayerBase.AtomosContentBase)this.getConnectedContent(b.getLocation());
            if (!(atomosContent instanceof AtomosLayerBase.AtomosContentIndexed)) break block5;
            BundleRevision r = (BundleRevision)b.adapt(BundleRevision.class);
            r.getDeclaredCapabilities("osgi.wiring.package").forEach(p -> this.packageToAtomosContent.putIfAbsent((String)p.getAttributes().get("osgi.wiring.package"), (AtomosLayerBase.AtomosContentIndexed)atomosContent));
            String privatePackages = (String)b.getHeaders("").get("Private-Package");
            if (privatePackages != null) {
                for (String pkgName : privatePackages.split(",")) {
                    pkgName = pkgName.trim();
                    this.packageToAtomosContent.put(pkgName, (AtomosLayerBase.AtomosContentIndexed)atomosContent);
                }
            } else {
                b.getEntry("does.not.exist");
                ConnectContent content = atomosContent.getConnectContent();
                try {
                    content.getEntries().forEach(s -> {
                        if (s.length() > 1 && s.endsWith("/") && s.indexOf(45) < 0) {
                            String pkg = s.substring(0, s.length() - 1).replace('/', '.');
                            this.packageToAtomosContent.put(pkg, (AtomosLayerBase.AtomosContentIndexed)atomosContent);
                        }
                    });
                }
                catch (IOException e) {
                    this.debug("IOException getting entries: %s", e.getMessage());
                }
            }
        }
    }

    protected void stop(BundleContext bc) throws BundleException {
        this.debug("Stopping Atomos", new Object[0]);
        this.context.compareAndSet(bc, null);
        try {
            Runtime.getRuntime().removeShutdownHook(this.saveOnVMExit);
            new AtomosStorage(this).saveLayers(this.storeRoot.get());
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException e) {
            throw new BundleException("Failed to save atomos.", (Throwable)e);
        }
        bc.removeBundleListener((BundleListener)this);
        bc.removeFrameworkListener((FrameworkListener)this);
        AtomosFrameworkUtilHelper.removeHelper(this);
        this.atomosCommandsReg.unregister();
        this.atomosReg.unregister();
    }

    private String getProperty(BundleContext bc, String key, String defaultValue) {
        String result = bc.getProperty(key);
        return result == null ? defaultValue : result;
    }

    private void installAtomosContents(AtomosLayer atomosLayer, boolean installBundles, boolean startBundles) {
        if (installBundles) {
            this.debug("Installing Atomos content.", new Object[0]);
            ArrayList bundles = new ArrayList();
            atomosLayer.getAtomosContents().stream().sorted().forEach(atomosContent -> {
                if (this.getBundle((AtomosContent)atomosContent) == null) {
                    this.debug("Installing AtomosContent: %s", atomosContent);
                    try {
                        Bundle b = atomosContent.install();
                        if (b != null && b.getBundleId() != 0L) {
                            bundles.add(b);
                        }
                    }
                    catch (BundleException e) {
                        this.debug("Failed to install to install %s: %s", atomosContent, e.getMessage());
                    }
                }
            });
            if (startBundles) {
                for (Bundle b : bundles) {
                    this.debug("Starting connected bundle: %s", b);
                    BundleRevision rev = (BundleRevision)b.adapt(BundleRevision.class);
                    if ((rev.getTypes() & 1) != 0) continue;
                    try {
                        b.start();
                    }
                    catch (BundleException e) {
                        this.debug("Failed to install to install %s: %s", e, b, e.getMessage());
                    }
                }
                for (AtomosLayer child : atomosLayer.getChildren()) {
                    this.installAtomosContents(child, installBundles, startBundles);
                }
            }
        }
    }

    public void initialize(File storage, Map<String, String> configuration) {
        this.saveConfig(configuration);
        if (!this.storeRoot.compareAndSet(null, storage)) {
            throw new IllegalStateException("This Atomos is already being used by store: " + this.storeRoot.get());
        }
        try {
            new AtomosStorage(this).loadLayers(storage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void saveConfig(Map<String, String> configuration) {
        configuration.forEach((k, v) -> {
            if (k != null && k.startsWith(ATOMOS_PROP_PREFIX) && v != null) {
                this.config.put((String)k, (String)v);
            }
        });
    }

    public void debug(String message, BundleException e, Object ... args) {
        this.debug(message, args);
        if (this.DEBUG) {
            e.printStackTrace();
        }
    }

    public void debug(String message, Object ... args) {
        if (this.DEBUG) {
            try {
                System.out.println("ATOMOS DEBUG: " + String.format(message, args));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public void populateConfig(Map<String, String> frameworkConfig) {
    }

    protected Map<String, String> applyHeaderProvider(AtomosLayerBase.ManifestHolder holder, String location, Map<String, String> existingHeaders) {
        Optional<Map<String, String>> provided = this.headerProvider.apply(location, Collections.unmodifiableMap(existingHeaders));
        Map<String, String> headers = existingHeaders;
        if (provided.isPresent()) {
            headers = new HashMap<String, String>(provided.get());
        }
        return holder.setHeaders(Optional.of(headers));
    }

    public abstract class AtomosLayerBase
    implements AtomosLayer {
        private final long id;
        private final String name;
        private final AtomosLayer.LoaderType loaderType;
        private final List<AtomosLayer> parents;
        private final Set<AtomosLayer> children = new HashSet<AtomosLayer>();
        private final List<Path> paths;
        private volatile boolean valid = true;
        private volatile Map<String, AtomosContent> nameToBundle;
        private static final String FWK_FACTORY_SERVICE = "META-INF/services/org.osgi.framework.launch.FrameworkFactory";

        public AtomosLayerBase(List<AtomosLayer> parents, long id, String name, AtomosLayer.LoaderType loaderType, Path ... paths) {
            this.id = id;
            this.name = name == null ? "" : name;
            this.paths = Arrays.asList(paths);
            this.parents = parents;
            this.loaderType = loaderType;
        }

        @Override
        public AtomosLayer addLayer(String name, AtomosLayer.LoaderType loaderType, Path ... modulePaths) {
            return AtomosBase.this.addLayer(Collections.singletonList(this), name, -1L, loaderType, modulePaths);
        }

        @Override
        public AtomosLayer addModules(String name, Path path) {
            throw new UnsupportedOperationException("Cannot add module layers when Atomos is not loaded as module.");
        }

        @Override
        public boolean isAddLayerSupported() {
            return false;
        }

        protected final void addChild(AtomosLayerBase child) {
            this.children.add(child);
        }

        protected final void removeChild(AtomosLayerBase child) {
            this.children.remove(child);
        }

        protected final Set<AtomosContentBase> findAtomosContents() {
            LinkedHashSet<AtomosContentBase> bootBundles = new LinkedHashSet<AtomosContentBase>();
            this.findBootModuleLayerAtomosContents(bootBundles);
            this.findAtomosContentsByClassLoaderManifests(bootBundles);
            this.findAtomosIndexedContents(bootBundles);
            return Collections.unmodifiableSet(bootBundles);
        }

        protected abstract void findBootModuleLayerAtomosContents(Set<AtomosContentBase> var1);

        void findAtomosContentsByClassLoaderManifests(Set<AtomosContentBase> result) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                HashSet<URL> parentManifests = new HashSet<URL>();
                if (cl.getParent() != null) {
                    Enumeration<URL> eParentManifests = cl.getParent().getResources("META-INF/MANIFEST.MF");
                    while (eParentManifests.hasMoreElements()) {
                        parentManifests.add(eParentManifests.nextElement());
                    }
                }
                Enumeration<URL> classpathManifests = cl.getResources("META-INF/MANIFEST.MF");
                while (classpathManifests.hasMoreElements()) {
                    String location;
                    URL url;
                    Object connectContent;
                    Object content;
                    URL manifestURL = classpathManifests.nextElement();
                    if (parentManifests.contains(manifestURL) || (content = this.getBundleContent(manifestURL)) == null) continue;
                    ManifestHolder holder = new ManifestHolder();
                    if (content instanceof File) {
                        connectContent = new ConnectContentFile((File)content, holder::getHeaders);
                        url = ((File)content).toURI().toURL();
                    } else {
                        connectContent = new ConnectContentJar(() -> (JarFile)content, dontClose -> {}, holder::getHeaders);
                        url = new File(((JarFile)content).getName()).toURI().toURL();
                    }
                    if (connectContent.getEntry(FWK_FACTORY_SERVICE).isPresent()) {
                        location = "System Bundle";
                    } else {
                        String string = location = content instanceof File ? ((File)content).getPath() : ((JarFile)content).getName();
                        if (!this.getName().isEmpty()) {
                            location = this.getName() + ":" + location;
                        }
                    }
                    Map<String, String> headers = AtomosBase.getRawHeaders(connectContent);
                    String symbolicName = (headers = AtomosBase.this.applyHeaderProvider(holder, location, headers)).get("Bundle-SymbolicName");
                    if (symbolicName == null) continue;
                    int semiColon = symbolicName.indexOf(59);
                    if (semiColon != -1) {
                        symbolicName = symbolicName.substring(0, semiColon);
                    }
                    symbolicName = symbolicName.trim();
                    Version version = Version.parseVersion((String)headers.get("Bundle-Version"));
                    result.add(new AtomosContentClassPath(location, symbolicName, version, (ConnectContent)connectContent, url));
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Error finding class path bundles.", e);
            }
        }

        private void findAtomosIndexedContents(Set<AtomosContentBase> bootBundles) {
            URL index = AtomosBase.ATOMOS_IGNORE_INDEX.equals(AtomosBase.this.indexPath) ? null : this.getClass().getResource(AtomosBase.this.indexPath);
            AtomosBase.this.debug("Atomos index url: %s", index);
            if (index != null) {
                this.findAtomosIndexedContent(index, bootBundles);
            } else {
                File atomosLibDir = AtomosBase.this.findAtomosLibDir();
                if (atomosLibDir.isDirectory()) {
                    this.findAtomosLibIndexedContent(bootBundles, atomosLibDir);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void findAtomosLibIndexedContent(Set<AtomosContentBase> bootBundles, File atomosLibDir) {
            for (File f : atomosLibDir.listFiles()) {
                if (!f.isFile()) continue;
                try (JarFile jar = new JarFile(f);){
                    String location;
                    ManifestHolder holder = new ManifestHolder();
                    connectContent.open();
                    try (ConnectContentCloseableJar connectContent = new ConnectContentCloseableJar(f.getName(), () -> atomosLibDir, holder::getHeaders);){
                        if (connectContent.getEntry(FWK_FACTORY_SERVICE).isPresent()) {
                            location = "System Bundle";
                        } else {
                            location = f.getName();
                            if (!this.getName().isEmpty()) {
                                location = this.getName() + ":" + location;
                            }
                        }
                    }
                    Map<String, String> headers = AtomosBase.toMap(jar.getManifest());
                    headers = AtomosBase.this.applyHeaderProvider(holder, location, headers);
                    String symbolicName = headers.get("Bundle-SymbolicName");
                    if (symbolicName == null) continue;
                    int semiColon = symbolicName.indexOf(59);
                    if (semiColon != -1) {
                        symbolicName = symbolicName.substring(0, semiColon);
                    }
                    symbolicName = symbolicName.trim();
                    Version version = Version.parseVersion((String)headers.get("Bundle-Version"));
                    AtomosContentIndexed bundle = new AtomosContentIndexed(location, symbolicName, version, connectContent);
                    bootBundles.add(bundle);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private AtomosContentIndexed createIndexedContent(String indexRoot, String currentIndex, String currentBSN, Version currentVersion, List<String> currentPaths) {
            ManifestHolder holder = new ManifestHolder();
            String bundleIndexPath = indexRoot + currentIndex;
            ConnectContentIndexed content = new ConnectContentIndexed(bundleIndexPath, currentPaths, holder::getHeaders);
            AtomosBase.this.debug("Found indexed content: %s %s %s %s", currentIndex, currentBSN, currentVersion, currentPaths);
            String location = this.getIndexedLocation(content, currentBSN);
            if (AtomosBase.this.headerProvider != NO_OP_HEADER_PROVIDER) {
                Map<String, String> headers = AtomosBase.this.applyHeaderProvider(holder, location, AtomosBase.getRawHeaders(content));
                String symbolicName = headers.get("Bundle-SymbolicName");
                if (symbolicName == null) {
                    throw new IllegalStateException("Expecting a symbolic name for index bundle: " + currentBSN);
                }
                int semiColon = symbolicName.indexOf(59);
                if (semiColon != -1) {
                    symbolicName = symbolicName.substring(0, semiColon);
                }
                currentBSN = symbolicName = symbolicName.trim();
                currentVersion = Version.parseVersion((String)headers.get("Bundle-Version"));
            }
            return new AtomosContentIndexed(location, currentBSN, currentVersion, content);
        }

        private void findAtomosIndexedContent(URL index, Set<AtomosContentBase> bootBundles) {
            String indexRoot = AtomosBase.this.indexPath.substring(0, AtomosBase.this.indexPath.lastIndexOf(47) + 1);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(index.openStream()));){
                String currentIndex = null;
                String currentBSN = null;
                Version currentVersion = null;
                ArrayList<String> currentPaths = null;
                String line = reader.readLine();
                while (AtomosBase.ATOMOS_BUNDLE.equals(line)) {
                    if (currentIndex != null) {
                        bootBundles.add(this.createIndexedContent(indexRoot, currentIndex, currentBSN, currentVersion, currentPaths));
                    }
                    currentIndex = null;
                    currentBSN = null;
                    currentVersion = null;
                    currentPaths = new ArrayList<String>();
                    while ((line = reader.readLine()) != null && !AtomosBase.ATOMOS_BUNDLE.equals(line)) {
                        if (currentIndex == null) {
                            currentIndex = line;
                            continue;
                        }
                        if (currentBSN == null) {
                            currentBSN = line;
                            continue;
                        }
                        if (currentVersion == null) {
                            currentVersion = Version.valueOf((String)line);
                            continue;
                        }
                        currentPaths.add(line);
                    }
                }
                if (currentIndex != null) {
                    bootBundles.add(this.createIndexedContent(indexRoot, currentIndex, currentBSN, currentVersion, currentPaths));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String getIndexedLocation(ConnectContent content, String location) {
            return content.getEntry(FWK_FACTORY_SERVICE).map(e -> "System Bundle").orElseGet(() -> {
                String qualified = location;
                if (!this.getName().isEmpty()) {
                    qualified = this.getName() + ":" + location;
                }
                return qualified;
            });
        }

        private Object getBundleContent(URL manifest) {
            if (AtomosBase.JAR_PROTOCOL.equals(manifest.getProtocol())) {
                try {
                    URLConnection conn = manifest.openConnection();
                    if (conn instanceof JarURLConnection) {
                        return ((JarURLConnection)conn).getJarFile();
                    }
                }
                catch (IOException conn) {}
            } else if (AtomosBase.FILE_PROTOCOL.equals(manifest.getProtocol())) {
                try {
                    File f = new File(manifest.toURI());
                    return f.getParentFile().getParentFile();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final Set<AtomosLayer> getChildren() {
            AtomosBase.this.lockRead();
            try {
                HashSet<AtomosLayer> hashSet = new HashSet<AtomosLayer>(this.children);
                return hashSet;
            }
            finally {
                AtomosBase.this.unlockRead();
            }
        }

        @Override
        public final List<AtomosLayer> getParents() {
            return this.parents;
        }

        final List<Path> getPaths() {
            return this.paths;
        }

        @Override
        public final long getId() {
            return this.id;
        }

        @Override
        public final AtomosLayer.LoaderType getLoaderType() {
            return this.loaderType;
        }

        @Override
        public final void uninstall() throws BundleException {
            ArrayList<Bundle> uninstalledBundles = new ArrayList<Bundle>();
            BundleContext bc = AtomosBase.this.getBundleContext();
            if (bc != null) {
                this.uninstallLayer(uninstalledBundles);
            }
            AtomosBase.this.lockWrite();
            try {
                this.removeLayerFromRuntime();
            }
            finally {
                AtomosBase.this.unlockWrite();
            }
            if (bc != null) {
                ((FrameworkWiring)bc.getBundle("System Bundle").adapt(FrameworkWiring.class)).refreshBundles(uninstalledBundles, new FrameworkListener[0]);
            }
        }

        private void removeLayerFromRuntime() {
            for (AtomosLayer parent : this.getParents()) {
                ((AtomosLayerBase)parent).removeChild(this);
            }
            for (AtomosLayer child : this.getChildren()) {
                ((AtomosLayerBase)child).removeLayerFromRuntime();
            }
            this.getAtomosContents().forEach(AtomosContent::disconnect);
            AtomosBase.this.idToLayer.remove(this.getId());
            AtomosBase.this.removedLayer(this);
        }

        final void uninstallLayer(List<Bundle> uninstalledBundles) throws BundleException {
            this.valid = false;
            if (AtomosBase.this.getBootLayer().equals(this)) {
                throw new UnsupportedOperationException("Cannot uninstall the boot layer.");
            }
            for (AtomosLayer child : this.getChildren()) {
                ((AtomosLayerBase)child).uninstallLayer(uninstalledBundles);
            }
            this.uninstallBundles(uninstalledBundles);
        }

        final boolean isNotValid() {
            return !this.valid;
        }

        private void uninstallBundles(List<Bundle> uninstalled) throws BundleException {
            for (AtomosContent content : this.getAtomosContents()) {
                Bundle b = content.getBundle();
                if (b == null) continue;
                uninstalled.add(b);
                b.uninstall();
            }
        }

        public final String toString() {
            Set<AtomosLayer> children;
            StringBuilder result = new StringBuilder();
            result.append('[').append(this.getId()).append(']');
            result.append(' ').append(this.getName());
            result.append(' ').append((Object)this.getLoaderType());
            List<AtomosLayer> parents = this.getParents();
            if (!parents.isEmpty()) {
                result.append(" PARENTS: {");
                for (AtomosLayer parent : parents) {
                    result.append("[").append(parent.getId()).append(']');
                    result.append(' ').append(parent.getName()).append(", ");
                }
                result.delete(result.length() - 2, result.length());
                result.append("}");
            }
            if (!(children = this.getChildren()).isEmpty()) {
                result.append(" CHILDREN: {");
                for (AtomosLayer child : this.getChildren()) {
                    result.append("[").append(child.getId()).append(']');
                    result.append(' ').append(child.getName()).append(", ");
                }
                result.delete(result.length() - 2, result.length());
                result.append("}");
            }
            return result.toString();
        }

        @Override
        public <T> Optional<T> adapt(Class<T> type) {
            return Optional.empty();
        }

        @Override
        public Optional<AtomosContent> findAtomosContent(String symbolicName) {
            Map<String, AtomosContent> nameToBundle = this.nameToBundle;
            if (nameToBundle == null) {
                Map<String, AtomosContent> populate = nameToBundle = new HashMap<String, AtomosContent>();
                this.getAtomosContents().forEach(a -> populate.putIfAbsent(a.getSymbolicName(), (AtomosContent)a));
                HashSet<AtomosLayer> visited = new HashSet<AtomosLayer>();
                ArrayDeque<AtomosLayer> stack = new ArrayDeque<AtomosLayer>();
                visited.add(this);
                stack.push(this);
                while (!stack.isEmpty()) {
                    AtomosLayer layer = (AtomosLayer)stack.pop();
                    layer.getAtomosContents().forEach(a -> populate.putIfAbsent(a.getSymbolicName(), (AtomosContent)a));
                    List<AtomosLayer> parents = layer.getParents();
                    for (int i = parents.size() - 1; i >= 0; --i) {
                        AtomosLayer parent = parents.get(i);
                        if (visited.contains(parent)) continue;
                        visited.add(parent);
                        stack.push(parent);
                    }
                }
                this.nameToBundle = populate;
            }
            return Optional.ofNullable(nameToBundle.get(symbolicName));
        }

        public final class ManifestHolder {
            private volatile Optional<Map<String, String>> headers = Optional.empty();

            public Map<String, String> setHeaders(Optional<Map<String, String>> headers) {
                this.headers = headers;
                return headers.get();
            }

            public Optional<Map<String, String>> getHeaders() {
                return this.headers;
            }
        }

        public class AtomosContentIndexed
        extends AtomosContentBase {
            public AtomosContentIndexed(String location, String symbolicName, Version version, ConnectContent content) {
                super(location, symbolicName, version, content);
            }

            @Override
            protected final Object getKey() {
                return this;
            }
        }

        public class AtomosContentClassPath
        extends AtomosContentBase {
            private final URL contentURL;

            public AtomosContentClassPath(String location, String symbolicName, Version version, ConnectContent connectContent, URL url) {
                super(location, symbolicName, version, connectContent);
                this.contentURL = url;
            }

            @Override
            protected final Object getKey() {
                return this.contentURL;
            }
        }

        public abstract class AtomosContentBase
        implements AtomosContent,
        Comparable<AtomosContent> {
            private final String location;
            private final String symbolicName;
            private final Version version;
            private final ConnectContent content;

            public AtomosContentBase(String location, String symbolicName, Version version, ConnectContent content) {
                this.location = location;
                this.symbolicName = symbolicName;
                this.version = version;
                this.content = content;
            }

            @Override
            public final String getAtomosLocation() {
                return this.location;
            }

            @Override
            public final String getSymbolicName() {
                return this.symbolicName;
            }

            @Override
            public final Version getVersion() {
                return this.version;
            }

            @Override
            public <T> Optional<T> adapt(Class<T> type) {
                return Optional.empty();
            }

            @Override
            public final AtomosLayer getAtomosLayer() {
                return AtomosLayerBase.this;
            }

            public final boolean equals(Object o) {
                if (!(o instanceof AtomosContentBase)) {
                    return false;
                }
                AtomosContentBase info = (AtomosContentBase)o;
                return this.getSymbolicName().equals(info.getSymbolicName()) && this.getVersion().equals((Object)info.getVersion()) && this.getAtomosLayer() == info.getAtomosLayer();
            }

            public final int hashCode() {
                return this.getSymbolicName().hashCode() ^ this.getVersion().hashCode();
            }

            @Override
            public final int compareTo(AtomosContent o) {
                int bsnCompare = this.getSymbolicName().compareTo(o.getSymbolicName());
                if (bsnCompare != 0) {
                    return bsnCompare;
                }
                int vCompare = -this.getVersion().compareTo(o.getVersion());
                if (vCompare != 0) {
                    return vCompare;
                }
                return this.getAtomosLocation().compareTo(o.getAtomosLocation());
            }

            protected abstract Object getKey();

            @Override
            public ConnectContent getConnectContent() {
                AtomosBase.this.debug("Getting connect content for %s", this);
                return this.content;
            }

            public final String toString() {
                return this.symbolicName;
            }

            @Override
            public final Bundle install(String prefix) throws BundleException {
                return AtomosBase.this.installAtomosContent(prefix, this);
            }

            @Override
            public Bundle getBundle() {
                return AtomosBase.this.getBundle(this);
            }

            @Override
            public String getConnectLocation() {
                return AtomosBase.this.getByAtomosContent(this);
            }

            @Override
            public void connect(String bundleLocation) {
                AtomosBase.this.connectAtomosContent(bundleLocation, this);
            }

            @Override
            public void disconnect() {
                AtomosBase.this.disconnectAtomosContent(this);
            }
        }
    }

    public static enum Index {
        IGNORE,
        FIRST;

    }
}

