/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.impl.modules;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.Atomos;
import org.apache.felix.atomos.AtomosContent;
import org.apache.felix.atomos.AtomosLayer;
import org.apache.felix.atomos.impl.base.AtomosBase;
import org.apache.felix.atomos.impl.modules.ConnectContentModule;
import org.apache.felix.atomos.impl.modules.ModuleConnectLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.connect.ConnectContent;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.launch.FrameworkFactory;
import org.osgi.framework.wiring.BundleCapability;

public class AtomosModules
extends AtomosBase {
    private static final String ATOMOS_GENERATED = "Atomos-GeneratedManifest";
    private static final String ATOMOS_TEMPORARY_GENERATED_REQUIRES = "Atomos-TemporaryGeneratedRequires";
    private final Module thisModule = AtomosModules.class.getModule();
    private final Configuration thisConfig = this.thisModule.getLayer() == null ? null : this.thisModule.getLayer().configuration();
    private final Map<Configuration, AtomosBase.AtomosLayerBase> byConfig = new HashMap<Configuration, AtomosBase.AtomosLayerBase>();
    private final AtomosLayer bootLayer = this.createBootLayer();

    public AtomosModules(Map<String, String> config, Atomos.HeaderProvider headerProvider) {
        super(config, headerProvider);
    }

    private AtomosLayer createBootLayer() {
        return this.createAtomosLayer(this.thisConfig, "boot", -1L, AtomosLayer.LoaderType.SINGLE, new Path[0]);
    }

    AtomosBase.AtomosLayerBase getByConfig(Configuration config) {
        this.lockRead();
        try {
            AtomosBase.AtomosLayerBase atomosLayerBase = this.byConfig.get(config);
            return atomosLayerBase;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    protected AtomosLayer addLayer(List<AtomosLayer> parents, String name, long id, AtomosLayer.LoaderType loaderType, Path ... paths) {
        if (parents.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one parent layer.");
        }
        if (this.bootLayer.adapt(ModuleLayer.class).isEmpty()) {
            throw new UnsupportedOperationException("Cannot add module layers when Atomos is not loaded as module.");
        }
        List<Configuration> parentConfigs = parents.stream().map(l -> l.adapt(ModuleLayer.class).get().configuration()).collect(Collectors.toList());
        ModuleFinder finder = ModuleFinder.of(paths);
        List<String> roots = finder.findAll().stream().map(m -> m.descriptor().name()).collect(Collectors.toList());
        Configuration config = Configuration.resolve(ModuleFinder.of(new Path[0]), parentConfigs, ModuleFinder.of(paths), roots);
        return this.createAtomosLayer(config, name, id, loaderType, paths);
    }

    @Override
    public ConnectFrameworkFactory findFrameworkFactory() {
        ServiceLoader<ConnectFrameworkFactory> loader = Atomos.class.getModule().getLayer() == null ? ServiceLoader.load(ConnectFrameworkFactory.class, this.getClass().getClassLoader()) : ServiceLoader.load(this.getClass().getModule().getLayer(), ConnectFrameworkFactory.class);
        return loader.findFirst().orElseThrow(() -> new RuntimeException("No Framework implementation found."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AtomosBase.AtomosLayerBase createAtomosLayer(Configuration config, String name, long id, AtomosLayer.LoaderType loaderType, Path ... paths) {
        AtomosBase.AtomosLayerBase existing = this.getByConfig(config);
        if (existing != null) {
            return existing;
        }
        existing = this.getById(id);
        if (existing != null) {
            throw new IllegalArgumentException("The a layer already exists with the id: " + id + " " + existing.getName());
        }
        this.lockWrite();
        try {
            List<AtomosLayer> parents = this.findParents(config, name);
            long l = id = id < 0L ? this.nextLayerId.getAndIncrement() : id;
            if (Configuration.empty().equals(config)) {
                name = "empty";
            }
            AtomosLayerModules result = new AtomosLayerModules(config, parents, id, name, loaderType, paths);
            this.addAtomosLayer(result);
            AtomosLayerModules atomosLayerModules = result;
            return atomosLayerModules;
        }
        finally {
            this.unlockWrite();
        }
    }

    private List<AtomosLayer> findParents(Configuration config, String name) {
        if (config == null || config.parents().isEmpty()) {
            return List.of();
        }
        ArrayList<AtomosBase.AtomosLayerBase> found = new ArrayList<AtomosBase.AtomosLayerBase>(config.parents().size());
        for (Configuration parentConfig : config.parents()) {
            AtomosBase.AtomosLayerBase existingParent = this.getByConfig(parentConfig);
            if (existingParent != null) {
                found.add(existingParent);
                continue;
            }
            found.add(this.createAtomosLayer(parentConfig, name, -1L, AtomosLayer.LoaderType.SINGLE, new Path[0]));
        }
        return Collections.unmodifiableList(found);
    }

    @Override
    protected void addingLayer(AtomosBase.AtomosLayerBase atomosLayer) {
        Configuration config = atomosLayer.adapt(ModuleLayer.class).map(ModuleLayer::configuration).orElse(null);
        if (this.byConfig.putIfAbsent(config, atomosLayer) != null) {
            throw new IllegalStateException("AtomosLayer already exists for configuration.");
        }
    }

    @Override
    protected void removedLayer(AtomosBase.AtomosLayerBase atomosLayer) {
        this.byConfig.remove(atomosLayer.adapt(ModuleLayer.class).map(ModuleLayer::configuration).orElse(null));
    }

    ModuleLayer findModuleLayer(Configuration config, List<AtomosLayer> parents, AtomosLayer.LoaderType loaderType) {
        if (config == null) {
            return null;
        }
        if (config.equals(this.thisConfig)) {
            return this.thisModule.getLayer();
        }
        if (Configuration.empty().equals(config)) {
            return ModuleLayer.empty();
        }
        List<ModuleLayer> parentLayers = ((Stream)parents.stream().sequential()).map(a -> a.adapt(ModuleLayer.class).get()).collect(Collectors.toList());
        switch (loaderType) {
            case SINGLE: {
                return ModuleLayer.defineModulesWithOneLoader(config, parentLayers, null).layer();
            }
            case OSGI: {
                ConcurrentHashMap classLoaders = new ConcurrentHashMap();
                Function<String, ClassLoader> clf = moduleName -> {
                    ResolvedModule m = config.findModule((String)moduleName).orElse(null);
                    if (m == null || m.configuration() != config) {
                        return null;
                    }
                    return classLoaders.computeIfAbsent(moduleName, mn -> {
                        try {
                            return new ModuleConnectLoader(m, this);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    });
                };
                ModuleLayer.Controller controller = ModuleLayer.defineModules(config, parentLayers, clf);
                controller.layer().modules().forEach(m -> {
                    ModuleConnectLoader loader = (ModuleConnectLoader)m.getClassLoader();
                    loader.initEdges((Module)m, config, classLoaders);
                });
                return controller.layer();
            }
            case MANY: {
                return ModuleLayer.defineModulesWithManyLoaders(config, parentLayers, null).layer();
            }
        }
        throw new UnsupportedOperationException(loaderType.toString());
    }

    @Override
    public AtomosLayer getBootLayer() {
        return this.bootLayer;
    }

    @Override
    protected Object getAtomosKey(Class<?> classFromBundle) {
        Module m = classFromBundle.getModule();
        if (m != null && m.isNamed()) {
            return m;
        }
        return super.getAtomosKey(classFromBundle);
    }

    @Override
    protected void filterBasedOnReadEdges(AtomosContent atomosContent, Collection<BundleCapability> candidates) {
        if (atomosContent == null) {
            return;
        }
        Module m = atomosContent.adapt(Module.class).orElse(null);
        if (m == null) {
            this.filterNotVisible(atomosContent, candidates);
        } else {
            Iterator<BundleCapability> iCands = candidates.iterator();
            while (iCands.hasNext()) {
                BundleCapability candidate = iCands.next();
                AtomosBase.AtomosLayerBase.AtomosContentBase candidateAtomos = this.getByConnectLocation(candidate.getRevision().getBundle().getLocation(), true);
                if (candidateAtomos == null || candidateAtomos.adapt(Module.class).isEmpty()) {
                    iCands.remove();
                    continue;
                }
                if (m.canRead(candidateAtomos.adapt(Module.class).get())) continue;
                iCands.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getBundle(Module module) {
        String location;
        if (module == null) {
            return null;
        }
        this.lockRead();
        try {
            location = (String)this.atomosKeyToConnectLocation.get(module);
            if (location == null) {
                Bundle bundle = null;
                return bundle;
            }
        }
        finally {
            this.unlockRead();
        }
        BundleContext bc = this.getBundleContext();
        if (bc == null) {
            return null;
        }
        return bc.getBundle(location);
    }

    @Override
    public void populateConfig(Map<String, String> config) {
        super.populateConfig(config);
        if (config.get("org.osgi.framework.system.packages") == null) {
            config.put("org.osgi.framework.system.packages", "");
        }
    }

    public class AtomosLayerModules
    extends AtomosBase.AtomosLayerBase {
        private final ModuleLayer moduleLayer;
        private final Set<AtomosBase.AtomosLayerBase.AtomosContentBase> atomosBundles;
        private final Map<Module, AtomosBase.AtomosLayerBase.AtomosContentBase> atomosModules;

        AtomosLayerModules(Configuration config, List<AtomosLayer> parents, long id, String name, AtomosLayer.LoaderType loaderType, Path ... paths) {
            super(parents, id, name, loaderType, paths);
            this.moduleLayer = AtomosModules.this.findModuleLayer(config, parents, loaderType);
            this.atomosBundles = this.findAtomosLayerContent();
            this.atomosModules = this.atomosBundles.stream().filter(a -> a.adapt(Module.class).isPresent()).collect(Collectors.toUnmodifiableMap(k -> k.adapt(Module.class).get(), v -> v));
            for (AtomosBase.AtomosLayerBase.AtomosContentBase content : this.atomosBundles) {
                Module m = content.adapt(Module.class).orElse(null);
                if (m == null) continue;
                content.getConnectContent().getHeaders().ifPresent(headers -> {
                    if (Boolean.parseBoolean((String)headers.get(AtomosModules.ATOMOS_GENERATED)) && Boolean.parseBoolean((String)headers.get(AtomosModules.ATOMOS_TEMPORARY_GENERATED_REQUIRES))) {
                        this.calculateRequires((Map<String, String>)headers, m, requires -> m.getLayer().findModule((String)requires).map(requiredModule -> this.getAtomosContent((Module)requiredModule).getSymbolicName()).orElse((String)requires));
                        headers.remove(AtomosModules.ATOMOS_TEMPORARY_GENERATED_REQUIRES);
                    }
                });
            }
        }

        @Override
        public boolean isAddLayerSupported() {
            return AtomosModules.this.thisConfig != null;
        }

        @Override
        public AtomosLayer addModules(String name, Path path) {
            if (this.isAddLayerSupported()) {
                ResolvedModule resolved;
                URI location;
                if (path == null && (location = (resolved = AtomosModules.this.thisConfig.findModule(Atomos.class.getModule().getName()).get()).reference().location().get()).getScheme().equals("file")) {
                    File thisModuleFile = new File(location);
                    File candidate = new File(thisModuleFile.getParent(), name);
                    Path path2 = path = candidate.isDirectory() ? candidate.toPath() : null;
                }
                if (path != null) {
                    return this.addLayer(name, AtomosLayer.LoaderType.OSGI, path);
                }
                return null;
            }
            return super.addModules(name, path);
        }

        private Set<AtomosBase.AtomosLayerBase.AtomosContentBase> findAtomosLayerContent() {
            return this.moduleLayer == null ? this.findAtomosContents() : this.findModuleLayerAtomosBundles(this.moduleLayer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<AtomosBase.AtomosLayerBase.AtomosContentBase> findModuleLayerAtomosBundles(ModuleLayer searchLayer) {
            LinkedHashSet<AtomosContentModule> found = new LinkedHashSet<AtomosContentModule>();
            Map<ModuleDescriptor, Module> descriptorMap = searchLayer.modules().stream().collect(Collectors.toMap(Module::getDescriptor, m -> m));
            for (ResolvedModule resolved : searchLayer.configuration().modules()) {
                Map headers;
                String location;
                Module m2 = descriptorMap.get(resolved.reference().descriptor());
                if (m2 == null || (location = m2.getDescriptor().provides().stream().anyMatch(p -> FrameworkFactory.class.getName().equals(p.service())) ? "System Bundle" : (String)resolved.reference().location().map(u -> {
                    StringBuilder sb = new StringBuilder();
                    if (!this.getName().isEmpty()) {
                        sb.append(this.getName()).append(':');
                    }
                    sb.append(u.toString());
                    return sb.toString();
                }).orElse(null)) == null) continue;
                AtomosBase.AtomosLayerBase.ManifestHolder holder = new AtomosBase.AtomosLayerBase.ManifestHolder();
                ConnectContentModule content = new ConnectContentModule(m2, resolved.reference(), this, holder::getHeaders);
                try {
                    content.open();
                    try {
                        headers = AtomosModules.getRawHeaders(content);
                    }
                    finally {
                        content.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error reading connect manifest.", e);
                }
                this.generateHeaders(headers, m2);
                String symbolicName = (String)(headers = AtomosModules.this.applyHeaderProvider(holder, location, headers)).get("Bundle-SymbolicName");
                if (symbolicName == null) continue;
                int semiColon = symbolicName.indexOf(59);
                if (semiColon != -1) {
                    symbolicName = symbolicName.substring(0, semiColon);
                }
                symbolicName = symbolicName.trim();
                Version version = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
                found.add(new AtomosContentModule(m2, location, symbolicName, version, content));
            }
            return Collections.unmodifiableSet(found);
        }

        private void generateHeaders(Map<String, String> headers, Module m) {
            ModuleDescriptor desc = m.getDescriptor();
            StringBuilder capabilities = new StringBuilder();
            StringBuilder requirements = new StringBuilder();
            String bsn = headers.get("Bundle-SymbolicName");
            if (bsn == null) {
                Version v;
                headers.put("Bundle-ManifestVersion", "2");
                headers.put("Bundle-SymbolicName", desc.name() + "; " + "fragment-attachment" + ":=" + "never");
                try {
                    v = Version.parseVersion((String)desc.version().map(ModuleDescriptor.Version::toString).orElse("0"));
                }
                catch (IllegalArgumentException e) {
                    v = Version.emptyVersion;
                }
                headers.put("Bundle-Version", v.toString());
                StringBuilder exportPackageHeader = new StringBuilder();
                desc.exports().stream().sorted().forEach(exports -> {
                    if (exportPackageHeader.length() > 0) {
                        exportPackageHeader.append(", ");
                    }
                    exportPackageHeader.append(exports.source());
                });
                if (exportPackageHeader.length() > 0) {
                    headers.put("Export-Package", exportPackageHeader.toString());
                }
                headers.put(AtomosModules.ATOMOS_GENERATED, Boolean.TRUE.toString());
                if (this.calculateRequires(headers, m, Function.identity())) {
                    headers.put(AtomosModules.ATOMOS_TEMPORARY_GENERATED_REQUIRES, Boolean.TRUE.toString());
                }
            } else {
                String origReqs;
                String origCaps = headers.get("Provide-Capability");
                if (origCaps != null) {
                    capabilities.append(origCaps);
                }
                if ((origReqs = headers.get("Require-Capability")) != null) {
                    requirements.append(origReqs);
                }
            }
            for (ModuleDescriptor.Provides provides : desc.provides()) {
                if (capabilities.length() > 0) {
                    capabilities.append(", ");
                }
                capabilities.append("atomos.java.service").append("; ");
                capabilities.append("atomos.java.service").append("=").append(provides.service()).append("; ");
                capabilities.append("provides.with").append("=\"").append(String.join((CharSequence)",", provides.providers())).append("\"");
            }
            for (String uses : desc.uses()) {
                if (requirements.length() > 0) {
                    requirements.append(", ");
                }
                requirements.append("atomos.java.service").append("; ");
                requirements.append("resolution").append(":=").append("optional").append("; ");
                requirements.append("filter").append(":=").append("\"(").append("atomos.java.service").append("=").append(uses).append(")\"");
            }
            if (capabilities.length() > 0) {
                headers.put("Provide-Capability", capabilities.toString());
            }
            if (requirements.length() > 0) {
                headers.put("Require-Capability", requirements.toString());
            }
        }

        private boolean calculateRequires(Map<String, String> headers, Module m, Function<String, String> mapper) {
            StringBuilder requireBundleHeader = new StringBuilder();
            for (ModuleDescriptor.Requires requires : m.getDescriptor().requires()) {
                if (requireBundleHeader.length() > 0) {
                    requireBundleHeader.append(", ");
                }
                String mapping = mapper.apply(requires.name());
                requireBundleHeader.append(mapping).append("; ");
                String resolution = requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC) ? "optional" : "mandatory";
                requireBundleHeader.append("resolution").append(":=").append(resolution).append("; ");
                String visibility = requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE) ? "reexport" : "private";
                requireBundleHeader.append("visibility").append(":=").append(visibility);
            }
            if (requireBundleHeader.length() > 0) {
                headers.put("Require-Bundle", requireBundleHeader.toString());
                return true;
            }
            return false;
        }

        @Override
        public <T> Optional<T> adapt(Class<T> type) {
            if (ModuleLayer.class.equals(type)) {
                return Optional.ofNullable(this.moduleLayer);
            }
            return super.adapt(type);
        }

        @Override
        public Set<AtomosContent> getAtomosContents() {
            return AtomosBase.asSet(this.atomosBundles);
        }

        @Override
        protected void findBootModuleLayerAtomosContents(Set<AtomosBase.AtomosLayerBase.AtomosContentBase> result) {
            result.addAll(this.findModuleLayerAtomosBundles(ModuleLayer.boot()));
        }

        AtomosBase.AtomosLayerBase.AtomosContentBase getAtomosContent(Module m) {
            AtomosBase.AtomosLayerBase.AtomosContentBase result = this.atomosModules.get(m);
            if (result != null) {
                return result;
            }
            for (AtomosLayer parent : this.getParents()) {
                if (parent instanceof AtomosLayerModules) {
                    result = ((AtomosLayerModules)parent).getAtomosContent(m);
                }
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public class AtomosContentModule
        extends AtomosBase.AtomosLayerBase.AtomosContentBase {
            private final Module module;

            public AtomosContentModule(Module module, String location, String symbolicName, Version version, ConnectContent content) {
                super(location, symbolicName, version, content);
                this.module = module;
            }

            @Override
            protected final Object getKey() {
                return this.module;
            }

            @Override
            public <T> Optional<T> adapt(Class<T> type) {
                if (Module.class.equals(type)) {
                    return Optional.ofNullable(this.module);
                }
                return super.adapt(type);
            }
        }
    }
}

