/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.connect.BundleAware;
import org.apache.felix.connect.DirRevision;
import org.apache.felix.connect.ExportedPackageImpl;
import org.apache.felix.connect.JarRevision;
import org.apache.felix.connect.PojoSRBundle;
import org.apache.felix.connect.PojoSRBundleContext;
import org.apache.felix.connect.PojoServiceRegistryFactoryImpl;
import org.apache.felix.connect.RequiredBundleImpl;
import org.apache.felix.connect.Revision;
import org.apache.felix.connect.URLRevision;
import org.apache.felix.connect.VFSRevision;
import org.apache.felix.connect.felix.framework.ServiceRegistry;
import org.apache.felix.connect.felix.framework.util.EventDispatcher;
import org.apache.felix.connect.launch.BundleDescriptor;
import org.apache.felix.connect.launch.ClasspathScanner;
import org.apache.felix.connect.launch.PojoServiceRegistry;
import org.apache.felix.connect.launch.PojoServiceRegistryFactory;
import org.jboss.vfs.VFS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.osgi.service.startlevel.StartLevel;

public class PojoSR
implements PojoServiceRegistry {
    private final BundleContext m_context;
    private final ServiceRegistry m_registry = new ServiceRegistry(new ServiceRegistry.ServiceRegistryCallbacks(){

        @Override
        public void serviceChanged(ServiceEvent event, Dictionary<String, ?> oldProps) {
            PojoSR.this.m_dispatcher.fireServiceEvent(event, oldProps, (Bundle)PojoSR.this.m_bundles.get(0L));
        }
    });
    private final EventDispatcher m_dispatcher = new EventDispatcher(this.m_registry);
    private final Map<Long, Bundle> m_bundles = new HashMap<Long, Bundle>();
    private final Map<String, Object> bundleConfig;
    private final boolean m_hasVFS;

    public static BundleDescriptor createSystemBundle() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "org.apache.felix.connect");
        headers.put("Bundle-Version", "0.0.0");
        headers.put("Bundle-Name", "System Bundle");
        headers.put("Bundle-ManifestVersion", "2");
        headers.put("Bundle-Vendor", "Apache Software Foundation");
        Revision revision = new Revision(){
            final long lastModified = System.currentTimeMillis();

            @Override
            public long getLastModified() {
                return this.lastModified;
            }

            @Override
            public Enumeration<String> getEntries() {
                return Collections.enumeration(Collections.EMPTY_LIST);
            }

            @Override
            public URL getEntry(String entryName) {
                return this.getClass().getClassLoader().getResource(entryName);
            }
        };
        HashMap<Class, Object> services = new HashMap<Class, Object>();
        services.put(FrameworkStartLevel.class, new FrameworkStartLevelImpl());
        return new BundleDescriptor(PojoSR.class.getClassLoader(), "System Bundle", headers, revision, services);
    }

    public PojoSR(Map<String, ?> config) throws Exception {
        this(config, null);
    }

    public PojoSR(Map<String, ?> config, BundleDescriptor systemBundle) throws Exception {
        boolean hasVFS;
        if (systemBundle == null) {
            systemBundle = PojoSR.createSystemBundle();
        }
        this.bundleConfig = new HashMap(config);
        PojoSRBundle b = new PojoSRBundle(this.m_registry, this.m_dispatcher, this.m_bundles, systemBundle.getUrl(), 0L, "org.apache.felix.connect", new Version(0, 0, 1), systemBundle.getRevision(), systemBundle.getClassLoader(), systemBundle.getHeaders(), systemBundle.getServices(), this.bundleConfig){

            @Override
            public synchronized void start() throws BundleException {
                if (this.m_state != 4) {
                    return;
                }
                PojoSR.this.m_dispatcher.startDispatching();
                this.m_state = 8;
                PojoSR.this.m_dispatcher.fireBundleEvent(new BundleEvent(128, this));
                this.m_context = new PojoSRBundleContext(this, PojoSR.this.m_registry, PojoSR.this.m_dispatcher, PojoSR.this.m_bundles, PojoSR.this.bundleConfig);
                int i = 0;
                for (Bundle b : PojoSR.this.m_bundles.values()) {
                    ++i;
                    try {
                        if (b == this) continue;
                        b.start();
                    }
                    catch (Throwable t) {
                        System.out.println("Unable to start bundle: " + i);
                        t.printStackTrace();
                    }
                }
                this.m_state = 32;
                PojoSR.this.m_dispatcher.fireBundleEvent(new BundleEvent(2, this));
                PojoSR.this.m_dispatcher.fireFrameworkEvent(new FrameworkEvent(1, this, null));
                super.start();
            }

            @Override
            public synchronized void stop() throws BundleException {
                if (this.m_state == 16 || this.m_state == 4) {
                    return;
                }
                if (this.m_state != 32) {
                    throw new BundleException("Can't stop pojosr because it is not ACTIVE");
                }
                final 3 systemBundle = this;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        PojoSR.this.m_dispatcher.fireBundleEvent(new BundleEvent(256, systemBundle));
                        for (Bundle b : PojoSR.this.m_bundles.values()) {
                            try {
                                if (b == systemBundle) continue;
                                b.stop();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        PojoSR.this.m_dispatcher.fireBundleEvent(new BundleEvent(4, systemBundle));
                        m_state = 4;
                        PojoSR.this.m_dispatcher.stopDispatching();
                    }
                };
                this.m_state = 16;
                if ("true".equalsIgnoreCase(System.getProperty("org.apache.felix.connect.events.sync"))) {
                    r.run();
                } else {
                    new Thread(r).start();
                }
            }
        };
        this.m_bundles.put(0L, b);
        b.start();
        b.getBundleContext().registerService(StartLevel.class.getName(), (Object)new StartLevelImpl(), null);
        b.getBundleContext().registerService(PackageAdmin.class.getName(), (Object)new PackageAdminImpl(), null);
        this.m_context = b.getBundleContext();
        try {
            hasVFS = VFS.class != null;
        }
        catch (Throwable t) {
            hasVFS = false;
        }
        this.m_hasVFS = hasVFS;
        Collection scan = (Collection)config.get(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS);
        if (scan != null) {
            this.startBundles(scan);
        }
    }

    @Override
    public void startBundles(Collection<BundleDescriptor> scan) throws Exception {
        for (BundleDescriptor desc : scan) {
            Version osgiVersion;
            Revision revision = desc.getRevision();
            if (revision == null) {
                revision = this.buildRevision(desc);
            }
            Map<String, String> bundleHeaders = desc.getHeaders();
            try {
                osgiVersion = Version.parseVersion(bundleHeaders.get("Bundle-Version"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                osgiVersion = Version.emptyVersion;
            }
            String sym = bundleHeaders.get("Bundle-SymbolicName");
            if (sym != null) {
                int idx = sym.indexOf(59);
                if (idx > 0) {
                    sym = sym.substring(0, idx);
                }
                sym = sym.trim();
            }
            PojoSRBundle bundle = new PojoSRBundle(this.m_registry, this.m_dispatcher, this.m_bundles, desc.getUrl(), this.m_bundles.size(), sym, osgiVersion, revision, desc.getClassLoader(), bundleHeaders, desc.getServices(), this.bundleConfig);
            this.m_bundles.put(bundle.getBundleId(), bundle);
        }
        for (Bundle bundle : this.m_bundles.values()) {
            try {
                bundle.start();
            }
            catch (Throwable e) {
                System.out.println("Unable to start bundle: " + bundle);
                e.printStackTrace();
            }
        }
    }

    private Revision buildRevision(BundleDescriptor desc) throws IOException {
        Revision r;
        URL url = new URL(desc.getUrl());
        URL u = new URL(desc.getUrl() + "META-INF/MANIFEST.MF");
        String extF = u.toExternalForm();
        if (extF.startsWith("file:")) {
            File root = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            r = new DirRevision(root);
        } else {
            URLConnection uc = u.openConnection();
            if (uc instanceof JarURLConnection) {
                String target = ((JarURLConnection)uc).getJarFileURL().toExternalForm();
                String prefix = null;
                if (!("jar:" + target + "!/").equals(desc.getUrl()) && desc.getUrl().startsWith("jar:" + target + "!/")) {
                    System.out.println(desc.getUrl() + " " + target);
                    prefix = desc.getUrl().substring(("jar:" + target + "!/").length());
                }
                r = new JarRevision(((JarURLConnection)uc).getJarFile(), ((JarURLConnection)uc).getJarFileURL(), prefix, uc.getLastModified());
            } else {
                r = this.m_hasVFS && extF.startsWith("vfs") ? new VFSRevision(url, url.openConnection().getLastModified()) : new URLRevision(url, url.openConnection().getLastModified());
            }
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        Filter filter = null;
        Class<?> main = null;
        for (int i = 0; args != null && i < args.length && i < 2; ++i) {
            try {
                filter = FrameworkUtil.createFilter(args[i]);
                continue;
            }
            catch (InvalidSyntaxException ie) {
                try {
                    main = PojoSR.class.getClassLoader().loadClass(args[i]);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Argument is neither a filter nor a class: " + args[i]);
                }
            }
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(PojoServiceRegistryFactory.BUNDLE_DESCRIPTORS, filter != null ? new ClasspathScanner().scanForBundles(filter.toString()) : new ClasspathScanner().scanForBundles());
        new PojoServiceRegistryFactoryImpl().newPojoServiceRegistry(config);
        if (main != null) {
            int count = 0;
            if (filter != null) {
                ++count;
            }
            Object[] newArgs = args;
            if (++count > 0) {
                newArgs = new String[args.length - count];
                System.arraycopy(args, count, newArgs, 0, newArgs.length);
            }
            main.getMethod("main", String[].class).invoke(null, newArgs);
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.m_context.addServiceListener(listener, filter);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        this.m_context.addServiceListener(listener);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.m_context.removeServiceListener(listener);
    }

    @Override
    public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
        return this.m_context.registerService(clazzes, service, properties);
    }

    @Override
    public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
        return this.m_context.registerService(clazz, service, properties);
    }

    @Override
    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.m_context.getServiceReferences(clazz, filter);
    }

    @Override
    public ServiceReference<?> getServiceReference(String clazz) {
        return this.m_context.getServiceReference(clazz);
    }

    @Override
    public <S> S getService(ServiceReference<S> reference) {
        return this.m_context.getService(reference);
    }

    @Override
    public boolean ungetService(ServiceReference<?> reference) {
        return this.m_context.ungetService(reference);
    }

    private class PackageAdminImpl
    implements PackageAdmin {
        private PackageAdminImpl() {
        }

        @Override
        public boolean resolveBundles(Bundle[] bundles) {
            return true;
        }

        @Override
        public void refreshPackages(Bundle[] bundles) {
            FrameworkEvent event = new FrameworkEvent(4, (Bundle)PojoSR.this.m_bundles.get(0L), null);
            PojoSR.this.m_dispatcher.fireFrameworkEvent(event);
        }

        @Override
        public RequiredBundle[] getRequiredBundles(String symbolicName) {
            ArrayList<RequiredBundleImpl> list = new ArrayList<RequiredBundleImpl>();
            for (Bundle bundle : PojoSR.this.m_bundles.values()) {
                if (symbolicName != null && !symbolicName.equals(bundle.getSymbolicName())) continue;
                list.add(new RequiredBundleImpl(bundle));
            }
            return list.isEmpty() ? null : list.toArray(new RequiredBundle[list.size()]);
        }

        @Override
        public Bundle[] getHosts(Bundle bundle) {
            return null;
        }

        @Override
        public Bundle[] getFragments(Bundle bundle) {
            return null;
        }

        @Override
        public ExportedPackage[] getExportedPackages(String name) {
            return null;
        }

        @Override
        public ExportedPackage[] getExportedPackages(Bundle bundle) {
            ArrayList<ExportedPackage> list = new ArrayList<ExportedPackage>();
            if (bundle != null) {
                this.getExportedPackages(bundle, list);
            } else {
                for (Bundle b : PojoSR.this.m_bundles.values()) {
                    this.getExportedPackages(b, list);
                }
            }
            return list.isEmpty() ? null : list.toArray(new ExportedPackage[list.size()]);
        }

        private void getExportedPackages(Bundle bundle, List<ExportedPackage> list) {
            for (BundleCapability cap : bundle.adapt(BundleWiring.class).getCapabilities(null)) {
                if (!cap.getNamespace().equals("osgi.wiring.package")) continue;
                list.add(new ExportedPackageImpl(cap));
            }
        }

        @Override
        public ExportedPackage getExportedPackage(String name) {
            return null;
        }

        @Override
        public Bundle[] getBundles(String symbolicName, String versionRange) {
            HashSet<Bundle> result = new HashSet<Bundle>();
            VersionRange range = versionRange != null ? new VersionRange(versionRange) : null;
            for (Bundle bundle : PojoSR.this.m_bundles.values()) {
                if (symbolicName != null && !bundle.getSymbolicName().equals(symbolicName) || range != null && !range.includes(bundle.getVersion())) continue;
                result.add(bundle);
            }
            return result.isEmpty() ? null : result.toArray(new Bundle[result.size()]);
        }

        @Override
        public int getBundleType(Bundle bundle) {
            return bundle.adapt(BundleRevision.class).getTypes();
        }

        @Override
        public Bundle getBundle(Class clazz) {
            return PojoSR.this.m_context.getBundle();
        }
    }

    private static class StartLevelImpl
    implements StartLevel {
        private StartLevelImpl() {
        }

        @Override
        public void setStartLevel(int startlevel) {
        }

        @Override
        public void setInitialBundleStartLevel(int startlevel) {
        }

        @Override
        public void setBundleStartLevel(Bundle bundle, int startlevel) {
        }

        @Override
        public boolean isBundlePersistentlyStarted(Bundle bundle) {
            return true;
        }

        @Override
        public boolean isBundleActivationPolicyUsed(Bundle bundle) {
            return false;
        }

        @Override
        public int getStartLevel() {
            return 1;
        }

        @Override
        public int getInitialBundleStartLevel() {
            return 1;
        }

        @Override
        public int getBundleStartLevel(Bundle bundle) {
            return 1;
        }
    }

    private static class FrameworkStartLevelImpl
    implements FrameworkStartLevel,
    BundleAware {
        private Bundle bundle;

        private FrameworkStartLevelImpl() {
        }

        @Override
        public void setBundle(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public int getStartLevel() {
            return 0;
        }

        @Override
        public void setStartLevel(int startlevel, FrameworkListener ... listeners) {
        }

        @Override
        public int getInitialBundleStartLevel() {
            return 0;
        }

        @Override
        public void setInitialBundleStartLevel(int startlevel) {
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

