/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.webconsole.impl;

import java.io.PrintWriter;
import org.owasp.encoder.Encode;
import org.owasp.encoder.Encoder;
import org.owasp.encoder.Encoders;

class WebConsoleHelper {
    final PrintWriter pw;
    final Encoder encoder = Encoders.forName((String)"html");

    WebConsoleHelper(PrintWriter w) {
        this.pw = w;
    }

    PrintWriter writer() {
        return this.pw;
    }

    void tdContent() {
        this.pw.print("<td class='content' colspan='2'>");
    }

    void closeTd() {
        this.pw.print("</td>");
    }

    void closeTr() {
        this.pw.println("</tr>");
    }

    void tdLabel(String label) {
        this.pw.print("<td class='content'>");
        this.pw.print(this.escapeHtmlContent(label));
        this.pw.println("</td>");
    }

    void tr() {
        this.pw.println("<tr class='content'>");
    }

    void titleHtml(String title, String description) {
        this.tr();
        this.pw.print("<th colspan='3' class='content container'>");
        this.pw.print(this.escapeHtmlContent(title));
        this.pw.println("</th>");
        this.closeTr();
        if (description != null) {
            this.tr();
            this.pw.print("<td colspan='3' class='content'>");
            this.pw.print(this.escapeHtmlContent(description));
            this.pw.println("</th>");
            this.closeTr();
        }
    }

    String escapeHtmlContent(String text) {
        if (text == null) {
            return "";
        }
        return Encode.forHtmlContent((String)text);
    }

    String escapeHtmlAttr(String text) {
        if (text == null) {
            return "";
        }
        return Encode.forHtmlAttribute((String)text);
    }
}

