/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.logger;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.felix.http.base.internal.logger.InternalLogger;

public final class JDK14Logger
implements InternalLogger {
    private final Logger logger = Logger.getLogger("org.apache.felix.http");

    private Level getLevel(int level) {
        Level logLevel;
        switch (level) {
            case 4: {
                logLevel = Level.FINE;
                break;
            }
            case 3: {
                logLevel = Level.INFO;
                break;
            }
            case 2: {
                logLevel = Level.WARNING;
                break;
            }
            case 1: {
                logLevel = Level.SEVERE;
                break;
            }
            default: {
                logLevel = Level.FINE;
            }
        }
        return logLevel;
    }

    @Override
    public boolean isLogEnabled(int level) {
        return this.logger.isLoggable(this.getLevel(level));
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        Level logLevel = this.getLevel(level);
        if (exception != null) {
            this.logger.log(logLevel, message, exception);
        } else {
            this.logger.log(logLevel, message);
        }
    }
}

