/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.felix.ipojo.extender.internal.LifecycleQueueService;
import org.apache.felix.ipojo.extender.internal.queue.AbstractQueueService;
import org.apache.felix.ipojo.extender.internal.queue.JobInfoCallable;
import org.apache.felix.ipojo.extender.internal.queue.Statistic;
import org.apache.felix.ipojo.extender.queue.Callback;
import org.apache.felix.ipojo.extender.queue.Job;
import org.apache.felix.ipojo.extender.queue.JobInfo;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousQueueService
extends AbstractQueueService
implements LifecycleQueueService {
    private final Statistic m_statistic = new Statistic();

    public SynchronousQueueService(BundleContext bundleContext) {
        super(bundleContext, QueueService.class);
    }

    @Override
    protected Dictionary<String, ?> getServiceProperties() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("ipojo.queue.mode", "sync");
        return properties;
    }

    @Override
    public int getFinished() {
        return this.m_statistic.getFinishedCounter().get();
    }

    @Override
    public int getWaiters() {
        return 0;
    }

    @Override
    public int getCurrents() {
        return this.m_statistic.getCurrentsCounter().get();
    }

    @Override
    public List<JobInfo> getWaitersInfo() {
        return Collections.emptyList();
    }

    @Override
    public <T> Future<T> submit(Job<T> callable, Callback<T> callback, String description) {
        JobInfoCallable<T> exec = new JobInfoCallable<T>(this, this.m_statistic, callable, callback, description);
        try {
            return new ImmediateFuture<T>(exec.call());
        }
        catch (Exception e) {
            return new ExceptionFuture(e);
        }
    }

    @Override
    public <T> Future<T> submit(Job<T> callable, String description) {
        return this.submit(callable, null, description);
    }

    @Override
    public <T> Future<T> submit(Job<T> callable) {
        return this.submit(callable, "No description");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExceptionFuture<T>
    extends ImmediateFuture<T> {
        private ExecutionException m_exception;

        public ExceptionFuture(Exception e) {
            super(null);
            this.m_exception = new ExecutionException(e);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            throw this.m_exception;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmediateFuture<T>
    implements Future<T> {
        private T m_result;

        public ImmediateFuture(T result) {
            this.m_result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.m_result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

