/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.obr;

import aQute.lib.deployer.obr.Capability;
import aQute.lib.deployer.obr.CapabilityType;
import aQute.lib.deployer.obr.Property;
import aQute.lib.deployer.obr.Require;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    private final String id;
    private final String presentationName;
    private final String symbolicName;
    private final String baseUrl;
    private final String url;
    private final String version;
    private final List<Capability> capabilities;
    private final List<Require> requires;

    private Resource(String id, String presentationName, String symbolicName, String baseUrl, String url, String version, List<Capability> capabilities, List<Require> requires) {
        this.id = id;
        this.presentationName = presentationName;
        this.symbolicName = symbolicName;
        this.baseUrl = baseUrl;
        this.url = url;
        this.version = version;
        this.capabilities = capabilities;
        this.requires = requires;
    }

    public String getId() {
        return this.id;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public Capability findPackageCapability(String pkgName) {
        block0: for (Capability capability : this.capabilities) {
            if (!CapabilityType.PACKAGE.getTypeName().equals(capability.getName())) continue;
            List<Property> props = capability.getProperties();
            for (Property prop : props) {
                if (!"package".equals(prop.getName())) continue;
                if (!pkgName.equals(prop.getValue())) continue block0;
                return capability;
            }
        }
        return null;
    }

    public List<Require> getRequires() {
        return this.requires;
    }

    public Require findRequire(String name) {
        for (Require require : this.requires) {
            if (!name.equals(require.getName())) continue;
            return require;
        }
        return null;
    }

    public Require findPackageRequire(String usesPkgName) {
        String matchString = String.format("(package=%s)", usesPkgName);
        for (Require require : this.requires) {
            String filter;
            if (!CapabilityType.PACKAGE.getTypeName().equals(require.getName()) || (filter = require.getFilter()).indexOf(matchString) <= -1) continue;
            return require;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resource [id=").append(this.id).append(", presentationName=").append(this.presentationName).append(", symbolicName=").append(this.symbolicName).append(", baseUrl=").append(this.baseUrl).append(", url=").append(this.url).append(", version=").append(this.version).append(", capabilities=").append(this.capabilities).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.hashCode());
        result = 31 * result + (this.capabilities == null ? 0 : this.capabilities.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.presentationName == null ? 0 : this.presentationName.hashCode());
        result = 31 * result + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.equals(other.baseUrl)) {
            return false;
        }
        if (this.capabilities == null ? other.capabilities != null : !this.capabilities.equals(other.capabilities)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.presentationName == null ? other.presentationName != null : !this.presentationName.equals(other.presentationName)) {
            return false;
        }
        if (this.symbolicName == null ? other.symbolicName != null : !this.symbolicName.equals(other.symbolicName)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    /* synthetic */ Resource(String string, String string2, String string3, String string4, String string5, String string6, List list, List list2, Resource resource) {
        this(string, string2, string3, string4, string5, string6, list, list2);
    }

    public static class Builder {
        private String id;
        private String presentationName;
        private String symbolicName;
        private String baseUrl;
        private String url;
        private String version;
        private final List<Capability> capabilities = new LinkedList<Capability>();
        private final List<Require> requires = new LinkedList<Require>();

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setPresentationName(String presentationName) {
            this.presentationName = presentationName;
            return this;
        }

        public Builder setSymbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return this;
        }

        public Builder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder addCapability(Capability capability) {
            this.capabilities.add(capability);
            return this;
        }

        public Builder addCapability(Capability.Builder capabilityBuilder) {
            this.capabilities.add(capabilityBuilder.build());
            return this;
        }

        public Builder addRequire(Require require) {
            this.requires.add(require);
            return this;
        }

        public Resource build() {
            if (this.id == null) {
                throw new IllegalStateException("'id' field is not initialised");
            }
            if (this.symbolicName == null) {
                throw new IllegalStateException("'symbolicName' field is not initialised");
            }
            if (this.url == null) {
                throw new IllegalStateException("'url' field is not initialised");
            }
            return new Resource(this.id, this.presentationName, this.symbolicName, this.baseUrl, this.url, this.version, Collections.unmodifiableList(this.capabilities), Collections.unmodifiableList(this.requires), null);
        }
    }
}

