/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.annotation.ProviderType;
import aQute.bnd.annotation.UsePolicy;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.OpCodes;
import aQute.lib.osgi.Resource;
import aQute.libg.generics.Create;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clazz {
    public static EnumSet<QUERY> HAS_ARGUMENT = EnumSet.of(QUERY.IMPLEMENTS, new QUERY[]{QUERY.EXTENDS, QUERY.IMPORTS, QUERY.NAMED, QUERY.VERSION, QUERY.ANNOTATION});
    static final int ACC_PUBLIC = 1;
    static final int ACC_FINAL = 16;
    static final int ACC_SUPER = 32;
    static final int ACC_INTERFACE = 512;
    static final int ACC_ABSTRACT = 1024;
    static final int ACC_ENUM = 16384;
    static final byte[] SkipTable;
    boolean isAbstract;
    boolean isPublic;
    boolean isEnum;
    boolean hasRuntimeAnnotations;
    boolean hasClassAnnotations;
    String className;
    Object[] pool;
    int[] intPool;
    Set<String> imports = Create.set();
    String path;
    int minor = 0;
    int major = 0;
    int access = 0;
    String sourceFile;
    Set<String> xref;
    Set<Integer> classes;
    Set<Integer> descriptors;
    Set<String> annotations;
    int forName = 0;
    int class$ = 0;
    String[] interfaces;
    String zuper;
    ClassDataCollector cd = null;
    Resource resource;
    FieldDef last = null;
    static final String USEPOLICY;
    static final String PROVIDERPOLICY;

    static {
        byte[] byArray = new byte[13];
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = 4;
        byArray[4] = 4;
        byArray[5] = 8;
        byArray[6] = 8;
        byArray[7] = -1;
        byArray[8] = 2;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        SkipTable = byArray;
        USEPOLICY = Clazz.toDescriptor(UsePolicy.class);
        PROVIDERPOLICY = Clazz.toDescriptor(ProviderType.class);
    }

    public Clazz(String path, Resource resource) {
        this.path = path;
        this.resource = resource;
    }

    public Set<String> parseClassFile() throws Exception {
        return this.parseClassFileWithCollector(null);
    }

    public Set<String> parseClassFile(InputStream in) throws IOException {
        return this.parseClassFile(in, null);
    }

    public Set<String> parseClassFileWithCollector(ClassDataCollector cd) throws Exception {
        InputStream in = this.resource.openInputStream();
        try {
            Set<String> set = this.parseClassFile(in, cd);
            return set;
        }
        finally {
            in.close();
        }
    }

    public Set<String> parseClassFile(InputStream in, ClassDataCollector cd) throws IOException {
        DataInputStream din = new DataInputStream(in);
        try {
            this.cd = cd;
            Set<String> set = this.parseClassFile(din);
            return set;
        }
        finally {
            cd = null;
            din.close();
        }
    }

    Set<String> parseClassFile(DataInputStream in) throws IOException {
        this.xref = new HashSet<String>();
        this.classes = new HashSet<Integer>();
        this.descriptors = new HashSet<Integer>();
        boolean crawl = this.cd != null;
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        this.minor = in.readUnsignedShort();
        this.major = in.readUnsignedShort();
        int count = in.readUnsignedShort();
        this.pool = new Object[count];
        this.intPool = new int[count];
        int poolIndex = 1;
        block16: while (poolIndex < count) {
            byte tag = in.readByte();
            switch (tag) {
                case 0: {
                    break block16;
                }
                case 1: {
                    this.constantUtf8(in, poolIndex);
                    break;
                }
                case 3: {
                    this.constantInteger(in, poolIndex);
                    break;
                }
                case 4: {
                    this.constantFloat(in, poolIndex);
                    break;
                }
                case 5: {
                    this.constantLong(in, poolIndex);
                    ++poolIndex;
                    break;
                }
                case 6: {
                    this.constantDouble(in, poolIndex);
                    ++poolIndex;
                    break;
                }
                case 7: {
                    this.constantClass(in, poolIndex);
                    break;
                }
                case 8: {
                    this.constantString(in, poolIndex);
                    break;
                }
                case 10: 
                case 11: {
                    this.methodRef(in, poolIndex);
                    break;
                }
                case 12: {
                    this.nameAndType(in, poolIndex, tag);
                    break;
                }
                default: {
                    if (tag == 2) {
                        throw new IOException("Invalid tag " + tag);
                    }
                    in.skipBytes(SkipTable[tag]);
                }
            }
            ++poolIndex;
        }
        this.pool(this.pool, this.intPool);
        int access_flags = in.readUnsignedShort();
        this.isAbstract = (access_flags & 0x400) != 0;
        this.isPublic = (access_flags & 1) != 0;
        this.isEnum = (access_flags & 0x4000) != 0;
        int this_class = in.readUnsignedShort();
        this.className = (String)this.pool[this.intPool[this_class]];
        try {
            int interfacesCount;
            if (this.cd != null && !this.cd.classStart(access_flags, this.className)) {
                return null;
            }
            int super_class = in.readUnsignedShort();
            this.zuper = (String)this.pool[this.intPool[super_class]];
            if (this.zuper != null) {
                String pack = Clazz.getPackage(this.zuper);
                this.packageReference(pack);
                if (this.cd != null) {
                    this.cd.extendsClass(this.zuper);
                }
            }
            if ((interfacesCount = in.readUnsignedShort()) > 0) {
                this.interfaces = new String[interfacesCount];
                int i = 0;
                while (i < interfacesCount) {
                    this.interfaces[i] = (String)this.pool[this.intPool[in.readUnsignedShort()]];
                    ++i;
                }
                if (this.cd != null) {
                    this.cd.implementsInterfaces(this.interfaces);
                }
            }
            int fieldsCount = in.readUnsignedShort();
            int i = 0;
            while (i < fieldsCount) {
                access_flags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                int descriptor_index = in.readUnsignedShort();
                String name = this.pool[name_index].toString();
                if (name.startsWith("class$")) {
                    crawl = true;
                }
                if (this.cd != null) {
                    this.last = new FieldDef(access_flags, this.className, name, this.pool[descriptor_index].toString());
                    this.cd.field(this.last);
                }
                this.descriptors.add(new Integer(descriptor_index));
                this.doAttributes(in, ElementType.FIELD, false);
                ++i;
            }
            if (crawl) {
                this.forName = this.findMethodReference("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                this.class$ = this.findMethodReference(this.className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
            } else if (this.major == 48) {
                this.forName = this.findMethodReference("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                if (this.forName > 0) {
                    crawl = true;
                    this.class$ = this.findMethodReference(this.className, "class$", "(Ljava/lang/String;)Ljava/lang/Class;");
                }
            }
            int methodCount = in.readUnsignedShort();
            int i2 = 0;
            while (i2 < methodCount) {
                access_flags = in.readUnsignedShort();
                int name_index = in.readUnsignedShort();
                int descriptor_index = in.readUnsignedShort();
                this.descriptors.add(new Integer(descriptor_index));
                String name = this.pool[name_index].toString();
                String descriptor = this.pool[descriptor_index].toString();
                if (this.cd != null) {
                    MethodDef mdef = new MethodDef(access_flags, this.className, name, descriptor);
                    this.last = mdef;
                    this.cd.method(mdef);
                }
                if ("<init>".equals(name)) {
                    this.doAttributes(in, ElementType.CONSTRUCTOR, crawl);
                } else {
                    this.doAttributes(in, ElementType.METHOD, crawl);
                }
                ++i2;
            }
            this.doAttributes(in, ElementType.TYPE, false);
            for (int n : this.classes) {
                String clazz = (String)this.pool[n];
                if (clazz.endsWith(";") || clazz.startsWith("[")) {
                    this.parseReference(clazz, 0);
                    continue;
                }
                String pack = Clazz.getPackage(clazz);
                this.packageReference(pack);
            }
            for (Integer index : this.descriptors) {
                String prototype = (String)this.pool[index];
                if (prototype != null) {
                    this.parseDescriptor(prototype);
                    continue;
                }
                System.err.println("Unrecognized descriptor: " + index);
            }
            Set<String> xref = this.xref;
            this.reset();
            Set<String> set = xref;
            return set;
        }
        finally {
            if (this.cd != null) {
                this.cd.classEnd();
            }
        }
    }

    private void constantFloat(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = Float.valueOf(in.readFloat());
        } else {
            in.skipBytes(4);
        }
    }

    private void constantInteger(DataInputStream in, int poolIndex) throws IOException {
        this.intPool[poolIndex] = in.readInt();
        if (this.cd != null) {
            this.pool[poolIndex] = this.intPool[poolIndex];
        }
    }

    protected void pool(Object[] pool, int[] intPool) {
    }

    protected void nameAndType(DataInputStream in, int poolIndex, byte tag) throws IOException {
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        this.descriptors.add(new Integer(descriptor_index));
        this.pool[poolIndex] = new Assoc(tag, name_index, descriptor_index);
    }

    private void methodRef(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        this.pool[poolIndex] = new Assoc(10, class_index, name_and_type_index);
    }

    private void constantString(DataInputStream in, int poolIndex) throws IOException {
        int string_index;
        this.intPool[poolIndex] = string_index = in.readUnsignedShort();
    }

    protected void constantClass(DataInputStream in, int poolIndex) throws IOException {
        int class_index = in.readUnsignedShort();
        this.classes.add(new Integer(class_index));
        this.intPool[poolIndex] = class_index;
        ClassConstant c = new ClassConstant(class_index);
        this.pool[poolIndex] = c;
    }

    protected void constantDouble(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readDouble();
        } else {
            in.skipBytes(8);
        }
    }

    protected void constantLong(DataInputStream in, int poolIndex) throws IOException {
        if (this.cd != null) {
            this.pool[poolIndex] = in.readLong();
        } else {
            in.skipBytes(8);
        }
    }

    protected void constantUtf8(DataInputStream in, int poolIndex) throws IOException {
        String name = in.readUTF();
        this.xref.add(name);
        this.pool[poolIndex] = name;
    }

    private int findMethodReference(String clazz, String methodname, String descriptor) {
        int i = 1;
        while (i < this.pool.length) {
            if (this.pool[i] instanceof Assoc) {
                int class_index;
                int class_name_index;
                Assoc methodref = (Assoc)this.pool[i];
                if (methodref.tag == 10 && clazz.equals(this.pool[class_name_index = this.intPool[class_index = methodref.a]])) {
                    int name_and_type_index = methodref.b;
                    Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
                    if (name_and_type.tag == 12) {
                        int name_index = name_and_type.a;
                        int type_index = name_and_type.b;
                        if (methodname.equals(this.pool[name_index]) && descriptor.equals(this.pool[type_index])) {
                            return i;
                        }
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    private void doAttributes(DataInputStream in, ElementType member, boolean crawl) throws IOException {
        int attributesCount = in.readUnsignedShort();
        int j = 0;
        while (j < attributesCount) {
            this.doAttribute(in, member, crawl);
            ++j;
        }
    }

    private void doAttribute(DataInputStream in, ElementType member, boolean crawl) throws IOException {
        int attribute_name_index = in.readUnsignedShort();
        String attributeName = (String)this.pool[attribute_name_index];
        long attribute_length = in.readInt();
        attribute_length &= 0xFFFFFFFFFFFFFFFFL;
        if ("RuntimeVisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in, member, RetentionPolicy.RUNTIME);
        } else if ("RuntimeVisibleParameterAnnotations".equals(attributeName)) {
            this.doParameterAnnotations(in, member, RetentionPolicy.RUNTIME);
        } else if ("RuntimeInvisibleAnnotations".equals(attributeName)) {
            this.doAnnotations(in, member, RetentionPolicy.CLASS);
        } else if ("RuntimeInvisibleParameterAnnotations".equals(attributeName)) {
            this.doParameterAnnotations(in, member, RetentionPolicy.CLASS);
        } else if ("InnerClasses".equals(attributeName)) {
            this.doInnerClasses(in);
        } else if ("EnclosingMethod".equals(attributeName)) {
            this.doEnclosingMethod(in);
        } else if ("SourceFile".equals(attributeName)) {
            this.doSourceFile(in);
        } else if ("Code".equals(attributeName) && crawl) {
            this.doCode(in);
        } else if ("Signature".equals(attributeName)) {
            this.doSignature(in, member);
        } else if ("ConstantValue".equals(attributeName)) {
            this.doConstantValue(in);
        } else {
            if (attribute_length > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Attribute > 2Gb");
            }
            in.skipBytes((int)attribute_length);
        }
    }

    private void doEnclosingMethod(DataInputStream in) throws IOException {
        short cIndex = in.readShort();
        short mIndex = in.readShort();
        if (this.cd != null) {
            int nameIndex = this.intPool[cIndex];
            String cName = (String)this.pool[nameIndex];
            String mName = null;
            String mDescriptor = null;
            if (mIndex != 0) {
                Assoc nameAndType = (Assoc)this.pool[mIndex];
                mName = (String)this.pool[nameAndType.a];
                mDescriptor = (String)this.pool[nameAndType.b];
            }
            this.cd.enclosingMethod(cName, mName, mDescriptor);
        }
    }

    private void doInnerClasses(DataInputStream in) throws IOException {
        int number_of_classes = in.readShort();
        int i = 0;
        while (i < number_of_classes) {
            short inner_class_info_index = in.readShort();
            short outer_class_info_index = in.readShort();
            short inner_name_index = in.readShort();
            int inner_class_access_flags = in.readShort() & 0xFFFF;
            if (this.cd != null) {
                int nameIndex;
                String innerClass = null;
                String outerClass = null;
                String innerName = null;
                if (inner_class_info_index != 0) {
                    nameIndex = this.intPool[inner_class_info_index];
                    innerClass = (String)this.pool[nameIndex];
                }
                if (outer_class_info_index != 0) {
                    nameIndex = this.intPool[outer_class_info_index];
                    outerClass = (String)this.pool[nameIndex];
                }
                if (inner_name_index != 0) {
                    innerName = (String)this.pool[inner_name_index];
                }
                this.cd.innerClass(innerClass, outerClass, innerName, inner_class_access_flags);
            }
            ++i;
        }
    }

    void doSignature(DataInputStream in, ElementType member) throws IOException {
        int signature_index = in.readUnsignedShort();
        String signature = (String)this.pool[signature_index];
        if (member != ElementType.TYPE) {
            this.parseDescriptor(signature);
        }
        if (this.last != null) {
            this.last.signature = signature;
        }
        if (this.cd != null) {
            this.cd.signature(signature);
        }
    }

    void doConstantValue(DataInputStream in) throws IOException {
        int constantValue_index = in.readUnsignedShort();
        if (this.cd == null) {
            return;
        }
        Object object = this.pool[constantValue_index];
        if (object == null) {
            object = this.pool[this.intPool[constantValue_index]];
        }
        this.last.constant = object;
        this.cd.constant(object);
    }

    private void doCode(DataInputStream in) throws IOException {
        in.readUnsignedShort();
        in.readUnsignedShort();
        int code_length = in.readInt();
        byte[] code = new byte[code_length];
        in.readFully(code);
        this.crawl(code);
        int exception_table_length = in.readUnsignedShort();
        in.skipBytes(exception_table_length * 8);
        this.doAttributes(in, ElementType.METHOD, false);
    }

    protected void crawl(byte[] code) {
        ByteBuffer bb = ByteBuffer.wrap(code);
        bb.order(ByteOrder.BIG_ENDIAN);
        int lastReference = -1;
        block12: while (bb.remaining() > 0) {
            int instruction = 0xFF & bb.get();
            switch (instruction) {
                case 18: {
                    lastReference = 0xFF & bb.get();
                    break;
                }
                case 19: {
                    lastReference = 0xFFFF & bb.getShort();
                    break;
                }
                case 183: {
                    int mref = 0xFFFF & bb.getShort();
                    if (this.cd == null) continue block12;
                    this.cd.reference(this.getMethodDef(0, mref));
                    break;
                }
                case 182: {
                    int mref = 0xFFFF & bb.getShort();
                    if (this.cd == null) continue block12;
                    this.cd.reference(this.getMethodDef(0, mref));
                    break;
                }
                case 185: {
                    int mref = 0xFFFF & bb.getShort();
                    if (this.cd == null) continue block12;
                    this.cd.reference(this.getMethodDef(0, mref));
                    break;
                }
                case 184: {
                    int methodref = 0xFFFF & bb.getShort();
                    if (this.cd != null) {
                        this.cd.reference(this.getMethodDef(0, methodref));
                    }
                    if (methodref != this.forName && methodref != this.class$ || lastReference == -1 || !(this.pool[this.intPool[lastReference]] instanceof String)) continue block12;
                    String clazz = (String)this.pool[this.intPool[lastReference]];
                    if (clazz.startsWith("[") || clazz.endsWith(";")) {
                        this.parseReference(clazz, 0);
                        break;
                    }
                    int n = clazz.lastIndexOf(46);
                    if (n <= 0) continue block12;
                    this.packageReference(clazz.substring(0, n));
                    break;
                }
                case 170: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    bb.getInt();
                    int low = bb.getInt();
                    int high = bb.getInt();
                    try {
                        bb.position(bb.position() + (high - low + 1) * 4);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    lastReference = -1;
                    break;
                }
                case 171: {
                    while ((bb.position() & 3) != 0) {
                        bb.get();
                    }
                    bb.getInt();
                    int npairs = bb.getInt();
                    bb.position(bb.position() + npairs * 8);
                    lastReference = -1;
                    break;
                }
                default: {
                    lastReference = -1;
                    bb.position(bb.position() + OpCodes.OFFSETS[instruction]);
                }
            }
        }
    }

    private void doSourceFile(DataInputStream in) throws IOException {
        int sourcefile_index = in.readUnsignedShort();
        this.sourceFile = this.pool[sourcefile_index].toString();
    }

    private void doParameterAnnotations(DataInputStream in, ElementType member, RetentionPolicy policy) throws IOException {
        int num_parameters = in.readUnsignedByte();
        int p = 0;
        while (p < num_parameters) {
            if (this.cd != null) {
                this.cd.parameter(p);
            }
            this.doAnnotations(in, member, policy);
            ++p;
        }
    }

    private void doAnnotations(DataInputStream in, ElementType member, RetentionPolicy policy) throws IOException {
        int num_annotations = in.readUnsignedShort();
        int a = 0;
        while (a < num_annotations) {
            if (this.cd == null) {
                this.doAnnotation(in, member, policy, false);
            } else {
                Annotation annotion = this.doAnnotation(in, member, policy, true);
                this.cd.annotation(annotion);
            }
            ++a;
        }
    }

    private Annotation doAnnotation(DataInputStream in, ElementType member, RetentionPolicy policy, boolean collect) throws IOException {
        int type_index = in.readUnsignedShort();
        if (this.annotations == null) {
            this.annotations = new HashSet<String>();
        }
        this.annotations.add(this.pool[type_index].toString());
        if (policy == RetentionPolicy.RUNTIME) {
            this.descriptors.add(new Integer(type_index));
            this.hasRuntimeAnnotations = true;
        } else {
            this.hasClassAnnotations = true;
        }
        String name = (String)this.pool[type_index];
        int num_element_value_pairs = in.readUnsignedShort();
        LinkedHashMap<String, Object> elements = null;
        int v = 0;
        while (v < num_element_value_pairs) {
            int element_name_index = in.readUnsignedShort();
            String element = (String)this.pool[element_name_index];
            Object value = this.doElementValue(in, member, policy, collect);
            if (collect) {
                if (elements == null) {
                    elements = new LinkedHashMap<String, Object>();
                }
                elements.put(element, value);
            }
            ++v;
        }
        if (collect) {
            return new Annotation(name, elements, member, policy);
        }
        return null;
    }

    private Object doElementValue(DataInputStream in, ElementType member, RetentionPolicy policy, boolean collect) throws IOException {
        char tag = (char)in.readUnsignedByte();
        switch (tag) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': {
                int const_value_index = in.readUnsignedShort();
                return this.intPool[const_value_index];
            }
            case 'D': 
            case 'F': 
            case 'J': 
            case 's': {
                int const_value_index = in.readUnsignedShort();
                return this.pool[const_value_index];
            }
            case 'Z': {
                int const_value_index = in.readUnsignedShort();
                return this.pool[const_value_index] != null && !this.pool[const_value_index].equals(0);
            }
            case 'e': {
                int type_name_index = in.readUnsignedShort();
                if (policy == RetentionPolicy.RUNTIME) {
                    this.descriptors.add(new Integer(type_name_index));
                }
                int const_name_index = in.readUnsignedShort();
                return this.pool[const_name_index];
            }
            case 'c': {
                int class_info_index = in.readUnsignedShort();
                if (policy == RetentionPolicy.RUNTIME) {
                    this.descriptors.add(new Integer(class_info_index));
                }
                return this.pool[class_info_index];
            }
            case '@': {
                return this.doAnnotation(in, member, policy, collect);
            }
            case '[': {
                int num_values = in.readUnsignedShort();
                Object[] result = new Object[num_values];
                int i = 0;
                while (i < num_values) {
                    result[i] = this.doElementValue(in, member, policy, collect);
                    ++i;
                }
                return result;
            }
        }
        throw new IllegalArgumentException("Invalid value for Annotation ElementValue tag " + tag);
    }

    void packageReference(String pack) {
        this.imports.add(pack);
    }

    public void parseDescriptor(String descriptor) {
        if (descriptor.charAt(0) == '<') {
            return;
        }
        int rover = 0;
        if (descriptor.charAt(rover) == '(') {
            rover = this.parseReferences(descriptor, rover + 1, ')');
            ++rover;
        }
        this.parseReferences(descriptor, rover, '\u0000');
    }

    int parseReferences(String descriptor, int rover, char delimiter) {
        while (rover < descriptor.length() && descriptor.charAt(rover) != delimiter) {
            rover = this.parseReference(descriptor, rover);
        }
        return rover;
    }

    int parseReference(String descriptor, int rover) {
        char c = descriptor.charAt(rover);
        while (c == '[') {
            c = descriptor.charAt(++rover);
        }
        if (c == '<') {
            rover = this.parseReferences(descriptor, rover + 1, '>');
        } else if (c == 'T') {
            ++rover;
            while (descriptor.charAt(rover) != ';') {
                ++rover;
            }
        } else if (c == 'L') {
            StringBuilder sb = new StringBuilder();
            ++rover;
            int lastSlash = -1;
            while ((c = descriptor.charAt(rover)) != ';') {
                if (c == '<') {
                    rover = this.parseReferences(descriptor, rover + 1, '>');
                } else if (c == '/') {
                    lastSlash = sb.length();
                    sb.append('.');
                } else {
                    sb.append(c);
                }
                ++rover;
            }
            if (this.cd != null) {
                this.cd.addReference(sb.toString());
            }
            if (lastSlash > 0) {
                this.packageReference(sb.substring(0, lastSlash));
            }
        } else if ("+-*BCDFIJSZV".indexOf(c) < 0) {
            // empty if block
        }
        return rover + 1;
    }

    public static String getPackage(String clazz) {
        int n = clazz.lastIndexOf(47);
        if (n < 0 && (n = clazz.lastIndexOf(46)) < 0) {
            return ".";
        }
        return clazz.substring(0, n).replace('/', '.');
    }

    public Set<String> getReferred() {
        return this.imports;
    }

    String getClassName() {
        if (this.className == null) {
            return "NOCLASSNAME";
        }
        return this.className;
    }

    public String getPath() {
        return this.path;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void reset() {
        this.pool = null;
        this.intPool = null;
        this.xref = null;
        this.classes = null;
        this.descriptors = null;
    }

    public boolean is(QUERY query, Instruction instr, Analyzer analyzer) throws Exception {
        switch (query) {
            case ANY: {
                return true;
            }
            case NAMED: {
                if (instr.matches(this.getClassName())) {
                    return !instr.isNegated();
                }
                return false;
            }
            case VERSION: {
                String v = String.valueOf(this.major) + "/" + this.minor;
                if (instr.matches(v)) {
                    return !instr.isNegated();
                }
                return false;
            }
            case IMPLEMENTS: {
                int i = 0;
                while (this.interfaces != null && i < this.interfaces.length) {
                    if (instr.matches(this.interfaces[i])) {
                        return !instr.isNegated();
                    }
                    ++i;
                }
                break;
            }
            case EXTENDS: {
                if (this.zuper == null) {
                    return false;
                }
                if (!instr.matches(this.zuper)) break;
                return !instr.isNegated();
            }
            case PUBLIC: {
                return !this.isPublic;
            }
            case CONCRETE: {
                return !this.isAbstract;
            }
            case ANNOTATION: {
                if (this.annotations == null) {
                    return false;
                }
                if (this.annotations.contains(instr.getPattern())) {
                    return true;
                }
                for (String annotation : this.annotations) {
                    if (!instr.matches(annotation)) continue;
                    return !instr.isNegated();
                }
                return false;
            }
            case RUNTIMEANNOTATIONS: {
                return this.hasClassAnnotations;
            }
            case CLASSANNOTATIONS: {
                return this.hasClassAnnotations;
            }
            case ABSTRACT: {
                return this.isAbstract;
            }
            case IMPORTS: {
                for (String imp : this.imports) {
                    if (!instr.matches(imp.replace('.', '/'))) continue;
                    return !instr.isNegated();
                }
                break;
            }
        }
        if (this.zuper == null) {
            return false;
        }
        Clazz clazz = analyzer.findClass(String.valueOf(this.zuper) + ".class");
        if (clazz == null) {
            return false;
        }
        return clazz.is(query, instr, analyzer);
    }

    public String toString() {
        return this.getFQN();
    }

    public String getFQN() {
        String s = this.getClassName().replace('/', '.');
        return s;
    }

    public static void getImplementedPackages(Set<String> implemented, Analyzer analyzer, Clazz clazz) throws Exception {
        Clazz c;
        if (clazz.interfaces != null) {
            String[] stringArray = clazz.interfaces;
            int n = clazz.interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String interf = stringArray[n2];
                interf = String.valueOf(interf) + ".class";
                Clazz c2 = analyzer.getClassspace().get(interf);
                if (c2 == null) {
                    c2 = analyzer.findClass(interf);
                }
                if (c2 != null) {
                    boolean consumer = false;
                    Set<String> annotations = c2.annotations;
                    if (annotations != null) {
                        boolean bl = consumer = annotations.contains(USEPOLICY) || annotations.contains(PROVIDERPOLICY);
                    }
                    if (!consumer) {
                        implemented.add(Clazz.getPackage(interf));
                    }
                    Clazz.getImplementedPackages(implemented, analyzer, c2);
                } else {
                    implemented.add(Clazz.getPackage(interf));
                }
                ++n2;
            }
        }
        if (clazz.zuper != null && (c = analyzer.getClassspace().get(clazz.zuper)) != null) {
            Clazz.getImplementedPackages(implemented, analyzer, c);
        }
    }

    public static String toDescriptor(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append('L');
        sb.append(clazz.getName().replace('.', '/'));
        sb.append(';');
        return sb.toString();
    }

    MethodDef getMethodDef(int access, int methodRefPoolIndex) {
        Object o = this.pool[methodRefPoolIndex];
        if (o != null && o instanceof Assoc) {
            Assoc assoc = (Assoc)o;
            if (assoc.tag == 10) {
                int string_index = this.intPool[assoc.a];
                String className = (String)this.pool[string_index];
                int name_and_type_index = assoc.b;
                Assoc name_and_type = (Assoc)this.pool[name_and_type_index];
                if (name_and_type.tag == 12) {
                    int name_index = name_and_type.a;
                    int type_index = name_and_type.b;
                    String method = (String)this.pool[name_index];
                    String descriptor = (String)this.pool[type_index];
                    return new MethodDef(access, className, method, descriptor);
                }
                throw new IllegalArgumentException("Invalid class file (or parsing is wrong), assoc is not type + name (12)");
            }
            throw new IllegalArgumentException("Invalid class file (or parsing is wrong), Assoc is not method ref! (10)");
        }
        throw new IllegalArgumentException("Invalid class file (or parsing is wrong), Not an assoc at a method ref");
    }

    public static String getShortName(String cname) {
        int n = cname.lastIndexOf(46);
        if (n < 0) {
            return cname;
        }
        return cname.substring(n + 1, cname.length());
    }

    public static String fqnToPath(String dotted) {
        return String.valueOf(dotted.replace('.', '/')) + ".class";
    }

    public static String fqnToBinary(String dotted) {
        return "L" + dotted.replace('.', '/') + ";";
    }

    public static String pathToFqn(String path) {
        return path.replace('/', '.').substring(0, path.length() - 6);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public JAVA getFormat() {
        return JAVA.format(this.major);
    }

    public static String objectDescriptorToFQN(String string) {
        if (string.startsWith("L") && string.endsWith(";")) {
            return string.substring(1, string.length() - 1).replace('/', '.');
        }
        switch (string.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'S': {
                return "short";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'Z': {
                return "boolean";
            }
            case '[': {
                return String.valueOf(Clazz.objectDescriptorToFQN(string.substring(1))) + "[]";
            }
        }
        throw new IllegalArgumentException("Invalid type character in descriptor " + string);
    }

    public static String internalToFqn(String string) {
        return string.replace('/', '.');
    }

    public static String unCamel(String id) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < id.length()) {
            char c = id.charAt(i);
            if (c == '_' || c == '$' || c == '.') {
                if (out.length() > 0 && !Character.isWhitespace(out.charAt(out.length() - 1))) {
                    out.append(' ');
                }
            } else {
                int n = i;
                while (n < id.length() && Character.isUpperCase(id.charAt(n))) {
                    ++n;
                }
                if (n == i) {
                    out.append(id.charAt(i));
                } else {
                    boolean tolower;
                    boolean bl = tolower = n - i == 1;
                    if (i > 0 && !Character.isWhitespace(out.charAt(out.length() - 1))) {
                        out.append(' ');
                    }
                    while (i < n) {
                        if (tolower) {
                            out.append(Character.toLowerCase(id.charAt(i)));
                        } else {
                            out.append(id.charAt(i));
                        }
                        ++i;
                    }
                    --i;
                }
            }
            ++i;
        }
        if (id.startsWith(".")) {
            out.append(" *");
        }
        out.replace(0, 1, String.valueOf(Character.toUpperCase(out.charAt(0))));
        return out.toString();
    }

    protected static class Assoc {
        byte tag;
        int a;
        int b;

        Assoc(byte tag, int a, int b) {
            this.tag = tag;
            this.a = a;
            this.b = b;
        }
    }

    public class ClassConstant {
        int cname;

        public ClassConstant(int class_index) {
            this.cname = class_index;
        }

        public String getName() {
            return (String)Clazz.this.pool[this.cname];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldDef
    implements Comparable<FieldDef> {
        public final int access;
        public final String clazz;
        public final String name;
        public final String descriptor;
        public String signature;
        public Object constant;

        public FieldDef(int access, String clazz, String name, String descriptor) {
            this.access = access;
            this.clazz = clazz.replace('/', '.');
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean equals(Object other) {
            if (!(other instanceof MethodDef)) {
                return false;
            }
            FieldDef m = (FieldDef)other;
            return this.clazz.equals(m.clazz) && this.name.equals(m.name) && this.descriptor.equals(m.descriptor);
        }

        public int hashCode() {
            return this.clazz.hashCode() ^ this.name.hashCode() ^ this.descriptor.hashCode();
        }

        @Override
        public int compareTo(FieldDef o) {
            int result = this.clazz.compareTo(o.clazz);
            if (result == 0 && (result = this.name.compareTo(o.name)) == 0) {
                result = this.descriptor.compareTo(o.descriptor);
            }
            return result;
        }

        public String getPretty() {
            return this.name;
        }

        public String toString() {
            return this.getPretty();
        }

        public boolean isEnum() {
            return (this.access & 0x4000) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JAVA {
        UNKNOWN(Integer.MAX_VALUE),
        OpenJDK7(51),
        J2S6(50),
        J2SE5(49),
        JDK1_4(48),
        JDK1_3(47),
        JDK1_2(46),
        JDK1_1(45);

        final int major;

        private JAVA(int major) {
            this.major = major;
        }

        static JAVA format(int n) {
            JAVA[] jAVAArray = JAVA.values();
            int n2 = jAVAArray.length;
            int n3 = 0;
            while (n3 < n2) {
                JAVA e = jAVAArray[n3];
                if (e.major == n) {
                    return e;
                }
                ++n3;
            }
            return UNKNOWN;
        }

        public int getMajor() {
            return this.major;
        }

        public boolean hasAnnotations() {
            return this.major >= JAVA.J2SE5.major;
        }

        public boolean hasGenerics() {
            return this.major >= JAVA.J2SE5.major;
        }

        public boolean hasEnums() {
            return this.major >= JAVA.J2SE5.major;
        }
    }

    public static class MethodDef
    extends FieldDef {
        Pattern METHOD_DESCRIPTOR = Pattern.compile("\\((.*)\\)(.+)");

        public MethodDef(int access, String clazz, String method, String descriptor) {
            super(access, clazz, method, descriptor);
        }

        public boolean isConstructor() {
            return this.name.equals("<init>") || this.name.equals("<clinit>");
        }

        public String getReturnType() {
            Matcher m;
            String use = this.descriptor;
            if (this.signature != null) {
                use = this.signature;
            }
            if (!(m = this.METHOD_DESCRIPTOR.matcher(use)).matches()) {
                throw new IllegalArgumentException("Not a valid method descriptor: " + this.descriptor);
            }
            String returnType = m.group(2);
            return Clazz.objectDescriptorToFQN(returnType);
        }

        public String getPretty() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.descriptor.charAt(0));
            int index = 1;
            String del = "";
            while (index < this.descriptor.length() && this.descriptor.charAt(index) != ')') {
                sb.append(del);
                index = this.printParameter(sb, this.descriptor, index);
                del = ",";
            }
            sb.append(this.descriptor.charAt(index++));
            StringBuilder sb2 = new StringBuilder();
            if (this.isConstructor()) {
                sb2.append(Clazz.getShortName(this.clazz));
                ++index;
            } else {
                this.printParameter(sb2, this.descriptor, index);
                sb2.append(" ");
                sb2.append(Clazz.getShortName(this.clazz));
                sb2.append(".");
                sb2.append(this.name);
            }
            sb2.append((CharSequence)sb);
            return sb2.toString();
        }

        private int printParameter(StringBuilder sb, CharSequence descriptor, int index) {
            char c = descriptor.charAt(index++);
            switch (c) {
                case 'B': {
                    sb.append("byte");
                    break;
                }
                case 'C': {
                    sb.append("char");
                    break;
                }
                case 'D': {
                    sb.append("double");
                    break;
                }
                case 'F': {
                    sb.append("float");
                    break;
                }
                case 'I': {
                    sb.append("int");
                    break;
                }
                case 'J': {
                    sb.append("long");
                    break;
                }
                case 'S': {
                    sb.append("short");
                    break;
                }
                case 'Z': {
                    sb.append("boolean");
                    break;
                }
                case 'V': {
                    sb.append("void");
                    break;
                }
                case 'L': {
                    index = this.reference(sb, descriptor, index);
                    break;
                }
                case '[': {
                    index = this.array(sb, descriptor, index);
                }
            }
            return index;
        }

        private int reference(StringBuilder sb, CharSequence descriptor, int index) {
            int n;
            int lastSlash = n = sb.length();
            while (index < descriptor.length() && descriptor.charAt(index) != ';') {
                char c;
                if ((c = descriptor.charAt(index++)) == '/') {
                    c = '.';
                    lastSlash = sb.length() + 1;
                }
                sb.append(c);
            }
            if (lastSlash != n) {
                sb.delete(n, lastSlash);
            }
            return ++index;
        }

        private int array(StringBuilder sb, CharSequence descriptor, int index) {
            int n = 1;
            while (index < descriptor.length() && descriptor.charAt(index) == '[') {
                ++index;
            }
            index = this.printParameter(sb, descriptor, index);
            while (n-- > 0) {
                sb.append("[]");
            }
            return index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QUERY {
        IMPLEMENTS,
        EXTENDS,
        IMPORTS,
        NAMED,
        ANY,
        VERSION,
        CONCRETE,
        ABSTRACT,
        PUBLIC,
        ANNOTATION,
        RUNTIMEANNOTATIONS,
        CLASSANNOTATIONS;

    }
}

