/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.upnp.UPnPEventListener;

public class UPnPSubscriber {
    private BundleContext context;
    private UPnPEventListener listener;
    private HashMap hash;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPEventListener;

    public UPnPSubscriber(BundleContext context, UPnPEventListener listener) {
        this.context = context;
        this.listener = listener;
        this.hash = new HashMap();
    }

    public void subscribe(String deviceId, String serviceId) {
        String keys = "(&(UPnP.device.UDN=" + deviceId + ")(" + "UPnP.service.id" + "=" + serviceId + "))";
        if (this.hash.get(keys) == null) {
            this.hash.put(keys, new Subscription(keys));
        }
    }

    public void unsubscribe(String deviceId, String serviceId) {
        String keys = "(&(UPnP.device.UDN=" + deviceId + ")(" + "UPnP.service.id" + "=" + serviceId + "))";
        if (this.hash.containsKey(keys)) {
            Subscription subscription = (Subscription)this.hash.get(keys);
            subscription.unsubscribe();
            this.hash.remove(keys);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Subscription
    implements UPnPEventListener {
        ServiceRegistration registration;

        Subscription(String keys) {
            try {
                Filter filter = UPnPSubscriber.this.context.createFilter(keys);
                Properties props = new Properties();
                props.put("upnp.filter", filter);
                this.registration = UPnPSubscriber.this.context.registerService((class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = UPnPSubscriber.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName(), (Object)this, (Dictionary)props);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }

        public void unsubscribe() {
            this.registration.unregister();
        }

        public void notifyUPnPEvent(String arg0, String arg1, Dictionary arg2) {
            UPnPSubscriber.this.listener.notifyUPnPEvent(arg0, arg1, arg2);
        }
    }
}

