/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.packageadmin.internal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.webconsole.plugins.packageadmin.internal.WebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

class WebConsolePrinter
implements InventoryPrinter {
    private final PackageAdmin pa;
    private final BundleContext bc;

    WebConsolePrinter(BundleContext bc, PackageAdmin pa) {
        this.bc = bc;
        this.pa = pa;
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        try {
            Map<String, Set<ExportedPackage>> exports = WebConsolePlugin.collectExportedPackages(this.pa, this.bc);
            pw.print("Status: PackageAdmin service reports ");
            pw.print(String.valueOf(exports.size()));
            pw.println(" exported packages.");
            pw.println();
            this.dumpDuplicatesAsTxt(pw, exports);
        }
        catch (Exception e) {
            pw.println("failure ...." + e);
        }
    }

    private void dumpDuplicatesAsTxt(PrintWriter pw, Map<String, Set<ExportedPackage>> exports) {
        String[] entry;
        int i;
        pw.println("Duplicate Exported Packages");
        pw.println("---------------------------");
        ArrayList<String[]> lines = new ArrayList<String[]>();
        lines.add(new String[]{"Package", "Exports", "Imports"});
        for (Map.Entry<String, Set<ExportedPackage>> exportEntry : exports.entrySet()) {
            Set<ExportedPackage> exportSet = exportEntry.getValue();
            if (exportSet.size() <= 1) continue;
            String firstCol = exportEntry.getKey();
            for (ExportedPackage exportedPackage : exportSet) {
                Bundle[] importers = exportedPackage.getImportingBundles();
                String secondCol = "version=" + exportedPackage.getVersion() + ", Bundle " + exportedPackage.getExportingBundle();
                if (importers != null && importers.length > 0) {
                    boolean first = true;
                    for (int j = 0; j < importers.length; ++j) {
                        Bundle bundle = importers[j];
                        if (first) {
                            lines.add(new String[]{firstCol, secondCol, bundle.toString()});
                            first = false;
                            continue;
                        }
                        lines.add(new String[]{"", "", bundle.toString()});
                    }
                } else {
                    lines.add(new String[]{firstCol, secondCol, ""});
                }
                firstCol = "";
            }
        }
        int maxFirst = 0;
        int maxSecond = 0;
        for (i = 0; i < lines.size(); ++i) {
            entry = (String[])lines.get(i);
            if (entry[0].length() > maxFirst) {
                maxFirst = entry[0].length();
            }
            if (entry[1].length() <= maxSecond) continue;
            maxSecond = entry[1].length();
        }
        maxFirst += 2;
        maxSecond += 2;
        for (i = 0; i < lines.size(); ++i) {
            entry = (String[])lines.get(i);
            WebConsolePrinter.padText(pw, entry[0], maxFirst);
            WebConsolePrinter.padText(pw, entry[1], maxSecond);
            pw.println(entry[2]);
        }
    }

    private static final void padText(PrintWriter pw, String text, int length) {
        pw.print(text);
        int padLength = length - text.length();
        for (int i = 0; i < padLength; ++i) {
            pw.print(' ');
        }
    }

    public String getTitle() {
        return "Duplicate Exports";
    }
}

