/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.nodes.delegates;

import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.nodes.ObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.delegates.GetSetBase;
import org.eclipse.milo.opcua.sdk.server.util.AttributeUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;

public interface GetSetObjectNode
extends GetSetBase {
    default public DataValue getObjectAttribute(AttributeContext context, UaObjectNode node, AttributeId attributeId) throws UaException {
        switch (attributeId) {
            case EventNotifier: {
                return AttributeUtil.dv(this.getEventNotifier(context, node));
            }
        }
        return this.getBaseAttribute(context, node, attributeId);
    }

    default public void setObjectAttribute(AttributeContext context, ObjectNode node, AttributeId attributeId, DataValue value) throws UaException {
        switch (attributeId) {
            case EventNotifier: {
                this.setEventNotifier(context, node, (UByte)AttributeUtil.extract(value));
                break;
            }
            default: {
                this.setBaseAttribute(context, (Node)node, attributeId, value);
            }
        }
    }

    default public UByte getEventNotifier(AttributeContext context, ObjectNode node) throws UaException {
        return (UByte)((UaNode)node).getFilterChain().getAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.EventNotifier);
    }

    default public void setEventNotifier(AttributeContext context, ObjectNode node, UByte eventNotifier) throws UaException {
        ((UaNode)node).getFilterChain().setAttribute(context.getSession().orElse(null), (UaNode)node, AttributeId.EventNotifier, eventNotifier);
    }
}

