/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.AbstractOperator;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SimpleNestedLoopCrossJoinOperator
extends AbstractOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SimpleNestedLoopCrossJoinOperator.class);
    private final Operator probeSource;
    private final Operator buildSource;
    private final List<TsBlock> buildBlocks;
    private final TsBlockBuilder resultBuilder;
    private final MemoryReservationManager memoryReservationManager;
    private final int[] leftOutputSymbolIdx;
    private final int[] rightOutputSymbolIdx;
    private TsBlock cachedProbeBlock;
    private int probeIndex;
    private boolean buildFinished = false;

    public SimpleNestedLoopCrossJoinOperator(OperatorContext operatorContext, Operator probeSource, Operator buildSource, int[] leftOutputSymbolIdx, int[] rightOutputSymbolIdx, List<TSDataType> dataTypes) {
        this.operatorContext = operatorContext;
        this.probeSource = probeSource;
        this.buildSource = buildSource;
        this.leftOutputSymbolIdx = leftOutputSymbolIdx;
        this.rightOutputSymbolIdx = rightOutputSymbolIdx;
        this.buildBlocks = new ArrayList<TsBlock>();
        this.resultBuilder = new TsBlockBuilder(dataTypes);
        this.memoryReservationManager = operatorContext.getDriverContext().getFragmentInstanceContext().getMemoryReservationContext();
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.retainedTsBlock != null) {
            return this.getResultFromRetainedTsBlock();
        }
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        if (!this.buildFinished) {
            if (!this.buildSource.hasNextWithTimer()) {
                this.buildFinished = true;
            } else {
                TsBlock block = this.buildSource.nextWithTimer();
                if (block != null && !block.isEmpty()) {
                    this.buildBlocks.add(block);
                    this.memoryReservationManager.reserveMemoryCumulatively(block.getRetainedSizeInBytes());
                }
            }
            return null;
        }
        TsBlock tsBlock = this.cachedProbeBlock = this.cachedProbeBlock == null ? this.probeSource.nextWithTimer() : this.cachedProbeBlock;
        if (this.cachedProbeBlock == null || this.cachedProbeBlock.isEmpty()) {
            this.cachedProbeBlock = null;
            return null;
        }
        while (!this.resultBuilder.isFull() && this.probeIndex < this.cachedProbeBlock.getPositionCount() && System.nanoTime() - start < maxRuntime) {
            for (TsBlock buildBlock : this.buildBlocks) {
                this.appendValueToResult(this.probeIndex, buildBlock);
            }
            ++this.probeIndex;
        }
        if (this.probeIndex == this.cachedProbeBlock.getPositionCount()) {
            this.probeIndex = 0;
            this.cachedProbeBlock = null;
        }
        if (this.resultBuilder.isEmpty()) {
            return null;
        }
        this.resultTsBlock = this.resultBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultBuilder.getPositionCount()));
        this.resultBuilder.reset();
        return this.checkTsBlockSizeAndGetResult();
    }

    private void appendValueToResult(int probeIndex, TsBlock buildBlock) {
        int j;
        ColumnBuilder columnBuilder;
        int i;
        for (i = 0; i < this.leftOutputSymbolIdx.length; ++i) {
            columnBuilder = this.resultBuilder.getColumnBuilder(i);
            for (j = 0; j < buildBlock.getPositionCount(); ++j) {
                if (this.cachedProbeBlock.getColumn(this.leftOutputSymbolIdx[i]).isNull(probeIndex)) {
                    columnBuilder.appendNull();
                    continue;
                }
                columnBuilder.write(this.cachedProbeBlock.getColumn(this.leftOutputSymbolIdx[i]), probeIndex);
            }
        }
        for (i = 0; i < this.rightOutputSymbolIdx.length; ++i) {
            columnBuilder = this.resultBuilder.getColumnBuilder(i + this.leftOutputSymbolIdx.length);
            for (j = 0; j < buildBlock.getPositionCount(); ++j) {
                if (buildBlock.getColumn(this.rightOutputSymbolIdx[i]).isNull(j)) {
                    columnBuilder.appendNull();
                    continue;
                }
                columnBuilder.write(buildBlock.getColumn(this.rightOutputSymbolIdx[i]), j);
            }
        }
        this.resultBuilder.declarePositions(buildBlock.getPositionCount());
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        if (!this.buildFinished) {
            return true;
        }
        return !this.buildBlocks.isEmpty() && (this.cachedProbeBlock != null && !this.cachedProbeBlock.isEmpty() || this.probeSource.hasNextWithTimer());
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.buildFinished) {
            return this.probeSource.isBlocked();
        }
        return this.buildSource.isBlocked();
    }

    @Override
    public void close() throws Exception {
        if (this.probeSource != null) {
            this.probeSource.close();
        }
        if (this.buildSource != null) {
            this.buildSource.close();
        }
        for (TsBlock block : this.buildBlocks) {
            this.memoryReservationManager.releaseMemoryCumulatively(block.getRetainedSizeInBytes());
        }
        this.buildBlocks.clear();
        this.cachedProbeBlock = null;
        this.resultTsBlock = null;
        this.retainedTsBlock = null;
    }

    @Override
    public boolean isFinished() throws Exception {
        if (this.retainedTsBlock != null) {
            return false;
        }
        if (this.buildFinished) {
            if (this.buildBlocks.isEmpty()) {
                return true;
            }
            return (this.cachedProbeBlock == null || this.cachedProbeBlock.isEmpty()) && this.probeSource.isFinished();
        }
        return false;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return Math.max(Math.max(this.probeSource.calculateMaxPeekMemoryWithCounter(), this.buildSource.calculateMaxPeekMemoryWithCounter()), this.calculateRetainedSizeAfterCallingNext() + this.calculateMaxReturnSize());
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.probeSource.calculateRetainedSizeAfterCallingNext() + this.buildSource.calculateRetainedSizeAfterCallingNext() + this.maxReturnSize * 2L;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.probeSource) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.buildSource) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultBuilder.getRetainedSizeInBytes();
    }
}

