/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Fill;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Limit;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QueryBody;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.With;

public class Query
extends Statement {
    private final Optional<With> with;
    private final QueryBody queryBody;
    private final Optional<Fill> fill;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<Node> limit;

    public Query(Optional<With> with, QueryBody queryBody, Optional<Fill> fill, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(null, with, queryBody, fill, orderBy, offset, limit);
    }

    public Query(NodeLocation location, Optional<With> with, QueryBody queryBody, Optional<Fill> fill, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        super(location);
        Objects.requireNonNull(with, "with is null");
        Objects.requireNonNull(queryBody, "queryBody is null");
        Objects.requireNonNull(fill, "fill is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(offset, "offset is null");
        Objects.requireNonNull(limit, "limit is null");
        Preconditions.checkArgument((!limit.isPresent() || limit.get() instanceof Limit ? 1 : 0) != 0, (Object)"limit must be optional of either FetchFirst or Limit type");
        this.with = with;
        this.queryBody = queryBody;
        this.fill = fill;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public Optional<With> getWith() {
        return this.with;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public Optional<Fill> getFill() {
        return this.fill;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<Node> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.with.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.add((Object)this.queryBody);
        this.fill.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.offset.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.limit.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("with", this.with.orElse(null)).add("queryBody", (Object)this.queryBody).add("orderBy", this.fill.orElse(null)).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equals(this.with, o.with) && Objects.equals(this.queryBody, o.queryBody) && Objects.equals(this.fill, o.fill) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.offset, o.offset) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.with, this.queryBody, this.fill, this.orderBy, this.offset, this.limit);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Query.sameClass(this, other);
    }
}

