/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class UpdateAssignment
extends Node {
    private final Expression name;
    private final Expression value;

    public UpdateAssignment(Expression name, Expression value) {
        super(null);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public UpdateAssignment(NodeLocation location, Expression name, Expression value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Expression getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUpdateAssignment(this, context);
    }

    public void serialize(ByteBuffer byteBuffer) {
        Expression.serialize(this.name, byteBuffer);
        Expression.serialize(this.value, byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        Expression.serialize(this.name, stream);
        Expression.serialize(this.value, stream);
    }

    public static UpdateAssignment deserialize(ByteBuffer buffer) {
        return new UpdateAssignment(Expression.deserialize(buffer), Expression.deserialize(buffer));
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.name, (Object)this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateAssignment other = (UpdateAssignment)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return this.name + " = " + this.value;
    }
}

