/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.HashSet;
import java.util.Set;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.PartContentDescriptorImpl;

public class FetchGroupImpl
implements MessageResult.FetchGroup {
    public static final MessageResult.FetchGroup MINIMAL = new FetchGroupImpl(0);
    public static final MessageResult.FetchGroup HEADERS = new FetchGroupImpl(256);
    public static final MessageResult.FetchGroup FULL_CONTENT = new FetchGroupImpl(512);
    public static final MessageResult.FetchGroup BODY_CONTENT = new FetchGroupImpl(1024);
    private int content = 0;
    private Set<MessageResult.FetchGroup.PartContentDescriptor> partContentDescriptors;

    public FetchGroupImpl() {
        this(0, new HashSet<MessageResult.FetchGroup.PartContentDescriptor>());
    }

    public FetchGroupImpl(int content) {
        this(content, new HashSet<MessageResult.FetchGroup.PartContentDescriptor>());
    }

    public FetchGroupImpl(int content, Set<MessageResult.FetchGroup.PartContentDescriptor> partContentDescriptors) {
        this.content = content;
        this.partContentDescriptors = partContentDescriptors;
    }

    @Override
    public int content() {
        return this.content;
    }

    public void or(int content) {
        this.content |= content;
    }

    public String toString() {
        return "Fetch " + this.content;
    }

    @Override
    public Set<MessageResult.FetchGroup.PartContentDescriptor> getPartContentDescriptors() {
        return this.partContentDescriptors;
    }

    public void addPartContent(MessageResult.MimePath path, int content) {
        if (this.partContentDescriptors == null) {
            this.partContentDescriptors = new HashSet<MessageResult.FetchGroup.PartContentDescriptor>();
        }
        PartContentDescriptorImpl currentDescriptor = (PartContentDescriptorImpl)this.partContentDescriptors.stream().filter(descriptor -> path.equals(descriptor.path())).findFirst().orElseGet(() -> {
            PartContentDescriptorImpl result = new PartContentDescriptorImpl(path);
            this.partContentDescriptors.add(result);
            return result;
        });
        currentDescriptor.or(content);
    }
}

