/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model.search;

import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.james.mailbox.model.search.MailboxNameExpression;

public class PrefixedRegex
implements MailboxNameExpression {
    private final String prefix;
    private final String regex;
    private final Pattern pattern;
    private final char pathDelimiter;

    public PrefixedRegex(String prefix, String regex, char pathDelimiter) {
        this.prefix = Optional.ofNullable(prefix).orElse("");
        this.regex = Optional.ofNullable(regex).orElse("");
        this.pathDelimiter = pathDelimiter;
        this.pattern = this.constructEscapedRegex(this.regex);
    }

    @Override
    public boolean isExpressionMatch(String name) {
        return name.startsWith(this.prefix) && this.regexMatching(name.substring(this.prefix.length()));
    }

    private boolean regexMatching(String name) {
        if (this.isWild()) {
            return name != null && this.pattern.matcher(name).matches();
        }
        return this.regex.equals(name);
    }

    @Override
    public String getCombinedName() {
        if (this.prefix != null && this.prefix.length() > 0) {
            int baseLength = this.prefix.length();
            if (this.prefix.charAt(baseLength - 1) == this.pathDelimiter) {
                if (this.regex != null && this.regex.length() > 0) {
                    if (this.regex.charAt(0) == this.pathDelimiter) {
                        return this.prefix + this.regex.substring(1);
                    }
                    return this.prefix + this.regex;
                }
                return this.prefix;
            }
            if (this.regex != null && this.regex.length() > 0) {
                if (this.regex.charAt(0) == this.pathDelimiter) {
                    return this.prefix + this.regex;
                }
                return this.prefix + this.pathDelimiter + this.regex;
            }
            return this.prefix;
        }
        return this.regex;
    }

    @Override
    public boolean isWild() {
        return this.regex != null && (this.regex.indexOf(42) >= 0 || this.regex.indexOf(37) >= 0);
    }

    private Pattern constructEscapedRegex(String regex) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(regex, "*%", true);
        while (tokenizer.hasMoreTokens()) {
            stringBuilder.append(this.getRegexPartAssociatedWithToken(tokenizer));
        }
        return Pattern.compile(stringBuilder.toString());
    }

    private String getRegexPartAssociatedWithToken(StringTokenizer tokenizer) {
        String token = tokenizer.nextToken();
        if (token.equals("*")) {
            return ".*";
        }
        if (token.equals("%")) {
            return "[^" + Pattern.quote(String.valueOf(this.pathDelimiter)) + "]*";
        }
        return Pattern.quote(token);
    }
}

