/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.jmap.api.change.CanNotCalculateChangesException;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.State;
import org.apache.james.mailbox.model.MessageId;

public class EmailChanges {
    private State newState;
    private final boolean hasMoreChanges;
    private final Set<MessageId> created;
    private final Set<MessageId> updated;
    private final Set<MessageId> destroyed;

    private EmailChanges(State newState, boolean hasMoreChanges, Set<MessageId> created, Set<MessageId> updated, Set<MessageId> destroyed) {
        this.newState = newState;
        this.hasMoreChanges = hasMoreChanges;
        this.created = created;
        this.updated = updated;
        this.destroyed = destroyed;
    }

    public State getNewState() {
        return this.newState;
    }

    public boolean hasMoreChanges() {
        return this.hasMoreChanges;
    }

    public Set<MessageId> getCreated() {
        return this.created;
    }

    public Set<MessageId> getUpdated() {
        return this.updated;
    }

    public Set<MessageId> getDestroyed() {
        return this.destroyed;
    }

    public List<MessageId> getAllChanges() {
        return ImmutableList.builder().addAll(this.created).addAll(this.updated).addAll(this.destroyed).build();
    }

    public static class Builder {
        private State state;
        private boolean hasMoreChanges;
        private boolean canAddMoreItem;
        private Limit limit;
        private Set<MessageId> created;
        private Set<MessageId> updated;
        private Set<MessageId> destroyed;

        public Builder(State state, Limit limit) {
            this.limit = limit;
            this.state = state;
            this.hasMoreChanges = false;
            this.canAddMoreItem = true;
            this.created = new HashSet<MessageId>();
            this.updated = new HashSet<MessageId>();
            this.destroyed = new HashSet<MessageId>();
        }

        public Builder add(EmailChange change) {
            if (!this.canAddMoreItem) {
                return this;
            }
            HashSet<MessageId> destroyedTemp = new HashSet<MessageId>(this.destroyed);
            Sets.SetView createdTemp = Sets.difference((Set)ImmutableSet.builder().addAll(this.created).addAll(change.getCreated()).build(), (Set)ImmutableSet.copyOf(change.getDestroyed()));
            Sets.SetView updatedTemp = Sets.difference((Set)ImmutableSet.builder().addAll(this.updated).addAll((Iterable)ImmutableSet.copyOf(change.getUpdated())).build(), (Set)ImmutableSet.copyOf(change.getDestroyed()));
            destroyedTemp.addAll((Collection<MessageId>)Sets.difference((Set)ImmutableSet.copyOf(change.getDestroyed()), this.created));
            if (createdTemp.size() + updatedTemp.size() + destroyedTemp.size() > this.limit.getValue()) {
                this.hasMoreChanges = true;
                this.canAddMoreItem = false;
                return this;
            }
            this.state = change.getState();
            this.created = createdTemp;
            this.updated = updatedTemp;
            this.destroyed = destroyedTemp;
            return this;
        }

        public EmailChanges build() {
            if (this.hasMoreChanges && this.created.isEmpty() && this.updated.isEmpty() && this.destroyed.isEmpty()) {
                throw new CanNotCalculateChangesException(String.format("Current change collector limit %d is exceeded by a single change, hence we cannot calculate changes.", this.limit.getValue()));
            }
            return new EmailChanges(this.state, this.hasMoreChanges, this.created, this.updated, this.destroyed);
        }

        public static class EmailChangeCollector
        implements Collector<EmailChange, Builder, EmailChanges> {
            private final Limit limit;
            private final State state;

            public EmailChangeCollector(State state, Limit limit) {
                this.limit = limit;
                this.state = state;
            }

            @Override
            public Supplier<Builder> supplier() {
                return () -> new Builder(this.state, this.limit);
            }

            @Override
            public BiConsumer<Builder, EmailChange> accumulator() {
                return Builder::add;
            }

            @Override
            public BinaryOperator<Builder> combiner() {
                throw new NotImplementedException("Not supported");
            }

            @Override
            public Function<Builder, EmailChanges> finisher() {
                return Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.of();
            }
        }
    }
}

