/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.micrometer.core.instrument.Gauge;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;

final class MicrometerEventLoopMeterRegistrar {
    static final MicrometerEventLoopMeterRegistrar INSTANCE = new MicrometerEventLoopMeterRegistrar();
    private final ConcurrentMap<String, EventLoop> cache = new ConcurrentHashMap<String, EventLoop>();

    private MicrometerEventLoopMeterRegistrar() {
    }

    void registerMetrics(EventLoop eventLoop) {
        if (eventLoop instanceof SingleThreadEventExecutor) {
            SingleThreadEventExecutor singleThreadEventExecutor = (SingleThreadEventExecutor)eventLoop;
            String executorName = singleThreadEventExecutor.threadProperties().name();
            this.cache.computeIfAbsent(executorName, key -> {
                Gauge.builder((String)"reactor.netty.eventloop.pending.tasks", () -> ((SingleThreadEventExecutor)singleThreadEventExecutor).pendingTasks()).description("Event loop pending scheduled tasks.").tag("name", executorName).register(Metrics.REGISTRY);
                return eventLoop;
            });
        }
    }
}

