/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.base;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.vavr.API;
import io.vavr.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.mail.Flags;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.Registration;
import org.apache.james.events.RegistrationKey;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.processor.base.UidMsnConverter;
import org.apache.james.mailbox.FlagsBuilder;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.NullableMessageSequenceNumber;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class SelectedMailboxImpl
implements SelectedMailbox,
EventListener {
    private static final Void VOID = null;
    private final Registration registration;
    private final MailboxManager mailboxManager;
    private final MailboxId mailboxId;
    private final ImapSession session;
    private final MailboxSession.SessionId sessionId;
    private final MailboxSession mailboxSession;
    private final UidMsnConverter uidMsnConverter;
    private final Set<MessageUid> recentUids = new TreeSet<MessageUid>();
    private final Set<MessageUid> flagUpdateUids = new TreeSet<MessageUid>();
    private final Flags.Flag uninterestingFlag = Flags.Flag.RECENT;
    private final Set<MessageUid> expungedUids = new TreeSet<MessageUid>();
    private final Object applicableFlagsLock = new Object();
    private final AtomicReference<EventListener> idleEventListener = new AtomicReference();
    private boolean recentUidRemoved = false;
    private boolean isDeletedByOtherSession = false;
    private boolean sizeChanged = false;
    private boolean silentFlagChanges = false;
    private ApplicableFlags applicableFlags = ApplicableFlags.from(new Flags());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectedMailboxImpl(MailboxManager mailboxManager, EventBus eventBus, ImapSession session, MessageManager messageManager) throws MailboxException {
        this.session = session;
        this.sessionId = session.getMailboxSession().getSessionId();
        this.mailboxManager = mailboxManager;
        this.setSilentFlagChanges(true);
        this.mailboxSession = session.getMailboxSession();
        this.uidMsnConverter = new UidMsnConverter();
        this.mailboxId = messageManager.getId();
        this.registration = (Registration)Mono.from((Publisher)eventBus.register((EventListener)this, (RegistrationKey)new MailboxIdRegistrationKey(this.mailboxId))).subscribeOn(Schedulers.elastic()).block();
        Object object = this.applicableFlagsLock;
        synchronized (object) {
            this.applicableFlags = this.applicableFlags.updateWithNewFlags(messageManager.getApplicableFlags(this.mailboxSession));
        }
        ImmutableList uids = (ImmutableList)Flux.from((Publisher)messageManager.search(SearchQuery.of((SearchQuery.Criterion[])new SearchQuery.Criterion[]{SearchQuery.all()}), this.mailboxSession)).collect(ImmutableList.toImmutableList()).block();
        this.uidMsnConverter.addAll((List<MessageUid>)uids);
    }

    @Override
    public void registerIdle(EventListener idle) {
        this.idleEventListener.set(idle);
    }

    @Override
    public void unregisterIdle() {
        this.idleEventListener.set(null);
    }

    @Override
    public synchronized Optional<MessageUid> getFirstUid() {
        return this.uidMsnConverter.getFirstUid();
    }

    @Override
    public synchronized Optional<MessageUid> getLastUid() {
        return this.uidMsnConverter.getLastUid();
    }

    @Override
    public synchronized void deselect() {
        this.registration.unregister();
        this.uidMsnConverter.clear();
        this.flagUpdateUids.clear();
        this.expungedUids.clear();
        this.recentUids.clear();
    }

    @Override
    public synchronized boolean removeRecent(MessageUid uid) {
        boolean result = this.recentUids.remove(uid);
        if (result) {
            this.recentUidRemoved = true;
        }
        return result;
    }

    @Override
    public synchronized boolean addRecent(MessageUid uid) {
        return this.recentUids.add(uid);
    }

    @Override
    public synchronized Collection<MessageUid> getRecent() {
        this.checkExpungedRecents();
        return new ArrayList<MessageUid>(this.recentUids);
    }

    @Override
    public synchronized int recentCount() {
        this.checkExpungedRecents();
        return this.recentUids.size();
    }

    @Override
    public MailboxPath getPath() throws MailboxException {
        return this.mailboxManager.getMailbox(this.mailboxId, this.mailboxSession).getMailboxPath();
    }

    @Override
    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    private void checkExpungedRecents() {
        for (MessageUid uid : this.expungedUids()) {
            this.removeRecent(uid);
        }
    }

    @Override
    public synchronized boolean isRecent(MessageUid uid) {
        return this.recentUids.contains(uid);
    }

    @Override
    public synchronized boolean isRecentUidRemoved() {
        return this.recentUidRemoved;
    }

    @Override
    public synchronized void resetRecentUidRemoved() {
        this.recentUidRemoved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resetEvents() {
        this.sizeChanged = false;
        this.flagUpdateUids.clear();
        this.isDeletedByOtherSession = false;
        Object object = this.applicableFlagsLock;
        synchronized (object) {
            this.applicableFlags = this.applicableFlags.ackUpdates();
        }
    }

    @Override
    public synchronized NullableMessageSequenceNumber remove(MessageUid uid) {
        NullableMessageSequenceNumber result = this.msn(uid);
        this.uidMsnConverter.remove(uid);
        return result;
    }

    private boolean interestingFlags(UpdatedFlags updated) {
        Flags.Flag flag;
        Iterator it = updated.modifiedSystemFlags().iterator();
        boolean result = it.hasNext() ? !(flag = (Flags.Flag)it.next()).equals(this.uninterestingFlag) : false;
        if (!result) {
            Iterator userIt = updated.userFlagIterator();
            result = userIt.hasNext();
        }
        return result;
    }

    @Override
    public synchronized void resetExpungedUids() {
        this.expungedUids.clear();
    }

    public final synchronized boolean isSilentFlagChanges() {
        return this.silentFlagChanges;
    }

    public final synchronized void setSilentFlagChanges(boolean silentFlagChanges) {
        this.silentFlagChanges = silentFlagChanges;
    }

    @Override
    public final synchronized boolean isSizeChanged() {
        return this.sizeChanged;
    }

    @Override
    public final synchronized boolean isDeletedByOtherSession() {
        return this.isDeletedByOtherSession;
    }

    @Override
    public synchronized Collection<MessageUid> flagUpdateUids() {
        return Collections.unmodifiableSet(new TreeSet<MessageUid>(this.flagUpdateUids));
    }

    @Override
    public synchronized Collection<MessageUid> expungedUids() {
        return Collections.unmodifiableSet(new TreeSet<MessageUid>(this.expungedUids));
    }

    @Override
    public Flags getApplicableFlags() {
        return this.applicableFlags.flags();
    }

    @Override
    public boolean hasNewApplicableFlags() {
        return this.applicableFlags.updated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resetNewApplicableFlags() {
        Object object = this.applicableFlagsLock;
        synchronized (object) {
            this.applicableFlags = this.applicableFlags.ackUpdates();
        }
    }

    public void event(Event event) {
        this.eventSynchronized(event);
        Optional.ofNullable(this.idleEventListener.get()).ifPresent(Throwing.consumer(listener -> listener.event(event)).sneakyThrow());
    }

    private synchronized void eventSynchronized(Event event) {
        if (event instanceof MailboxEvents.MailboxEvent) {
            MailboxEvents.MailboxEvent mailboxEvent = (MailboxEvents.MailboxEvent)event;
            this.mailboxEvent(mailboxEvent);
        }
    }

    private void mailboxEvent(MailboxEvents.MailboxEvent mailboxEvent) {
        if (mailboxEvent.getMailboxId().equals(this.getMailboxId())) {
            API.Match((Object)mailboxEvent).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.Added.class)), this::handleAddition), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.FlagsUpdated.class)), this::handleFlagsUpdates), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.Expunged.class)), this::handleMailboxExpunge), API.Case((API.Match.Pattern0)API.$((Predicate)Predicates.instanceOf(MailboxEvents.MailboxDeletion.class)), this::handleMailboxDeletion), API.Case((API.Match.Pattern0)API.$(), (Object)VOID)});
        }
    }

    private Void handleMailboxDeletion(MailboxEvents.MailboxDeletion mailboxDeletion) {
        if (mailboxDeletion.getSessionId() != this.sessionId) {
            this.isDeletedByOtherSession = true;
        }
        return VOID;
    }

    private Void handleMailboxExpunge(MailboxEvents.MessageEvent messageEvent) {
        this.expungedUids.addAll(messageEvent.getUids());
        return VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Void handleFlagsUpdates(MailboxEvents.FlagsUpdated updated) {
        SelectedMailbox sm;
        List uFlags = updated.getUpdatedFlags();
        if (this.sessionId != updated.getSessionId() || !this.silentFlagChanges) {
            for (UpdatedFlags u : uFlags) {
                if (!this.interestingFlags(u)) continue;
                this.flagUpdateUids.add(u.getUid());
            }
        }
        if ((sm = this.session.getSelected()) != null) {
            List uflags = updated.getUpdatedFlags();
            for (UpdatedFlags u : uflags) {
                Iterator flags = u.modifiedSystemFlags().iterator();
                while (flags.hasNext()) {
                    MailboxId id;
                    if (!Flags.Flag.RECENT.equals(flags.next()) || (id = sm.getMailboxId()) == null || !id.equals(updated.getMailboxId())) continue;
                    sm.addRecent(u.getUid());
                }
            }
        }
        Object object = this.applicableFlagsLock;
        synchronized (object) {
            this.applicableFlags = SelectedMailboxImpl.updateApplicableFlags(this.applicableFlags, updated);
        }
        return VOID;
    }

    private Void handleAddition(MailboxEvents.Added added) {
        this.sizeChanged = true;
        SelectedMailbox sm = this.session.getSelected();
        for (MessageUid uid : added.getUids()) {
            this.uidMsnConverter.addUid(uid);
            if (sm == null) continue;
            sm.addRecent(uid);
        }
        return VOID;
    }

    @VisibleForTesting
    static ApplicableFlags updateApplicableFlags(ApplicableFlags applicableFlags, MailboxEvents.FlagsUpdated flagsUpdated) {
        Flags updatedFlags = SelectedMailboxImpl.mergeAllNewFlags(flagsUpdated);
        return applicableFlags.updateWithNewFlags(updatedFlags);
    }

    private static Flags mergeAllNewFlags(MailboxEvents.FlagsUpdated flagsUpdated) {
        List flags = flagsUpdated.getUpdatedFlags();
        FlagsBuilder builder = FlagsBuilder.builder();
        flags.stream().map(UpdatedFlags::getNewFlags).forEach(xva$0 -> builder.add(new Flags[]{xva$0}));
        return builder.build();
    }

    @Override
    public synchronized NullableMessageSequenceNumber msn(MessageUid uid) {
        return this.uidMsnConverter.getMsn(uid);
    }

    @Override
    public synchronized Optional<MessageUid> uid(int msn) {
        if (msn == -1) {
            return Optional.empty();
        }
        return this.uidMsnConverter.getUid(msn);
    }

    @Override
    public synchronized long existsCount() {
        return this.uidMsnConverter.getNumMessage();
    }

    @VisibleForTesting
    static class ApplicableFlags {
        private final Flags flags;
        private final boolean updated;

        static ApplicableFlags from(Flags flags) {
            boolean updated = false;
            return new ApplicableFlags(flags, updated);
        }

        private ApplicableFlags(Flags flags, boolean updated) {
            this.flags = flags;
            this.updated = updated;
        }

        public ApplicableFlags ackUpdates() {
            return new ApplicableFlags(this.flags, false);
        }

        public Flags flags() {
            return new Flags(this.flags);
        }

        public boolean updated() {
            return this.updated;
        }

        public ApplicableFlags updateWithNewFlags(Flags newFlags) {
            Flags updatedFlags = this.flags();
            int size = updatedFlags.getUserFlags().length;
            updatedFlags.add(newFlags);
            updatedFlags.remove(Flags.Flag.RECENT);
            boolean applicableFlagsChanged = size < updatedFlags.getUserFlags().length;
            return new ApplicableFlags(updatedFlags, applicableFlagsChanged);
        }
    }
}

