/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Optional;

public class AwsS3AuthConfiguration {
    private final URI endpoint;
    private final String accessKeyId;
    private final String secretKey;
    private final Optional<String> trustStorePath;
    private final Optional<String> trustStoreType;
    private final Optional<String> trustStoreSecret;
    private final Optional<String> trustStoreAlgorithm;

    public static Builder.RequiredEndpoint builder() {
        return endpoint -> accessKeyId -> secretKey -> new Builder.ReadyToBuild(endpoint, accessKeyId, secretKey);
    }

    private AwsS3AuthConfiguration(URI endpoint, String accessKeyId, String secretKey, Optional<String> trustStorePath, Optional<String> trustStoreType, Optional<String> trustStoreSecret, Optional<String> trustStoreAlgorithm) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.secretKey = secretKey;
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.trustStoreSecret = trustStoreSecret;
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public Optional<String> getTrustStorePath() {
        return this.trustStorePath;
    }

    public Optional<String> getTrustStoreType() {
        return this.trustStoreType;
    }

    public Optional<String> getTrustStoreSecret() {
        return this.trustStoreSecret;
    }

    public Optional<String> getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public final boolean equals(Object o) {
        if (o instanceof AwsS3AuthConfiguration) {
            AwsS3AuthConfiguration that = (AwsS3AuthConfiguration)o;
            return Objects.equal((Object)this.endpoint, (Object)that.endpoint) && Objects.equal((Object)this.accessKeyId, (Object)that.accessKeyId) && Objects.equal((Object)this.secretKey, (Object)that.secretKey) && Objects.equal(this.trustStorePath, that.trustStorePath) && Objects.equal(this.trustStoreType, that.trustStoreType) && Objects.equal(this.trustStoreSecret, that.trustStoreSecret) && Objects.equal(this.trustStoreAlgorithm, that.trustStoreAlgorithm);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.endpoint, this.accessKeyId, this.secretKey, this.trustStorePath, this.trustStoreType, this.trustStoreSecret, this.trustStoreAlgorithm});
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("endpoint", (Object)this.endpoint).add("accessKeyId", (Object)this.accessKeyId).add("secretKey", (Object)this.secretKey).add("trustStorePath", this.trustStorePath).add("trustStoreSecret", this.trustStoreSecret).add("trustStoreAlgorithm", this.trustStoreAlgorithm).toString();
    }

    public static interface Builder {

        public static class ReadyToBuild {
            private final URI endpoint;
            private final String accessKeyId;
            private final String secretKey;
            private Optional<String> trustStorePath;
            private Optional<String> trustStoreType;
            private Optional<String> trustStoreSecret;
            private Optional<String> trustStoreAlgorithm;

            public ReadyToBuild(URI endpoint, String accessKeyId, String secretKey) {
                this.endpoint = endpoint;
                this.accessKeyId = accessKeyId;
                this.secretKey = secretKey;
                this.trustStorePath = Optional.empty();
                this.trustStoreType = Optional.empty();
                this.trustStoreSecret = Optional.empty();
                this.trustStoreAlgorithm = Optional.empty();
            }

            public ReadyToBuild trustStorePath(Optional<String> trustStorePath) {
                this.trustStorePath = trustStorePath;
                return this;
            }

            public ReadyToBuild trustStorePath(String trustStorePath) {
                return this.trustStorePath(Optional.ofNullable(trustStorePath));
            }

            public ReadyToBuild trustStoreType(Optional<String> trustStoreType) {
                this.trustStoreType = trustStoreType;
                return this;
            }

            public ReadyToBuild trustStoreType(String trustStoreType) {
                return this.trustStoreType(Optional.ofNullable(trustStoreType));
            }

            public ReadyToBuild trustStoreSecret(Optional<String> trustStoreSecret) {
                this.trustStoreSecret = trustStoreSecret;
                return this;
            }

            public ReadyToBuild trustStoreSecret(String trustStoreSecret) {
                return this.trustStoreSecret(Optional.ofNullable(trustStoreSecret));
            }

            public ReadyToBuild trustStoreAlgorithm(Optional<String> trustStoreAlgorithm) {
                this.trustStoreAlgorithm = trustStoreAlgorithm;
                return this;
            }

            public ReadyToBuild trustStoreAlgorithm(String trustStoreAlgorithm) {
                return this.trustStoreAlgorithm(Optional.ofNullable(trustStoreAlgorithm));
            }

            public AwsS3AuthConfiguration build() {
                Preconditions.checkNotNull((Object)this.endpoint, (Object)"'endpoint' is mandatory");
                Preconditions.checkNotNull((Object)this.accessKeyId, (Object)"'accessKeyId' is mandatory");
                Preconditions.checkArgument((!this.accessKeyId.isEmpty() ? 1 : 0) != 0, (Object)"'accessKeyId' is mandatory");
                Preconditions.checkNotNull((Object)this.secretKey, (Object)"'secretKey' is mandatory");
                Preconditions.checkArgument((!this.secretKey.isEmpty() ? 1 : 0) != 0, (Object)"'secretKey' is mandatory");
                return new AwsS3AuthConfiguration(this.endpoint, this.accessKeyId, this.secretKey, this.trustStorePath, this.trustStoreType, this.trustStoreSecret, this.trustStoreAlgorithm);
            }
        }

        @FunctionalInterface
        public static interface RequiredSecretKey {
            public ReadyToBuild secretKey(String var1);
        }

        @FunctionalInterface
        public static interface RequiredAccessKeyId {
            public RequiredSecretKey accessKeyId(String var1);
        }

        @FunctionalInterface
        public static interface RequiredEndpoint {
            public RequiredAccessKeyId endpoint(URI var1);
        }
    }
}

