/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQManagementAPI;
import org.apache.james.queue.rabbitmq.MailQueueName;

public class RabbitMQMailQueueManagement {
    private final RabbitMQManagementAPI api;

    @Inject
    RabbitMQMailQueueManagement(RabbitMQConfiguration configuration) {
        this.api = RabbitMQManagementAPI.from((RabbitMQConfiguration)configuration);
    }

    @VisibleForTesting
    RabbitMQMailQueueManagement(RabbitMQManagementAPI api) {
        this.api = api;
    }

    Stream<MailQueueName> listCreatedMailQueueNames() {
        return this.api.listQueues().stream().map(RabbitMQManagementAPI.MessageQueue::getName).map(MailQueueName::fromRabbitWorkQueueName).flatMap(Optional::stream).distinct();
    }

    public void deleteAllQueues() {
        this.api.listQueues().forEach(queue -> this.api.deleteQueue("/", queue.getName()));
    }
}

