/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;

public class ComposedMessageId {
    private final MailboxId mailboxId;
    private final MessageId messageId;
    private final MessageUid uid;

    public ComposedMessageId(MailboxId mailboxId, MessageId messageId, MessageUid uid) {
        this.mailboxId = mailboxId;
        this.messageId = messageId;
        this.uid = uid;
    }

    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageUid getUid() {
        return this.uid;
    }

    public final boolean equals(Object o) {
        if (o instanceof ComposedMessageId) {
            ComposedMessageId other = (ComposedMessageId)o;
            return Objects.equal(this.mailboxId, other.mailboxId) && Objects.equal(this.messageId, other.messageId) && Objects.equal(this.uid, other.uid);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.mailboxId, this.messageId, this.uid);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("mailboxId", this.mailboxId).add("messageId", this.messageId).add("uid", this.uid).toString();
    }
}

