/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.events.Event;
import org.apache.james.events.EventDeadLetters;
import org.apache.james.events.EventSerializer;
import org.apache.james.events.Group;
import org.apache.james.events.tables.CassandraEventDeadLettersTable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraEventDeadLettersDAO {
    private final CassandraAsyncExecutor executor;
    private final EventSerializer eventSerializer;
    private final PreparedStatement insertStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllEventsOfAGroupStatement;
    private final PreparedStatement selectEventStatement;
    private final PreparedStatement selectEventIdsWithGroupStatement;
    private final PreparedStatement containEventsStatement;

    @Inject
    CassandraEventDeadLettersDAO(CqlSession session, EventSerializer eventSerializer) {
        this.executor = new CassandraAsyncExecutor(session);
        this.eventSerializer = eventSerializer;
        this.insertStatement = this.prepareInsertStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
        this.deleteAllEventsOfAGroupStatement = this.prepareDeleteAllEventsOfAGroupStatement(session);
        this.selectEventStatement = this.prepareSelectEventStatement(session);
        this.selectEventIdsWithGroupStatement = this.prepareSelectInsertionIdsWithGroupStatement(session);
        this.containEventsStatement = this.prepareContainEventStatement(session);
    }

    private PreparedStatement prepareInsertStatement(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"event_dead_letters").value(CassandraEventDeadLettersTable.GROUP, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.GROUP)).value(CassandraEventDeadLettersTable.INSERTION_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.INSERTION_ID)).value(CassandraEventDeadLettersTable.EVENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.EVENT)).build());
    }

    private PreparedStatement prepareDeleteStatement(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"event_dead_letters").whereColumn(CassandraEventDeadLettersTable.GROUP).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.GROUP))).whereColumn(CassandraEventDeadLettersTable.INSERTION_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.INSERTION_ID))).build());
    }

    private PreparedStatement prepareDeleteAllEventsOfAGroupStatement(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"event_dead_letters").whereColumn(CassandraEventDeadLettersTable.GROUP).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.GROUP))).build());
    }

    private PreparedStatement prepareSelectEventStatement(CqlSession session) {
        return session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)"event_dead_letters").column(CassandraEventDeadLettersTable.EVENT).whereColumn(CassandraEventDeadLettersTable.GROUP).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.GROUP))).whereColumn(CassandraEventDeadLettersTable.INSERTION_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.INSERTION_ID))).build());
    }

    private PreparedStatement prepareSelectInsertionIdsWithGroupStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"event_dead_letters").column(CassandraEventDeadLettersTable.INSERTION_ID).whereColumn(CassandraEventDeadLettersTable.GROUP).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraEventDeadLettersTable.GROUP))).build());
    }

    private PreparedStatement prepareContainEventStatement(CqlSession session) {
        return session.prepare(QueryBuilder.selectFrom((String)"event_dead_letters").column(CassandraEventDeadLettersTable.EVENT).limit(1).build());
    }

    Mono<Void> store(Group group, Event failedEvent, EventDeadLetters.InsertionId insertionId) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertStatement.bind(new Object[0]).setString(CassandraEventDeadLettersTable.GROUP, group.asString())).setUuid(CassandraEventDeadLettersTable.INSERTION_ID, insertionId.getId())).setString(CassandraEventDeadLettersTable.EVENT, this.eventSerializer.toJson(failedEvent)));
    }

    Mono<Void> removeEvent(Group group, EventDeadLetters.InsertionId failedInsertionId) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setString(CassandraEventDeadLettersTable.GROUP, group.asString())).setUuid(CassandraEventDeadLettersTable.INSERTION_ID, failedInsertionId.getId()));
    }

    Mono<Void> removeEvents(Group group) {
        return this.executor.executeVoid((Statement)this.deleteAllEventsOfAGroupStatement.bind(new Object[0]).setString(CassandraEventDeadLettersTable.GROUP, group.asString()));
    }

    Mono<Event> retrieveFailedEvent(Group group, EventDeadLetters.InsertionId insertionId) {
        return this.executor.executeSingleRow((Statement)((BoundStatement)this.selectEventStatement.bind(new Object[0]).setString(CassandraEventDeadLettersTable.GROUP, group.asString())).setUuid(CassandraEventDeadLettersTable.INSERTION_ID, insertionId.getId())).map(row -> this.deserializeEvent(row.getString(CassandraEventDeadLettersTable.EVENT)));
    }

    Flux<EventDeadLetters.InsertionId> retrieveInsertionIdsWithGroup(Group group) {
        return this.executor.executeRows((Statement)this.selectEventIdsWithGroupStatement.bind(new Object[0]).setString(CassandraEventDeadLettersTable.GROUP, group.asString())).map(row -> EventDeadLetters.InsertionId.of((UUID)row.getUuid(CassandraEventDeadLettersTable.INSERTION_ID)));
    }

    Mono<Boolean> containEvents() {
        return this.executor.executeReturnExists((Statement)this.containEventsStatement.bind(new Object[0]));
    }

    private Event deserializeEvent(String serializedEvent) {
        return this.eventSerializer.asEvent(serializedEvent);
    }
}

