/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieverepository.file;

import com.google.common.collect.ImmutableList;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;

public class SieveFileRepository
implements SieveRepository {
    private static final String SIEVE_ROOT = "file://sieve/";
    private static final String UTF_8 = "UTF-8";
    private static final String FILE_NAME_QUOTA = ".quota";
    private static final String FILE_NAME_ACTIVE = ".active";
    private static final List<String> SYSTEM_FILES = Arrays.asList(".quota", ".active");
    private static final int MAX_BUFF_SIZE = 32768;
    public static final String SIEVE_EXTENSION = ".sieve";
    private final FileSystem fileSystem;
    private final File root;
    private final Object lock = new Object();

    protected static String toString(File file, String encoding) throws FileNotFoundException {
        String script = null;
        try (Scanner scanner = new Scanner(file, encoding);){
            scanner.useDelimiter("\\A");
            script = scanner.next();
        }
        return script;
    }

    protected static void toFile(File file, String content) throws StorageException {
        int bufferSize = Math.min(content.length(), 32768);
        File tmpFile = null;
        try {
            tmpFile = Files.createTempFile(file.getParentFile().toPath(), "", ".tmp", new FileAttribute[0]).toFile();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tmpFile), bufferSize), UTF_8);){
                out.write(content);
            }
        }
        catch (IOException ex) {
            FileUtils.deleteQuietly(tmpFile);
            throw new StorageException((Throwable)ex);
        }
        File backupFile = new File(file.getParentFile(), file.getName() + ".bak");
        if (file.exists()) {
            try {
                FileUtils.copyFile((File)file, (File)backupFile);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
        try {
            FileUtils.copyFile((File)tmpFile, (File)file);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
        if (tmpFile.exists()) {
            FileUtils.deleteQuietly((File)tmpFile);
        }
        if (backupFile.exists()) {
            FileUtils.deleteQuietly((File)backupFile);
        }
    }

    @Inject
    public SieveFileRepository(FileSystem fileSystem) throws IOException {
        this.fileSystem = fileSystem;
        this.root = fileSystem.getFile(SIEVE_ROOT);
        FileUtils.forceMkdir((File)this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteScript(Username username, ScriptName name) throws ScriptNotFoundException, IsActiveException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getScriptFile(username, name);
            if (this.isActiveFile(username, file)) {
                throw new IsActiveException("User: " + username.asString() + "Script: " + name);
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public InputStream getScript(Username username, ScriptName name) throws ScriptNotFoundException, StorageException {
        FileInputStream script;
        try {
            script = new FileInputStream(this.getScriptFile(username, name));
        }
        catch (FileNotFoundException ex) {
            throw new ScriptNotFoundException((Throwable)ex);
        }
        return script;
    }

    public void haveSpace(Username username, ScriptName name, long size) throws QuotaExceededException, StorageException {
        long usedSpace = Arrays.stream(this.getUserDirectory(username).listFiles()).filter(file -> !file.getName().equals(name.getValue()) && !SYSTEM_FILES.contains(file.getName())).mapToLong(File::length).sum();
        long quota = Long.MAX_VALUE;
        File file2 = this.getQuotaFile(username);
        if (!file2.exists()) {
            file2 = this.getQuotaFile();
        }
        if (file2.exists()) {
            try (Scanner scanner = new Scanner(file2, UTF_8);){
                quota = scanner.nextLong();
            }
            catch (FileNotFoundException | NoSuchElementException exception) {
                // empty catch block
            }
        }
        if (usedSpace + size > quota) {
            throw new QuotaExceededException(" Quota: " + quota + " Used: " + usedSpace + " Requested: " + size);
        }
    }

    public List<ScriptSummary> listScripts(Username username) throws StorageException {
        File activeFile = null;
        try {
            activeFile = this.getActiveFile(username);
        }
        catch (ScriptNotFoundException scriptNotFoundException) {
            // empty catch block
        }
        Predicate<File> isActive = this.isActiveValidator(activeFile);
        return (List)Stream.of(Optional.ofNullable(this.getUserDirectory(username).listFiles()).orElse(new File[0])).filter(file -> !SYSTEM_FILES.contains(file.getName())).map(file -> new ScriptSummary(new ScriptName(file.getName()), isActive.test((File)file))).collect(ImmutableList.toImmutableList());
    }

    private Predicate<File> isActiveValidator(File activeFile) {
        if (activeFile != null) {
            return activeFile::equals;
        }
        return file -> false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putScript(Username username, ScriptName name, ScriptContent content) throws StorageException, QuotaExceededException {
        Object object = this.lock;
        synchronized (object) {
            File file = new File(this.getUserDirectory(username), name.getValue());
            this.enforceRoot(file);
            this.haveSpace(username, name, content.length());
            SieveFileRepository.toFile(file, content.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameScript(Username username, ScriptName oldName, ScriptName newName) throws ScriptNotFoundException, DuplicateException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File oldFile = this.getScriptFile(username, oldName);
            File newFile = new File(this.getUserDirectory(username), newName.getValue());
            this.enforceRoot(newFile);
            if (newFile.exists()) {
                throw new DuplicateException("User: " + username.asString() + "Script: " + newName);
            }
            try {
                FileUtils.copyFile((File)oldFile, (File)newFile);
                if (this.isActiveFile(username, oldFile)) {
                    this.setActiveFile(newFile, username, true);
                }
                FileUtils.forceDelete((File)oldFile);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    public InputStream getActive(Username username) throws ScriptNotFoundException, StorageException {
        FileInputStream script;
        try {
            script = new FileInputStream(this.getActiveFile(username));
        }
        catch (FileNotFoundException ex) {
            throw new ScriptNotFoundException((Throwable)ex);
        }
        return script;
    }

    public ZonedDateTime getActivationDateForActiveScript(Username username) throws StorageException, ScriptNotFoundException {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getActiveFile(username).lastModified()), ZoneOffset.UTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(Username username, ScriptName scriptName) throws ScriptNotFoundException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File oldActive = null;
            try {
                oldActive = this.getActiveFile(username);
                this.setActiveFile(oldActive, username, false);
            }
            catch (ScriptNotFoundException scriptNotFoundException) {
                // empty catch block
            }
            String name = scriptName.getValue();
            if (null != name && !name.trim().isEmpty()) {
                try {
                    this.setActiveFile(this.getScriptFile(username, new ScriptName(name)), username, true);
                }
                catch (ScriptNotFoundException ex) {
                    if (null != oldActive) {
                        this.setActiveFile(oldActive, username, true);
                    }
                    throw ex;
                }
            }
        }
    }

    protected File getSieveRootDirectory() throws StorageException {
        try {
            return this.fileSystem.getFile(SIEVE_ROOT);
        }
        catch (FileNotFoundException ex1) {
            throw new StorageException((Throwable)ex1);
        }
    }

    protected File getUserDirectory(Username username) throws StorageException {
        File file = this.getUserDirectoryFile(username);
        if (!file.exists()) {
            this.ensureUser(username);
        }
        return file;
    }

    private void enforceRoot(File file) throws StorageException {
        if (!file.toPath().normalize().startsWith(this.root.toPath().normalize())) {
            throw new StorageException((Throwable)new IllegalStateException("Path traversal attempted"));
        }
    }

    protected File getUserDirectoryFile(Username username) throws StorageException {
        File userFile = new File(this.getSieveRootDirectory(), username.asString() + "/");
        this.enforceRoot(userFile);
        return userFile;
    }

    protected File getActiveFile(Username username) throws ScriptNotFoundException, StorageException {
        String content;
        File dir = this.getUserDirectory(username);
        try {
            content = SieveFileRepository.toString(new File(dir, FILE_NAME_ACTIVE), UTF_8);
        }
        catch (FileNotFoundException ex) {
            throw new ScriptNotFoundException("There is no active script for user " + username.asString());
        }
        File scriptFile = new File(dir, content);
        this.enforceRoot(scriptFile);
        return scriptFile;
    }

    protected boolean isActiveFile(Username username, File file) throws StorageException {
        try {
            return 0 == this.getActiveFile(username).compareTo(file);
        }
        catch (ScriptNotFoundException ex) {
            return false;
        }
    }

    protected void setActiveFile(File scriptToBeActivated, Username userName, boolean isActive) throws StorageException {
        File personalScriptDirectory = scriptToBeActivated.getParentFile();
        File sieveBaseDirectory = personalScriptDirectory.getParentFile();
        File activeScriptPersistenceFile = new File(personalScriptDirectory, FILE_NAME_ACTIVE);
        File activeScriptCopy = new File(sieveBaseDirectory, userName.asString() + SIEVE_EXTENSION);
        this.enforceRoot(activeScriptPersistenceFile);
        this.enforceRoot(activeScriptCopy);
        if (isActive) {
            SieveFileRepository.toFile(activeScriptPersistenceFile, scriptToBeActivated.getName());
            try {
                FileUtils.copyFile((File)scriptToBeActivated, (File)activeScriptCopy);
            }
            catch (IOException exception) {
                throw new StorageException("Can not copy active script to make it accessible for sieve utils", (Throwable)exception);
            }
        }
        try {
            FileUtils.forceDelete((File)activeScriptPersistenceFile);
            FileUtils.forceDelete((File)activeScriptCopy);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    protected File getScriptFile(Username username, ScriptName name) throws ScriptNotFoundException, StorageException {
        if (name.getValue().contains("/")) {
            throw new StorageException((Throwable)new IllegalArgumentException("Script name should not contain '/' as it can allow path traversal"));
        }
        File file = new File(this.getUserDirectory(username), name.getValue());
        this.enforceRoot(file);
        if (!file.exists()) {
            throw new ScriptNotFoundException("User: " + username + "Script: " + name);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureUser(Username username) throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            try {
                FileUtils.forceMkdir((File)this.getUserDirectoryFile(username));
            }
            catch (IOException e) {
                throw new StorageException("Error while creating directory for " + username.asString(), (Throwable)e);
            }
        }
    }

    protected File getQuotaFile() throws StorageException {
        return new File(this.getSieveRootDirectory(), FILE_NAME_QUOTA);
    }

    public boolean hasDefaultQuota() throws StorageException {
        return this.getQuotaFile().exists();
    }

    public QuotaSizeLimit getDefaultQuota() throws QuotaNotFoundException, StorageException {
        Long quota = null;
        File file = this.getQuotaFile();
        if (file.exists()) {
            try (Scanner scanner = new Scanner(file, UTF_8);){
                quota = scanner.nextLong();
            }
            catch (FileNotFoundException | NoSuchElementException exception) {
                // empty catch block
            }
        }
        if (null == quota) {
            throw new QuotaNotFoundException("No default quota");
        }
        return QuotaSizeLimit.size((long)quota);
    }

    public synchronized void removeQuota() throws QuotaNotFoundException, StorageException {
        File file = this.getQuotaFile();
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    public synchronized void setDefaultQuota(QuotaSizeLimit quota) throws StorageException {
        File file = this.getQuotaFile();
        String content = Long.toString(quota.asLong());
        SieveFileRepository.toFile(file, content);
    }

    protected File getQuotaFile(Username username) throws StorageException {
        return new File(this.getUserDirectory(username), FILE_NAME_QUOTA);
    }

    public boolean hasQuota(Username username) throws StorageException {
        return this.getQuotaFile(username).exists();
    }

    public QuotaSizeLimit getQuota(Username username) throws QuotaNotFoundException, StorageException {
        Long quota = null;
        File file = this.getQuotaFile(username);
        if (file.exists()) {
            try (Scanner scanner = new Scanner(file, UTF_8);){
                quota = scanner.nextLong();
            }
            catch (FileNotFoundException | NoSuchElementException exception) {
                // empty catch block
            }
        }
        if (null == quota) {
            throw new QuotaNotFoundException("No quota for user: " + username.asString());
        }
        return QuotaSizeLimit.size((long)quota);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuota(Username username) throws QuotaNotFoundException, StorageException {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getQuotaFile(username);
            if (!file.exists()) {
                return;
            }
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQuota(Username username, QuotaSizeLimit quota) throws StorageException {
        Object object = this.lock;
        synchronized (object) {
            File file = this.getQuotaFile(username);
            String content = Long.toString(quota.asLong());
            SieveFileRepository.toFile(file, content);
        }
    }
}

