/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

class PostgresqlTimeFormatter {
    static final LocalTime MAX_TIME = LocalTime.MAX.minus(Duration.ofNanos(500L));
    static final Duration ONE_MICROSECOND = Duration.ofNanos(1000L);
    static final char[][] NUMBERS;
    static final char[] ZEROS;
    private static final DateTimeFormatter FULL_OFFSET;

    PostgresqlTimeFormatter() {
    }

    static OffsetTime parseOffsetTime(String offsetTime) {
        if (offsetTime.startsWith("24:00:00")) {
            return OffsetTime.MAX;
        }
        return FULL_OFFSET.parse((CharSequence)offsetTime, OffsetTime::from);
    }

    static String toString(OffsetTime offsetTime) {
        StringBuilder sbuf = new StringBuilder(8);
        LocalTime localTime = offsetTime.toLocalTime();
        if (localTime.isAfter(MAX_TIME)) {
            sbuf.append("24:00:00");
            PostgresqlTimeFormatter.appendTimeZone(sbuf, offsetTime.getOffset());
            return sbuf.toString();
        }
        int nano = offsetTime.getNano();
        if (PostgresqlTimeFormatter.nanosExceed499(nano)) {
            offsetTime = offsetTime.plus(ONE_MICROSECOND);
        }
        PostgresqlTimeFormatter.appendTime(sbuf, localTime);
        PostgresqlTimeFormatter.appendTimeZone(sbuf, offsetTime.getOffset());
        return sbuf.toString();
    }

    static LocalTime parseLocalTime(String localTime) {
        if (localTime.equals("24:00:00")) {
            return LocalTime.MAX;
        }
        return LocalTime.parse(localTime);
    }

    static String toString(LocalTime localTime) {
        StringBuilder sbuf = new StringBuilder(8);
        if (localTime.isAfter(MAX_TIME)) {
            return "24:00:00";
        }
        int nano = localTime.getNano();
        if (PostgresqlTimeFormatter.nanosExceed499(nano)) {
            localTime = localTime.plus(ONE_MICROSECOND);
        }
        PostgresqlTimeFormatter.appendTime(sbuf, localTime);
        return sbuf.toString();
    }

    static boolean nanosExceed499(int nanos) {
        return nanos % 1000 > 499;
    }

    static void appendTime(StringBuilder sb, LocalTime localTime) {
        PostgresqlTimeFormatter.appendTime(sb, localTime.getHour(), localTime.getMinute(), localTime.getSecond(), localTime.getNano());
    }

    static void appendTimeZone(StringBuilder sb, ZoneOffset offset) {
        PostgresqlTimeFormatter.appendTimeZone(sb, offset.getTotalSeconds());
    }

    private static void appendTimeZone(StringBuilder sb, int offset) {
        int absoff = Math.abs(offset);
        int hours = absoff / 60 / 60;
        int mins = (absoff - hours * 60 * 60) / 60;
        int secs = absoff - hours * 60 * 60 - mins * 60;
        sb.append(offset >= 0 ? "+" : "-");
        sb.append(NUMBERS[hours]);
        if (mins == 0 && secs == 0) {
            return;
        }
        sb.append(':');
        sb.append(NUMBERS[mins]);
        if (secs != 0) {
            sb.append(':');
            sb.append(NUMBERS[secs]);
        }
    }

    private static void appendTime(StringBuilder sb, int hours, int minutes, int seconds, int nanos) {
        sb.append(NUMBERS[hours]);
        sb.append(':');
        sb.append(NUMBERS[minutes]);
        sb.append(':');
        sb.append(NUMBERS[seconds]);
        if (nanos < 1000) {
            return;
        }
        sb.append('.');
        int len = sb.length();
        sb.append(nanos / 1000);
        int needZeros = 6 - (sb.length() - len);
        if (needZeros > 0) {
            sb.insert(len, ZEROS, 0, needZeros);
        }
        int end = sb.length() - 1;
        while (sb.charAt(end) == '0') {
            sb.deleteCharAt(end);
            --end;
        }
    }

    static {
        ZEROS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
        NUMBERS = new char[64][];
        for (int i = 0; i < NUMBERS.length; ++i) {
            PostgresqlTimeFormatter.NUMBERS[i] = ((i < 10 ? "0" : "") + i).toCharArray();
        }
        FULL_OFFSET = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendOffset("+HH:MM:ss", "+00:00").optionalEnd().optionalStart().appendOffset("+HH:mm", "+00:00").optionalEnd().optionalStart().appendOffset("+HH", "+00").optionalEnd().toFormatter();
    }
}

