/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPReferralException
extends com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPException {
    private static final long serialVersionUID = 7867903105944011998L;
    @NotNull
    private final String[] referralURLs;

    public LDAPReferralException() {
        super(null, 10);
        this.referralURLs = new String[0];
    }

    public LDAPReferralException(@Nullable String message, int resultCode, @Nullable String serverErrorMessage) {
        super(message, resultCode, serverErrorMessage, null);
        this.referralURLs = new String[0];
    }

    public LDAPReferralException(@Nullable String message, int resultCode, @NotNull String[] referrals) {
        super(message, resultCode, null, null);
        this.referralURLs = referrals;
    }

    public LDAPReferralException(@NotNull LDAPException ldapException) {
        super(ldapException);
        this.referralURLs = ldapException.getReferralURLs();
    }

    public LDAPReferralException(@NotNull SearchResultReference reference) {
        super(null, 10);
        this.referralURLs = reference.getReferralURLs();
    }

    @NotNull
    public String[] getURLs() {
        return this.referralURLs;
    }
}

