/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueView;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;

public class BrowseStartUpdateTask
implements Task {
    public static final TaskType TYPE = TaskType.of((String)"browse-start-update");
    private final MailQueueName name;
    private final CassandraMailQueueView.Factory cassandraMailQueueView;

    public BrowseStartUpdateTask(MailQueueName name, CassandraMailQueueView.Factory cassandraMailQueueView) {
        this.name = name;
        this.cassandraMailQueueView = cassandraMailQueueView;
    }

    public Task.Result run() {
        try {
            CassandraMailQueueView mailQueueView = (CassandraMailQueueView)this.cassandraMailQueueView.create(this.name);
            mailQueueView.updateBrowseStart().block();
            return Task.Result.COMPLETED;
        }
        catch (Exception e) {
            LOGGER.error("Error when republishing mails", (Throwable)e);
            return Task.Result.PARTIAL;
        }
    }

    public TaskType type() {
        return TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(new AdditionalInformation(this.name, Clock.systemUTC().instant()));
    }

    public MailQueueName getMailQueue() {
        return this.name;
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant timestamp;
        private final MailQueueName mailQueue;

        public AdditionalInformation(MailQueueName mailQueue, Instant timestamp) {
            this.mailQueue = mailQueue;
            this.timestamp = timestamp;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public MailQueueName getMailQueue() {
            return this.mailQueue;
        }
    }
}

