/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import jakarta.mail.Flags;
import java.io.IOException;
import java.io.InputStream;
import java.time.Clock;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.MailboxDeleteDuringUpdateException;
import org.apache.james.mailbox.postgres.mail.PostgresAttachmentMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMessageRetriever;
import org.apache.james.mailbox.postgres.mail.PostgresModSeqProvider;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMessageDAO;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMessageIdMapper
implements MessageIdMapper {
    private static final Function<MailboxMessage, ByteSource> MESSAGE_BODY_CONTENT_LOADER = mailboxMessage -> new ByteSource((MailboxMessage)mailboxMessage){
        final /* synthetic */ MailboxMessage val$mailboxMessage;
        {
            this.val$mailboxMessage = mailboxMessage;
        }

        public InputStream openStream() {
            try {
                return this.val$mailboxMessage.getBodyContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public long size() {
            return this.val$mailboxMessage.getBodyOctets();
        }
    };
    public static final int NUM_RETRIES = 5;
    public static final Logger LOGGER = LoggerFactory.getLogger(PostgresMessageIdMapper.class);
    private final PostgresMailboxDAO mailboxDAO;
    private final PostgresMessageDAO messageDAO;
    private final PostgresMailboxMessageDAO mailboxMessageDAO;
    private final PostgresModSeqProvider modSeqProvider;
    private final BlobStore blobStore;
    private final Clock clock;
    private final PostgresMessageRetriever messageRetriever;

    public PostgresMessageIdMapper(PostgresMailboxDAO mailboxDAO, PostgresMessageDAO messageDAO, PostgresMailboxMessageDAO mailboxMessageDAO, PostgresModSeqProvider modSeqProvider, PostgresAttachmentMapper attachmentMapper, BlobStore blobStore, BlobId.Factory blobIdFactory, Clock clock) {
        this.mailboxDAO = mailboxDAO;
        this.messageDAO = messageDAO;
        this.mailboxMessageDAO = mailboxMessageDAO;
        this.modSeqProvider = modSeqProvider;
        this.blobStore = blobStore;
        this.clock = clock;
        this.messageRetriever = new PostgresMessageRetriever(blobStore, blobIdFactory, attachmentMapper);
    }

    public List<MailboxMessage> find(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return (List)this.findReactive(messageIds, fetchType).collectList().block();
    }

    public Publisher<ComposedMessageIdWithMetaData> findMetadata(MessageId messageId) {
        return this.mailboxMessageDAO.findMetadataByMessageId((PostgresMessageId)PostgresMessageId.class.cast(messageId));
    }

    public Flux<MailboxMessage> findReactive(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        Flux<Pair<SimpleMailboxMessage.Builder, Record>> fetchMessagePublisher = this.mailboxMessageDAO.findMessagesByMessageIds((Collection)messageIds.stream().map(PostgresMessageId.class::cast).collect(ImmutableList.toImmutableList()), fetchType);
        return this.messageRetriever.get(fetchType, fetchMessagePublisher);
    }

    public List<MailboxId> findMailboxes(MessageId messageId) {
        return (List)this.mailboxMessageDAO.findMailboxes((PostgresMessageId)PostgresMessageId.class.cast(messageId)).collect(ImmutableList.toImmutableList()).block();
    }

    public void save(MailboxMessage mailboxMessage) throws MailboxException {
        PostgresMailboxId mailboxId = (PostgresMailboxId)PostgresMailboxId.class.cast(mailboxMessage.getMailboxId());
        mailboxMessage.setSaveDate(Date.from(this.clock.instant()));
        MailboxReactorUtils.block((Mono)this.mailboxDAO.findMailboxById(mailboxId).switchIfEmpty(Mono.error(() -> new MailboxNotFoundException((MailboxId)mailboxId))).then(this.saveBodyContent(mailboxMessage)).flatMap(blobId -> this.messageDAO.insert(mailboxMessage, blobId.asString()).onErrorResume(PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE, e -> Mono.empty())).then(this.mailboxMessageDAO.insert(mailboxMessage)));
    }

    public void copyInMailbox(MailboxMessage mailboxMessage, Mailbox mailbox) throws MailboxException {
        MailboxReactorUtils.block(this.copyInMailboxReactive(mailboxMessage, mailbox));
    }

    public Mono<Void> copyInMailboxReactive(MailboxMessage mailboxMessage, Mailbox mailbox) {
        mailboxMessage.setSaveDate(Date.from(this.clock.instant()));
        PostgresMailboxId mailboxId = (PostgresMailboxId)mailbox.getMailboxId();
        return this.mailboxMessageDAO.insert(mailboxMessage, mailboxId).onErrorResume(PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE, e -> Mono.empty());
    }

    public void delete(MessageId messageId) {
        this.mailboxMessageDAO.deleteByMessageId((PostgresMessageId)messageId).block();
    }

    public void delete(MessageId messageId, Collection<MailboxId> mailboxIds) {
        this.mailboxMessageDAO.deleteByMessageIdAndMailboxIds((PostgresMessageId)messageId, (Collection)mailboxIds.stream().map(PostgresMailboxId.class::cast).collect(ImmutableList.toImmutableList())).block();
    }

    public Mono<Multimap<MailboxId, UpdatedFlags>> setFlags(MessageId messageId, List<MailboxId> mailboxIds, Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        return Flux.fromIterable(mailboxIds).distinct().map(PostgresMailboxId.class::cast).concatMap(mailboxId -> this.flagsUpdateWithRetry(newState, updateMode, (MailboxId)mailboxId, messageId)).collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getLeft, Pair::getRight));
    }

    private Flux<Pair<MailboxId, UpdatedFlags>> flagsUpdateWithRetry(Flags newState, MessageManager.FlagsUpdateMode updateMode, MailboxId mailboxId, MessageId messageId) {
        return this.updateFlags(mailboxId, messageId, newState, updateMode).retry(5L).onErrorResume(MailboxDeleteDuringUpdateException.class, e -> {
            LOGGER.info("Mailbox {} was deleted during flag update", (Object)mailboxId);
            return Mono.empty();
        }).flatMapIterable(Function.identity()).map(pair -> this.buildUpdatedFlags((ComposedMessageIdWithMetaData)pair.getRight(), (Flags)pair.getLeft()));
    }

    private Pair<MailboxId, UpdatedFlags> buildUpdatedFlags(ComposedMessageIdWithMetaData composedMessageIdWithMetaData, Flags oldFlags) {
        return Pair.of((Object)composedMessageIdWithMetaData.getComposedMessageId().getMailboxId(), (Object)UpdatedFlags.builder().uid(composedMessageIdWithMetaData.getComposedMessageId().getUid()).messageId(composedMessageIdWithMetaData.getComposedMessageId().getMessageId()).modSeq(composedMessageIdWithMetaData.getModSeq()).oldFlags(oldFlags).newFlags(composedMessageIdWithMetaData.getFlags()).build());
    }

    private Mono<List<Pair<Flags, ComposedMessageIdWithMetaData>>> updateFlags(MailboxId mailboxId, MessageId messageId, Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        PostgresMailboxId postgresMailboxId = (PostgresMailboxId)mailboxId;
        PostgresMessageId postgresMessageId = (PostgresMessageId)messageId;
        return this.mailboxMessageDAO.findMetadataByMessageId(postgresMessageId, postgresMailboxId).flatMap(oldComposedId -> this.updateFlags(newState, updateMode, postgresMailboxId, (ComposedMessageIdWithMetaData)oldComposedId), 16).switchIfEmpty((Publisher)Mono.error(MailboxDeleteDuringUpdateException::new)).collectList();
    }

    private Mono<Pair<Flags, ComposedMessageIdWithMetaData>> updateFlags(Flags newState, MessageManager.FlagsUpdateMode updateMode, PostgresMailboxId mailboxId, ComposedMessageIdWithMetaData oldComposedId) {
        FlagsUpdateCalculator flagsUpdateCalculator = new FlagsUpdateCalculator(newState, updateMode);
        Flags newFlags = flagsUpdateCalculator.buildNewFlags(oldComposedId.getFlags());
        if (this.identicalFlags(oldComposedId, newFlags)) {
            return Mono.just((Object)Pair.of((Object)oldComposedId.getFlags(), (Object)oldComposedId));
        }
        return this.modSeqProvider.nextModSeqReactive(mailboxId).flatMap(newModSeq -> this.updateFlags(mailboxId, flagsUpdateCalculator, (ModSeq)newModSeq, oldComposedId.getComposedMessageId().getUid()).map(flags -> Pair.of((Object)oldComposedId.getFlags(), (Object)new ComposedMessageIdWithMetaData(oldComposedId.getComposedMessageId(), flags, newModSeq, oldComposedId.getThreadId()))));
    }

    private Mono<Flags> updateFlags(PostgresMailboxId mailboxId, FlagsUpdateCalculator flagsUpdateCalculator, ModSeq newModSeq, MessageUid uid) {
        switch (flagsUpdateCalculator.getMode()) {
            case ADD: {
                return this.mailboxMessageDAO.addFlags(mailboxId, uid, flagsUpdateCalculator.providedFlags(), newModSeq);
            }
            case REMOVE: {
                return this.mailboxMessageDAO.removeFlags(mailboxId, uid, flagsUpdateCalculator.providedFlags(), newModSeq);
            }
            case REPLACE: {
                return this.mailboxMessageDAO.replaceFlags(mailboxId, uid, flagsUpdateCalculator.providedFlags(), newModSeq);
            }
        }
        return Mono.error(() -> new RuntimeException("Unknown MessageRange type " + String.valueOf(flagsUpdateCalculator.getMode())));
    }

    private boolean identicalFlags(ComposedMessageIdWithMetaData oldComposedId, Flags newFlags) {
        return oldComposedId.getFlags().equals((Object)newFlags);
    }

    private Mono<BlobId> saveBodyContent(MailboxMessage message) {
        return Mono.fromCallable(() -> MESSAGE_BODY_CONTENT_LOADER.apply(message)).flatMap(bodyByteSource -> Mono.from((Publisher)this.blobStore.save(this.blobStore.getDefaultBucketName(), bodyByteSource, BlobStore.StoragePolicy.LOW_COST)));
    }
}

