/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.apache.james.mailbox.opensearch.MailboxMappingFactory;
import org.opensearch.client.opensearch._types.mapping.BooleanProperty;
import org.opensearch.client.opensearch._types.mapping.DateProperty;
import org.opensearch.client.opensearch._types.mapping.DynamicMapping;
import org.opensearch.client.opensearch._types.mapping.KeywordProperty;
import org.opensearch.client.opensearch._types.mapping.LongNumberProperty;
import org.opensearch.client.opensearch._types.mapping.NestedProperty;
import org.opensearch.client.opensearch._types.mapping.ObjectProperty;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.RoutingField;
import org.opensearch.client.opensearch._types.mapping.TextProperty;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.IndexSettings;

public class DefaultMailboxMappingFactory
implements MailboxMappingFactory {
    private static final String STANDARD = "standard";
    private static final String SIMPLE = "simple";

    @Override
    public TypeMapping getMappingContent() {
        return new TypeMapping.Builder().dynamic(DynamicMapping.Strict).routing(new RoutingField.Builder().required(true).build()).properties(DefaultMailboxMappingFactory.generateProperties()).build();
    }

    private static Map<String, Property> generateProperties() {
        return new ImmutableMap.Builder().put((Object)"messageId", (Object)((Property)new Property.Builder().keyword(((KeywordProperty.Builder)new KeywordProperty.Builder().store(Boolean.valueOf(true))).build()).build())).put((Object)"threadId", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build())).put((Object)"uid", (Object)((Property)new Property.Builder().long_(((LongNumberProperty.Builder)new LongNumberProperty.Builder().store(Boolean.valueOf(true))).build()).build())).put((Object)"modSeq", (Object)((Property)new Property.Builder().long_(new LongNumberProperty.Builder().build()).build())).put((Object)"size", (Object)((Property)new Property.Builder().long_(new LongNumberProperty.Builder().build()).build())).put((Object)"isAnswered", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"isDeleted", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"isDraft", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"isFlagged", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"isRecent", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"isUnread", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"date", (Object)((Property)new Property.Builder().date(new DateProperty.Builder().format("uuuu-MM-dd'T'HH:mm:ssX||uuuu-MM-dd'T'HH:mm:ssXXX||uuuu-MM-dd'T'HH:mm:ssXXXXX").build()).build())).put((Object)"sentDate", (Object)((Property)new Property.Builder().date(new DateProperty.Builder().format("uuuu-MM-dd'T'HH:mm:ssX||uuuu-MM-dd'T'HH:mm:ssXXX||uuuu-MM-dd'T'HH:mm:ssXXXXX").build()).build())).put((Object)"saveDate", (Object)((Property)new Property.Builder().date(new DateProperty.Builder().format("uuuu-MM-dd'T'HH:mm:ssX||uuuu-MM-dd'T'HH:mm:ssXXX||uuuu-MM-dd'T'HH:mm:ssXXXXX").build()).build())).put((Object)"userFlags", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).put((Object)"mediaType", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build())).put((Object)"subtype", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build())).put((Object)"from", (Object)((Property)new Property.Builder().object(((ObjectProperty.Builder)new ObjectProperty.Builder().properties((Map)ImmutableMap.of((Object)"name", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build()), (Object)"domain", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(SIMPLE).searchAnalyzer("keyword").build()).build()), (Object)"address", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer(STANDARD).searchAnalyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build())))).build()).build())).put((Object)"headers", (Object)((Property)new Property.Builder().nested(((NestedProperty.Builder)new NestedProperty.Builder().properties((Map)ImmutableMap.of((Object)"name", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()), (Object)"value", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer("keep_mail_and_url").build()).build())))).build()).build())).put((Object)"subject", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build())).put((Object)"to", (Object)((Property)new Property.Builder().object(((ObjectProperty.Builder)new ObjectProperty.Builder().properties((Map)ImmutableMap.of((Object)"name", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build()), (Object)"domain", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(SIMPLE).searchAnalyzer("keyword").build()).build()), (Object)"address", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer(STANDARD).searchAnalyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build())))).build()).build())).put((Object)"cc", (Object)((Property)new Property.Builder().object(((ObjectProperty.Builder)new ObjectProperty.Builder().properties((Map)ImmutableMap.of((Object)"name", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build()), (Object)"domain", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(SIMPLE).searchAnalyzer("keyword").build()).build()), (Object)"address", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer(STANDARD).searchAnalyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build())))).build()).build())).put((Object)"bcc", (Object)((Property)new Property.Builder().object(((ObjectProperty.Builder)new ObjectProperty.Builder().properties((Map)ImmutableMap.of((Object)"name", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer("keep_mail_and_url").build()).build()), (Object)"domain", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(SIMPLE).searchAnalyzer("keyword").build()).build()), (Object)"address", (Object)((Property)new Property.Builder().text(((TextProperty.Builder)new TextProperty.Builder().analyzer(STANDARD).searchAnalyzer("keep_mail_and_url").fields("raw", (Property)new Property.Builder().keyword(new KeywordProperty.Builder().normalizer("case_insensitive").build()).build())).build()).build())))).build()).build())).put((Object)"mailboxId", (Object)((Property)new Property.Builder().keyword(((KeywordProperty.Builder)new KeywordProperty.Builder().store(Boolean.valueOf(true))).build()).build())).put((Object)"mimeMessageID", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build())).put((Object)"user", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build())).put((Object)"textBody", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(STANDARD).build()).build())).put((Object)"htmlBody", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(STANDARD).build()).build())).put((Object)"hasAttachment", (Object)((Property)new Property.Builder().boolean_(new BooleanProperty.Builder().build()).build())).put((Object)"attachments", (Object)((Property)new Property.Builder().object(((ObjectProperty.Builder)new ObjectProperty.Builder().properties((Map)ImmutableMap.of((Object)"fileName", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(STANDARD).build()).build()), (Object)"textContent", (Object)((Property)new Property.Builder().text(new TextProperty.Builder().analyzer(STANDARD).build()).build()), (Object)"mediaType", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()), (Object)"subtype", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()), (Object)"fileExtension", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build()), (Object)"contentDisposition", (Object)((Property)new Property.Builder().keyword(new KeywordProperty.Builder().build()).build())))).build()).build())).build();
    }

    @Override
    public Optional<IndexSettings> getIndexSettings() {
        return Optional.empty();
    }
}

