/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public final class MediaTypeRange
implements Comparable<MediaTypeRange> {
    private static final MediaTypeRange[] DEFAULT = new MediaTypeRange[]{new MediaTypeRange("*/*")};
    private static final boolean NOCACHE = Boolean.getBoolean("juneau.nocache");
    private static final ConcurrentHashMap<String, MediaTypeRange[]> CACHE = new ConcurrentHashMap();
    private final MediaType mediaType;
    private final Float qValue;
    private final Map<String, Set<String>> extensions;

    public static MediaTypeRange[] parse(String value) {
        if (value == null || value.length() == 0) {
            return DEFAULT;
        }
        MediaTypeRange[] mtr = CACHE.get(value);
        if (mtr != null) {
            return mtr;
        }
        if (value.indexOf(44) == -1) {
            mtr = new MediaTypeRange[]{new MediaTypeRange(value)};
        } else {
            TreeSet<MediaTypeRange> ranges = new TreeSet<MediaTypeRange>();
            for (String r : StringUtils.split(value)) {
                if ((r = r.trim()).isEmpty()) continue;
                ranges.add(new MediaTypeRange(r));
            }
            mtr = ranges.toArray(new MediaTypeRange[ranges.size()]);
        }
        if (NOCACHE) {
            return mtr;
        }
        CACHE.putIfAbsent(value, mtr);
        return CACHE.get(value);
    }

    private MediaTypeRange(String token) {
        Builder b = new Builder(token);
        this.mediaType = b.mediaType;
        this.qValue = b.qValue;
        this.extensions = CollectionUtils.unmodifiableMap(b.extensions);
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public Float getQValue() {
        return this.qValue;
    }

    public Map<String, Set<String>> getExtensions() {
        return this.extensions;
    }

    public String toString() {
        StringBuffer sb;
        block5: {
            block4: {
                sb = new StringBuffer().append(this.mediaType);
                if ((double)this.qValue.floatValue() != 1.0) break block4;
                if (this.extensions.isEmpty()) break block5;
                sb.append(";q=").append(this.qValue);
                for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                    String k = e.getKey();
                    for (String v : e.getValue()) {
                        sb.append(';').append(k).append('=').append(v);
                    }
                }
                break block5;
            }
            sb.append(";q=").append(this.qValue);
            for (Map.Entry<String, Set<String>> e : this.extensions.entrySet()) {
                String k = e.getKey();
                for (String v : e.getValue()) {
                    sb.append(';').append(k).append('=').append(v);
                }
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MediaTypeRange)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        MediaTypeRange o2 = (MediaTypeRange)o;
        return this.qValue.equals(o2.qValue) && this.mediaType.equals(o2.mediaType) && this.extensions.equals(o2.extensions);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }

    @Override
    public int compareTo(MediaTypeRange o) {
        int qCompare = Float.compare(o.qValue.floatValue(), this.qValue.floatValue());
        if (qCompare != 0) {
            return qCompare;
        }
        int i = o.mediaType.toString().compareTo(this.mediaType.toString());
        return i;
    }

    static final class Builder {
        MediaType mediaType;
        Float qValue = Float.valueOf(1.0f);
        Map<String, Set<String>> extensions;

        Builder(String token) {
            token = token.trim();
            int i = token.indexOf(";q=");
            if (i == -1) {
                this.mediaType = MediaType.forString(token);
                return;
            }
            this.mediaType = MediaType.forString(token.substring(0, i));
            String[] tokens = token.substring(i + 1).split(";");
            if (tokens.length > 0) {
                boolean isInExtensions = false;
                for (int j = 0; j < tokens.length; ++j) {
                    String[] parm = tokens[j].split("=");
                    if (parm.length != 2) continue;
                    String k = parm[0];
                    String v = parm[1];
                    if (isInExtensions) {
                        if (this.extensions == null) {
                            this.extensions = new TreeMap<String, Set<String>>();
                        }
                        if (!this.extensions.containsKey(k)) {
                            this.extensions.put(k, new TreeSet());
                        }
                        this.extensions.get(k).add(v);
                        continue;
                    }
                    if (!k.equals("q")) continue;
                    this.qValue = new Float(v);
                    isInExtensions = true;
                }
            }
        }
    }
}

