/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.TwoKeyConcurrentCache;

public interface AnnotationProvider {
    public static final boolean DISABLE_ANNOTATION_CACHING = Boolean.getBoolean("juneau.disableAnnotationCaching");
    public static final AnnotationProvider DEFAULT = new AnnotationProvider(){
        private final TwoKeyConcurrentCache<Class<?>, Class<? extends Annotation>, Annotation[]> classAnnotationCache = new TwoKeyConcurrentCache<Class, Class, Annotation[]>(DISABLE_ANNOTATION_CACHING, (k1, k2) -> k1.getAnnotationsByType(k2));
        private final TwoKeyConcurrentCache<Class<?>, Class<? extends Annotation>, Annotation[]> declaredClassAnnotationCache = new TwoKeyConcurrentCache<Class, Class, Annotation[]>(DISABLE_ANNOTATION_CACHING, (k1, k2) -> k1.getDeclaredAnnotationsByType(k2));
        private final TwoKeyConcurrentCache<Method, Class<? extends Annotation>, Annotation[]> methodAnnotationCache = new TwoKeyConcurrentCache<Method, Class, Annotation[]>(DISABLE_ANNOTATION_CACHING, (k1, k2) -> k1.getAnnotationsByType(k2));
        private final TwoKeyConcurrentCache<Field, Class<? extends Annotation>, Annotation[]> fieldAnnotationCache = new TwoKeyConcurrentCache<Field, Class, Annotation[]>(DISABLE_ANNOTATION_CACHING, (k1, k2) -> k1.getAnnotationsByType(k2));
        private final TwoKeyConcurrentCache<Constructor<?>, Class<? extends Annotation>, Annotation[]> constructorAnnotationCache = new TwoKeyConcurrentCache<Constructor, Class, Annotation[]>(DISABLE_ANNOTATION_CACHING, (k1, k2) -> k1.getAnnotationsByType(k2));

        @Override
        public <A extends Annotation> void forEachAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter, Consumer<A> action) {
            if (type != null && onClass != null) {
                for (Annotation a : this.annotations(type, onClass)) {
                    ConsumerUtils.consume(filter, action, a);
                }
            }
        }

        @Override
        public <A extends Annotation> A firstAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
            if (type != null && onClass != null) {
                for (Annotation a : this.annotations(type, onClass)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    return (A)a;
                }
            }
            return null;
        }

        @Override
        public <A extends Annotation> A lastAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
            Annotation x = null;
            if (type != null && onClass != null) {
                for (Annotation a : this.annotations(type, onClass)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    x = a;
                }
            }
            return (A)x;
        }

        @Override
        public <A extends Annotation> void forEachDeclaredAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter, Consumer<A> action) {
            if (type != null && onClass != null) {
                for (Annotation a : this.declaredAnnotations(type, onClass)) {
                    ConsumerUtils.consume(filter, action, a);
                }
            }
        }

        @Override
        public <A extends Annotation> A firstDeclaredAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
            if (type != null && onClass != null) {
                for (Annotation a : this.declaredAnnotations(type, onClass)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    return (A)a;
                }
            }
            return null;
        }

        @Override
        public <A extends Annotation> A lastDeclaredAnnotation(Class<A> type, Class<?> onClass, Predicate<A> filter) {
            Annotation x = null;
            if (type != null && onClass != null) {
                for (Annotation a : this.declaredAnnotations(type, onClass)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    x = a;
                }
            }
            return (A)x;
        }

        @Override
        public <A extends Annotation> void forEachAnnotation(Class<A> type, Method onMethod, Predicate<A> filter, Consumer<A> action) {
            if (type != null && onMethod != null) {
                for (Annotation a : this.annotations(type, onMethod)) {
                    ConsumerUtils.consume(filter, action, a);
                }
            }
        }

        @Override
        public <A extends Annotation> A firstAnnotation(Class<A> type, Method onMethod, Predicate<A> filter) {
            if (type != null && onMethod != null) {
                for (Annotation a : this.annotations(type, onMethod)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    return (A)a;
                }
            }
            return null;
        }

        @Override
        public <A extends Annotation> A lastAnnotation(Class<A> type, Method onMethod, Predicate<A> filter) {
            Annotation x = null;
            if (type != null && onMethod != null) {
                for (Annotation a : this.annotations(type, onMethod)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    x = a;
                }
            }
            return (A)x;
        }

        @Override
        public <A extends Annotation> void forEachAnnotation(Class<A> type, Field onField, Predicate<A> filter, Consumer<A> action) {
            if (type != null && onField != null) {
                for (Annotation a : this.annotations(type, onField)) {
                    ConsumerUtils.consume(filter, action, a);
                }
            }
        }

        @Override
        public <A extends Annotation> A firstAnnotation(Class<A> type, Field onField, Predicate<A> filter) {
            if (type != null && onField != null) {
                for (Annotation a : this.annotations(type, onField)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    return (A)a;
                }
            }
            return null;
        }

        @Override
        public <A extends Annotation> A lastAnnotation(Class<A> type, Field onField, Predicate<A> filter) {
            Annotation x = null;
            if (type != null && onField != null) {
                for (Annotation a : this.annotations(type, onField)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    x = a;
                }
            }
            return (A)x;
        }

        @Override
        public <A extends Annotation> void forEachAnnotation(Class<A> type, Constructor<?> onConstructor, Predicate<A> filter, Consumer<A> action) {
            if (type != null && onConstructor != null) {
                for (Annotation a : this.annotations(type, onConstructor)) {
                    ConsumerUtils.consume(filter, action, a);
                }
            }
        }

        @Override
        public <A extends Annotation> A firstAnnotation(Class<A> type, Constructor<?> onConstructor, Predicate<A> filter) {
            if (type != null && onConstructor != null) {
                for (Annotation a : this.annotations(type, onConstructor)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    return (A)a;
                }
            }
            return null;
        }

        @Override
        public <A extends Annotation> A lastAnnotation(Class<A> type, Constructor<?> onConstructor, Predicate<A> filter) {
            Annotation x = null;
            if (type != null && onConstructor != null) {
                for (Annotation a : this.annotations(type, onConstructor)) {
                    if (!ConsumerUtils.test(filter, a)) continue;
                    x = a;
                }
            }
            return (A)x;
        }

        private <A extends Annotation> A[] annotations(Class<A> type, Class<?> onClass) {
            return this.classAnnotationCache.get(onClass, type);
        }

        private <A extends Annotation> A[] declaredAnnotations(Class<A> type, Class<?> onClass) {
            return this.declaredClassAnnotationCache.get(onClass, type);
        }

        private <A extends Annotation> A[] annotations(Class<A> type, Method onMethod) {
            return this.methodAnnotationCache.get(onMethod, type);
        }

        private <A extends Annotation> A[] annotations(Class<A> type, Field onField) {
            return this.fieldAnnotationCache.get(onField, type);
        }

        private <A extends Annotation> A[] annotations(Class<A> type, Constructor<?> onConstructor) {
            return this.constructorAnnotationCache.get(onConstructor, type);
        }
    };

    public <A extends Annotation> void forEachAnnotation(Class<A> var1, Class<?> var2, Predicate<A> var3, Consumer<A> var4);

    public <A extends Annotation> A firstAnnotation(Class<A> var1, Class<?> var2, Predicate<A> var3);

    public <A extends Annotation> A lastAnnotation(Class<A> var1, Class<?> var2, Predicate<A> var3);

    public <A extends Annotation> void forEachDeclaredAnnotation(Class<A> var1, Class<?> var2, Predicate<A> var3, Consumer<A> var4);

    public <A extends Annotation> A firstDeclaredAnnotation(Class<A> var1, Class<?> var2, Predicate<A> var3);

    public <A extends Annotation> A lastDeclaredAnnotation(Class<A> var1, Class<?> var2, Predicate<A> var3);

    public <A extends Annotation> void forEachAnnotation(Class<A> var1, Method var2, Predicate<A> var3, Consumer<A> var4);

    public <A extends Annotation> A firstAnnotation(Class<A> var1, Method var2, Predicate<A> var3);

    public <A extends Annotation> A lastAnnotation(Class<A> var1, Method var2, Predicate<A> var3);

    public <A extends Annotation> void forEachAnnotation(Class<A> var1, Field var2, Predicate<A> var3, Consumer<A> var4);

    public <A extends Annotation> A firstAnnotation(Class<A> var1, Field var2, Predicate<A> var3);

    public <A extends Annotation> A lastAnnotation(Class<A> var1, Field var2, Predicate<A> var3);

    public <A extends Annotation> void forEachAnnotation(Class<A> var1, Constructor<?> var2, Predicate<A> var3, Consumer<A> var4);

    public <A extends Annotation> A firstAnnotation(Class<A> var1, Constructor<?> var2, Predicate<A> var3);

    public <A extends Annotation> A lastAnnotation(Class<A> var1, Constructor<?> var2, Predicate<A> var3);
}

