/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

@Header
@Schema(type="boolean")
public class BasicBooleanHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Boolean value;
    private final Supplier<Boolean> supplier;

    public static BasicBooleanHeader of(String name, String value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public static BasicBooleanHeader of(String name, Boolean value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public static BasicBooleanHeader of(String name, Supplier<Boolean> value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public BasicBooleanHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty(value) ? null : Boolean.valueOf(value);
        this.supplier = null;
    }

    public BasicBooleanHeader(String name, Boolean value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicBooleanHeader(String name, Supplier<Boolean> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify(this.value());
    }

    public Optional<Boolean> asBoolean() {
        return CollectionUtils.optional(this.value());
    }

    public Boolean toBoolean() {
        return this.value();
    }

    public boolean isTrue() {
        Boolean x = this.value();
        return x == null ? this.value : x;
    }

    public FluentBooleanAssertion<BasicBooleanHeader> assertBoolean() {
        return new FluentBooleanAssertion<BasicBooleanHeader>(this.value(), this);
    }

    public Boolean orElse(Boolean other) {
        Boolean x = this.value();
        return x != null ? x : other;
    }

    private Boolean value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

