/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.params.HttpParams;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.response.HttpExceptionBuilder;
import org.apache.juneau.internal.StringUtils;

@BeanIgnore
public class BasicHttpException
extends BasicRuntimeException
implements HttpResponse {
    private static final long serialVersionUID = 1L;
    HeaderList headers;
    BasicStatusLine statusLine;
    HeaderList.Builder headersBuilder;
    BasicStatusLine.Builder statusLineBuilder;
    HttpEntity content;

    public static <T extends BasicHttpException> HttpExceptionBuilder<T> create(Class<T> implClass) {
        return new HttpExceptionBuilder<Class<T>>(implClass);
    }

    public BasicHttpException(HttpExceptionBuilder<?> builder) {
        super(builder);
        this.headers = builder.buildHeaders();
        this.statusLine = builder.buildStatusLine();
        this.content = builder.content;
    }

    public BasicHttpException(int statusCode, Throwable cause, String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)((HttpExceptionBuilder)BasicHttpException.create(null).statusCode(statusCode).causedBy(cause)).message(msg, args));
    }

    public BasicHttpException(int statusCode) {
        this(BasicHttpException.create(null).statusCode(statusCode));
    }

    public BasicHttpException(int statusCode, String msg, Object ... args) {
        this((HttpExceptionBuilder<?>)BasicHttpException.create(null).statusCode(statusCode).message(msg, args));
    }

    public BasicHttpException(int statusCode, Throwable causedBy) {
        this((HttpExceptionBuilder<?>)BasicHttpException.create(null).statusCode(statusCode).causedBy(causedBy));
    }

    public BasicHttpException(HttpResponse response) {
        this(BasicHttpException.create(null).copyFrom(response));
    }

    public HttpExceptionBuilder<? extends BasicHttpException> copy() {
        return new HttpExceptionBuilder<BasicHttpException>(this);
    }

    public Throwable getRootCause() {
        for (Throwable t = this; t != null; t = t.getCause()) {
            if (t instanceof BasicHttpException || t instanceof InvocationTargetException) continue;
            return t;
        }
        return null;
    }

    protected void assertStatusCode(HttpResponse response) throws AssertionError {
        Assertions.assertArgNotNull("response", response);
        int expected = this.getStatusLine().getStatusCode();
        int actual = response.getStatusLine().getStatusCode();
        Assertions.assertInteger(actual).setMsg("Unexpected status code.  Expected:[{0}], Actual:[{1}]", expected, actual).is(expected);
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        for (Throwable e = this.getCause(); e != null; e = e.getCause()) {
            msg = e.getMessage();
            if (msg != null && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = e.getClass().getSimpleName();
            if (msg == null) {
                sb.append(StringUtils.format("\nCaused by ({0})", cls));
                continue;
            }
            sb.append(StringUtils.format("\nCaused by ({0}): {1}", cls, msg));
        }
        return sb.toString();
    }

    @Override
    public String getMessage() {
        String m = super.getMessage();
        if (m == null && this.getCause() != null) {
            m = this.getCause().getMessage();
        }
        if (m == null) {
            m = this.statusLine().getReasonPhrase();
        }
        return m;
    }

    public int hashCode() {
        int i = 0;
        for (Throwable t = this; t != null; t = t.getCause()) {
            for (StackTraceElement e : t.getStackTrace()) {
                i ^= e.hashCode();
            }
        }
        return i;
    }

    @Override
    public String toString() {
        return StringUtils.emptyIfNull(this.getLocalizedMessage());
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.statusLine().getProtocolVersion();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.headers().contains(name);
    }

    @Override
    public Header[] getHeaders(String name) {
        return this.headers().getAll(name);
    }

    @Override
    public Header getFirstHeader(String name) {
        return this.headers().getFirst(name).orElse(null);
    }

    @Override
    public Header getLastHeader(String name) {
        return this.headers().getLast(name).orElse(null);
    }

    @Override
    public Header[] getAllHeaders() {
        return this.headers().getAll();
    }

    @Override
    public void addHeader(Header value) {
        this.headersBuilder().append(value).build();
    }

    @Override
    public void addHeader(String name, String value) {
        this.headersBuilder().append(name, value).build();
    }

    @Override
    public void setHeader(Header value) {
        this.headersBuilder().set(value).build();
    }

    @Override
    public void setHeader(String name, String value) {
        this.headersBuilder().set(name, value).build();
    }

    @Override
    public void setHeaders(Header[] values) {
        this.headersBuilder().clear().append(values).build();
    }

    @Override
    public void removeHeader(Header value) {
        this.headersBuilder().remove(value).build();
    }

    @Override
    public void removeHeaders(String name) {
        this.headersBuilder().remove(name).build();
    }

    @Override
    public HeaderIterator headerIterator() {
        return this.headers().iterator();
    }

    @Override
    public HeaderIterator headerIterator(String name) {
        return this.headers().iterator(name);
    }

    @Override
    public HttpParams getParams() {
        return null;
    }

    @Override
    public void setParams(HttpParams params) {
    }

    @Override
    public StatusLine getStatusLine() {
        return this.statusLine();
    }

    @Override
    public void setStatusLine(StatusLine value) {
        this.setStatusLine(value.getProtocolVersion(), value.getStatusCode(), value.getReasonPhrase());
    }

    @Override
    public void setStatusLine(ProtocolVersion ver, int code) {
        this.statusLineBuilder().protocolVersion(ver).statusCode(code).build();
    }

    @Override
    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.statusLineBuilder().protocolVersion(ver).reasonPhrase(reason).statusCode(code).build();
    }

    @Override
    public void setStatusCode(int code) throws IllegalStateException {
        this.statusLineBuilder().statusCode(code).build();
    }

    @Override
    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.statusLineBuilder().reasonPhrase(reason).build();
    }

    @Override
    public HttpEntity getEntity() {
        if (this.content == null) {
            this.content = HttpEntities.stringEntity(this.getMessage()).build();
        }
        return this.content;
    }

    @Override
    public void setEntity(HttpEntity entity) {
        this.assertModifiable();
        this.content = entity;
    }

    @Override
    public Locale getLocale() {
        return this.statusLine().getLocale();
    }

    @Override
    public void setLocale(Locale loc) {
        this.statusLineBuilder().locale(loc).build();
    }

    private BasicStatusLine statusLine() {
        if (this.statusLine == null) {
            this.statusLine = this.statusLineBuilder.build();
            this.statusLineBuilder = null;
        }
        return this.statusLine;
    }

    private HeaderList headers() {
        if (this.headers == null) {
            this.headers = (HeaderList)this.headersBuilder.build();
            this.headersBuilder = null;
        }
        return this.headers;
    }

    private BasicStatusLine.Builder statusLineBuilder() {
        this.assertModifiable();
        if (this.statusLineBuilder == null) {
            this.statusLineBuilder = this.statusLine.copy();
            this.statusLine = null;
        }
        return this.statusLineBuilder;
    }

    private HeaderList.Builder headersBuilder() {
        this.assertModifiable();
        if (this.headersBuilder == null) {
            this.headersBuilder = this.headers.copy();
            this.headers = null;
        }
        return this.headersBuilder;
    }
}

