/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import org.apache.http.NameValuePair;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentLongAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestHttpPart;

public class RequestQueryParam
extends RequestHttpPart
implements NameValuePair {
    private final String value;

    public RequestQueryParam(RestRequest request, String name, String value) {
        super(HttpPartType.QUERY, request, name);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public FluentStringAssertion<RequestQueryParam> assertString() {
        return new FluentStringAssertion<RequestQueryParam>(this.orElse(null), this);
    }

    public FluentIntegerAssertion<RequestQueryParam> assertInteger() {
        return new FluentIntegerAssertion<RequestQueryParam>(this.asIntegerPart().asInteger().orElse(null), this);
    }

    public FluentLongAssertion<RequestQueryParam> assertLong() {
        return new FluentLongAssertion<RequestQueryParam>(this.asLongPart().asLong().orElse(null), this);
    }

    public FluentZonedDateTimeAssertion<RequestQueryParam> assertDate() {
        return new FluentZonedDateTimeAssertion<RequestQueryParam>(this.asDatePart().asZonedDateTime().orElse(null), this);
    }

    public FluentListAssertion<String, RequestQueryParam> assertCsvArray() {
        return new FluentListAssertion<String, RequestQueryParam>(this.asCsvArrayPart().asList().orElse(null), this);
    }

    @Override
    public RequestQueryParam schema(HttpPartSchema value) {
        super.schema(value);
        return this;
    }

    @Override
    public RequestQueryParam parser(HttpPartParserSession value) {
        super.parser(value);
        return this;
    }
}

