/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.Value;
import org.apache.juneau.http.remote.RemoteOp;
import org.apache.juneau.http.remote.RemoteUtils;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanMeta;
import org.apache.juneau.internal.HttpUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.reflect.AnnotationList;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.client.remote.RemoteMetadataException;
import org.apache.juneau.rest.client.remote.RemoteOperationArg;
import org.apache.juneau.rest.client.remote.RemoteOperationBeanArg;
import org.apache.juneau.rest.client.remote.RemoteOperationReturn;

public class RemoteOperationMeta {
    private final String httpMethod;
    private final String fullPath;
    private final RemoteOperationArg[] pathArgs;
    private final RemoteOperationArg[] queryArgs;
    private final RemoteOperationArg[] headerArgs;
    private final RemoteOperationArg[] formDataArgs;
    private final RemoteOperationBeanArg[] requestArgs;
    private final RemoteOperationArg contentArg;
    private final RemoteOperationReturn methodReturn;
    private final Class<?>[] exceptions;

    public RemoteOperationMeta(String parentPath, Method m, String defaultMethod) {
        Builder b = new Builder(parentPath, m, defaultMethod);
        this.httpMethod = b.httpMethod;
        this.fullPath = b.fullPath;
        this.pathArgs = b.pathArgs.toArray(new RemoteOperationArg[b.pathArgs.size()]);
        this.queryArgs = b.queryArgs.toArray(new RemoteOperationArg[b.queryArgs.size()]);
        this.formDataArgs = b.formDataArgs.toArray(new RemoteOperationArg[b.formDataArgs.size()]);
        this.headerArgs = b.headerArgs.toArray(new RemoteOperationArg[b.headerArgs.size()]);
        this.requestArgs = b.requestArgs.toArray(new RemoteOperationBeanArg[b.requestArgs.size()]);
        this.contentArg = b.bodyArg;
        this.methodReturn = b.methodReturn;
        this.exceptions = m.getExceptionTypes();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public RemoteOperationMeta forEachPathArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.pathArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachQueryArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.queryArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachFormDataArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.formDataArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachHeaderArg(Consumer<RemoteOperationArg> action) {
        for (RemoteOperationArg a : this.headerArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationMeta forEachRequestArg(Consumer<RemoteOperationBeanArg> action) {
        for (RemoteOperationBeanArg a : this.requestArgs) {
            action.accept(a);
        }
        return this;
    }

    public RemoteOperationArg getContentArg() {
        return this.contentArg;
    }

    public RemoteOperationReturn getReturns() {
        return this.methodReturn;
    }

    public RemoteOperationMeta forEachException(Consumer<Class<?>> action) {
        for (Class<?> e : this.exceptions) {
            action.accept(e);
        }
        return this;
    }

    private static final class Builder {
        String httpMethod;
        String fullPath;
        String path;
        List<RemoteOperationArg> pathArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationArg> queryArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationArg> headerArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationArg> formDataArgs = new LinkedList<RemoteOperationArg>();
        List<RemoteOperationBeanArg> requestArgs = new LinkedList<RemoteOperationBeanArg>();
        RemoteOperationArg bodyArg;
        RemoteOperationReturn methodReturn;

        Builder(String parentPath, Method m, String defaultMethod) {
            MethodInfo mi = MethodInfo.of((Method)m);
            AnnotationList al = mi.getAnnotationList(RemoteUtils.REMOTE_OP_GROUP);
            if (al.isEmpty()) {
                al = mi.getReturnType().unwrap(new Class[]{Value.class, Optional.class}).getAnnotationList(RemoteUtils.REMOTE_OP_GROUP);
            }
            Value _httpMethod = Value.empty();
            Value _path = Value.empty();
            al.forEachValue(String.class, "method", StringUtils.NOT_EMPTY, x -> _httpMethod.set((Object)x.trim()));
            al.forEachValue(String.class, "path", StringUtils.NOT_EMPTY, x -> _path.set((Object)x.trim()));
            this.httpMethod = ((String)_httpMethod.orElse((Object)"")).trim();
            this.path = ((String)_path.orElse((Object)"")).trim();
            Value value = Value.empty();
            al.forEach(RemoteOp.class, x -> StringUtils.isNotEmpty((String)((RemoteOp)x.inner()).value().trim()), x -> value.set((Object)((RemoteOp)x.inner()).value().trim()));
            if (value.isPresent()) {
                String v = (String)value.get();
                int i = v.indexOf(32);
                if (i == -1) {
                    this.httpMethod = v;
                } else {
                    this.httpMethod = v.substring(0, i).trim();
                    this.path = v.substring(i).trim();
                }
            } else {
                al.forEach(x -> !x.isType(RemoteOp.class) && StringUtils.isNotEmpty((String)x.getValue(String.class, "value", StringUtils.NOT_EMPTY).orElse("").trim()), x -> value.set((Object)((String)x.getValue(String.class, "value", StringUtils.NOT_EMPTY).get()).trim()));
                if (value.isPresent()) {
                    this.path = (String)value.get();
                }
            }
            if (this.path.isEmpty()) {
                this.path = HttpUtils.detectHttpPath((Method)m, (String)StringUtils.nullIfEmpty((String)this.httpMethod));
            }
            if (this.httpMethod.isEmpty()) {
                this.httpMethod = HttpUtils.detectHttpMethod((Method)m, (boolean)true, (String)defaultMethod);
            }
            this.path = StringUtils.trimSlashes((String)this.path);
            if (!StringUtils.isOneOf((String)this.httpMethod, (String[])new String[]{"DELETE", "GET", "POST", "PUT", "OPTIONS", "HEAD", "CONNECT", "TRACE", "PATCH"})) {
                throw new RemoteMetadataException(m, "Invalid value specified for @RemoteOp(httpMethod) annotation.  Valid values are [DELTE,GET,POST,PUT,OPTIONS,HEAD,CONNECT,TRACE,PATCH].", new Object[0]);
            }
            this.methodReturn = new RemoteOperationReturn(mi);
            this.fullPath = this.path.indexOf("://") != -1 ? this.path : (parentPath.isEmpty() ? StringUtils.urlEncodePath((Object)this.path) : StringUtils.trimSlashes((String)parentPath) + '/' + StringUtils.urlEncodePath((Object)this.path));
            mi.getParams().forEach(x -> {
                RequestBeanMeta rmba;
                RemoteOperationArg rma = RemoteOperationArg.create(x);
                if (rma != null) {
                    HttpPartType pt = rma.getPartType();
                    if (pt == HttpPartType.HEADER) {
                        this.headerArgs.add(rma);
                    } else if (pt == HttpPartType.QUERY) {
                        this.queryArgs.add(rma);
                    } else if (pt == HttpPartType.FORMDATA) {
                        this.formDataArgs.add(rma);
                    } else if (pt == HttpPartType.PATH) {
                        this.pathArgs.add(rma);
                    } else {
                        this.bodyArg = rma;
                    }
                }
                if ((rmba = RequestBeanMeta.create((ParamInfo)x, (AnnotationWorkList)AnnotationWorkList.create())) != null) {
                    this.requestArgs.add(new RemoteOperationBeanArg(x.getIndex(), rmba));
                }
            });
        }
    }
}

