/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.Context;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;

public abstract class ContextSession {
    private final JsonMap properties;
    private List<String> warnings;
    private final Context ctx;
    private final boolean debug;
    private final boolean unmodifiable;

    protected ContextSession(Builder builder) {
        JsonMap sp;
        this.ctx = builder.ctx;
        this.unmodifiable = builder.unmodifiable;
        JsonMap jsonMap = sp = builder.properties == null ? JsonMap.EMPTY_MAP : builder.properties;
        if (this.unmodifiable) {
            sp = sp.unmodifiable();
        }
        this.properties = sp;
        this.debug = builder.debug;
    }

    public final JsonMap getSessionProperties() {
        return this.properties;
    }

    public Context getContext() {
        return this.ctx;
    }

    public void addWarning(String msg, Object ... args) {
        if (this.unmodifiable) {
            return;
        }
        if (this.warnings == null) {
            this.warnings = new LinkedList<String>();
        }
        this.warnings.add(this.warnings.size() + 1 + ": " + StringUtils.format(msg, args));
    }

    public final List<String> getWarnings() {
        return this.warnings == null ? Collections.emptyList() : this.warnings;
    }

    public void checkForWarnings() {
        if (this.debug && !this.getWarnings().isEmpty()) {
            throw new BeanRuntimeException("Warnings occurred in session: \n" + StringUtils.join(this.getWarnings(), "\n"));
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap("debug", this.debug);
    }

    public String toString() {
        return ObjectUtils.toPropertyMap(this).asReadableString();
    }

    @FluentSetters
    public static abstract class Builder {
        Context ctx;
        JsonMap properties;
        boolean unmodifiable;
        Boolean debug;

        protected Builder(Context ctx) {
            this.ctx = ctx;
            this.debug = ctx.debug;
        }

        public abstract ContextSession build();

        @FluentSetter
        public Builder debug(Boolean value) {
            if (value != null) {
                this.debug = value;
            }
            return this;
        }

        @FluentSetter
        public Builder unmodifiable() {
            this.unmodifiable = true;
            return this;
        }

        @FluentSetter
        public Builder properties(Map<String, Object> value) {
            this.properties = JsonMap.of(value);
            return this;
        }

        @FluentSetter
        public Builder property(String key, Object value) {
            if (this.properties == null) {
                this.properties = JsonMap.create();
            }
            if (value == null) {
                this.properties.remove(key);
            } else {
                this.properties.put(key, value);
            }
            return this;
        }

        @FluentSetter
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            if (type.isInstance(this)) {
                apply.accept(type.cast(this));
            }
            return this;
        }
    }
}

