/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpResponse;
import org.apache.juneau.http.response.HttpResponseBuilder;

@Response
@StatusCode(value={304})
@Schema(description={"Not Modified"})
public class NotModified
extends BasicHttpResponse {
    public static final int STATUS_CODE = 304;
    public static final String REASON_PHRASE = "Not Modified";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(304).reasonPhrase("Not Modified").build();
    public static final NotModified INSTANCE = NotModified.create().unmodifiable().build();

    public static HttpResponseBuilder<NotModified> create() {
        return new HttpResponseBuilder<Class<NotModified>>(NotModified.class).statusLine(STATUS_LINE);
    }

    public NotModified(HttpResponseBuilder<?> builder) {
        super(builder);
    }

    public NotModified(HttpResponse response) {
        this(NotModified.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpResponseBuilder<NotModified> copy() {
        return new HttpResponseBuilder<NotModified>(this);
    }
}

