/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.util.List;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.ConfigException;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.rest.processor.ResponseProcessor;

public class ResponseProcessorList {
    private final ResponseProcessor[] entries;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected ResponseProcessorList(Builder builder) {
        BeanStore bs = builder.beanStore();
        this.entries = (ResponseProcessor[])builder.entries.stream().map(x -> ResponseProcessorList.instantiate(x, bs)).toArray(ResponseProcessor[]::new);
    }

    private static ResponseProcessor instantiate(Object o, BeanStore bs) {
        if (o instanceof ResponseProcessor) {
            return (ResponseProcessor)o;
        }
        try {
            return (ResponseProcessor)bs.createBean(ResponseProcessor.class).type((Class)o).run();
        }
        catch (ExecutableException e) {
            throw new ConfigException((Throwable)e, "Could not instantiate class {0}", new Object[]{o});
        }
    }

    public ResponseProcessor[] toArray() {
        return this.entries;
    }

    @FluentSetters
    public static class Builder
    extends BeanBuilder<ResponseProcessorList> {
        List<Object> entries = CollectionUtils.list((Object[])new Object[0]);

        protected Builder(BeanStore beanStore) {
            super(ResponseProcessorList.class, beanStore);
        }

        protected ResponseProcessorList buildDefault() {
            return new ResponseProcessorList(this);
        }

        public Builder add(Class<?> ... values) {
            CollectionUtils.addAll(this.entries, (Object[])Assertions.assertClassArrayArgIsType((String)"values", ResponseProcessor.class, (Class[])values));
            return this;
        }

        public Builder add(ResponseProcessor ... values) {
            CollectionUtils.addAll(this.entries, (Object[])values);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }
}

