/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.reflect.ClassInfo;

public final class InvalidDataConversionException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;

    public InvalidDataConversionException(Throwable cause, String message, Object ... args) {
        super(cause, message, args);
    }

    public InvalidDataConversionException(Object value, Class<?> toType, Exception cause) {
        this(cause, "Invalid data conversion from type ''{0}'' to type ''{1}''.  Value={2}.", InvalidDataConversionException.name(value), InvalidDataConversionException.name(toType), InvalidDataConversionException.value(value));
    }

    public InvalidDataConversionException(Object value, ClassMeta<?> toType, Exception cause) {
        this(cause, "Invalid data conversion from type ''{0}'' to type ''{1}''.  Value={2}.", InvalidDataConversionException.name(value), StringUtils.stringify(toType), InvalidDataConversionException.value(value));
    }

    private static String value(Object o) {
        if (o instanceof Class) {
            return "'" + InvalidDataConversionException.name(o) + "'";
        }
        return SimpleJsonSerializer.DEFAULT == null ? "'" + o.toString() + "'" : SimpleJsonSerializer.DEFAULT.toString(o);
    }

    private static String name(Class<?> c) {
        return ClassInfo.of(c).getFullName();
    }

    private static String name(Object o) {
        return ClassInfo.of(o).getFullName();
    }
}

