/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.internal.StringUtils;

public class AssertionPredicate<T>
implements Predicate<T> {
    public static final Function<Object, String> VALUE = x -> StringUtils.stringifyDeep(x);
    private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, "Messages");
    private static final String MSG_valueDidNotPassTest = MESSAGES.getString("valueDidNotPassTest");
    private static final String MSG_valueDidNotPassTestWithValue = MESSAGES.getString("valueDidNotPassTestWithValue");
    private final Predicate<T> inner;
    private final String message;
    private final Object[] args;
    final ThreadLocal<String> failedMessage = new ThreadLocal();

    public AssertionPredicate(Predicate<T> inner, String message, Object ... args) {
        this.inner = inner;
        if (message != null) {
            this.message = message;
            this.args = args;
        } else if (inner instanceof AssertionPredicate) {
            this.message = MSG_valueDidNotPassTest;
            this.args = new Object[0];
        } else {
            this.message = MSG_valueDidNotPassTestWithValue;
            this.args = new Object[]{VALUE};
        }
    }

    AssertionPredicate() {
        this.inner = null;
        this.message = null;
        this.args = null;
    }

    @Override
    public boolean test(T t) {
        this.failedMessage.remove();
        boolean b = this.inner.test(t);
        if (!b) {
            String m = this.message;
            Object[] args = new Object[this.args.length];
            for (int i = 0; i < args.length; ++i) {
                Object a = this.args[i];
                args[i] = a instanceof Function ? ((Function)a).apply(t) : a;
            }
            m = StringUtils.format(m, args);
            if (this.inner instanceof AssertionPredicate) {
                m = m + "\n\t" + ((AssertionPredicate)this.inner).getFailureMessage();
            }
            this.failedMessage.set(m);
        }
        return this.inner.test(t);
    }

    protected String getFailureMessage() {
        return this.failedMessage.get();
    }

    public static class Not<T>
    extends AssertionPredicate<T> {
        private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, "Messages");
        private static final String MSG_predicateTestsUnexpectedlyPassed = MESSAGES.getString("predicateTestsUnexpectedlyPassed");
        private final Predicate<T> inner;

        public Not(Predicate<T> inner) {
            this.inner = inner;
        }

        @Override
        public boolean test(T t) {
            boolean b;
            this.failedMessage.remove();
            Predicate<T> p = this.inner;
            if (p != null && (b = p.test(t))) {
                this.failedMessage.set(StringUtils.format(MSG_predicateTestsUnexpectedlyPassed, new Object[0]));
                return false;
            }
            return true;
        }
    }

    public static class Or<T>
    extends AssertionPredicate<T> {
        private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, "Messages");
        private static final String MSG_noPredicateTestsPassed = MESSAGES.getString("noPredicateTestsPassed");
        private final Predicate<T>[] inner;

        @SafeVarargs
        public Or(Predicate<T> ... inner) {
            this.inner = inner;
        }

        @Override
        public boolean test(T t) {
            this.failedMessage.remove();
            for (Predicate<T> p : this.inner) {
                if (p == null || !p.test(t)) continue;
                return true;
            }
            String m = StringUtils.format(MSG_noPredicateTestsPassed, new Object[0]);
            this.failedMessage.set(m);
            return false;
        }
    }

    public static class And<T>
    extends AssertionPredicate<T> {
        private final Predicate<T>[] inner;
        private static final Messages MESSAGES = Messages.of(AssertionPredicate.class, "Messages");
        private static final String MSG_predicateTestFailed = MESSAGES.getString("predicateTestFailed");

        @SafeVarargs
        public And(Predicate<T> ... inner) {
            this.inner = inner;
        }

        @Override
        public boolean test(T t) {
            this.failedMessage.remove();
            for (int i = 0; i < this.inner.length; ++i) {
                boolean b;
                Predicate<T> p = this.inner[i];
                if (p == null || (b = p.test(t))) continue;
                String m = StringUtils.format(MSG_predicateTestFailed, i + 1);
                if (p instanceof AssertionPredicate) {
                    m = m + "\n\t" + ((AssertionPredicate)p).getFailureMessage();
                }
                this.failedMessage.set(m);
                return false;
            }
            return true;
        }
    }
}

