/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import org.apache.http.HttpResponse;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.http.response.BasicHttpResponse;
import org.apache.juneau.http.response.HttpResponseBuilder;

@Response
@StatusCode(value={204})
@Schema(description={"No Content"})
public class NoContent
extends BasicHttpResponse {
    public static final int STATUS_CODE = 204;
    public static final String REASON_PHRASE = "No Content";
    private static final BasicStatusLine STATUS_LINE = BasicStatusLine.create().statusCode(204).reasonPhrase("No Content").build();
    public static final NoContent INSTANCE = NoContent.create().unmodifiable().build();

    public static HttpResponseBuilder<NoContent> create() {
        return new HttpResponseBuilder<Class<NoContent>>(NoContent.class).statusLine(STATUS_LINE);
    }

    public NoContent(HttpResponseBuilder<?> builder) {
        super(builder);
    }

    public NoContent(HttpResponse response) {
        this(NoContent.create().copyFrom(response));
        this.assertStatusCode(response);
    }

    public HttpResponseBuilder<NoContent> copy() {
        return new HttpResponseBuilder<NoContent>(this);
    }
}

