/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.jena.rdf.model.Bag;
import org.apache.jena.rdf.model.Container;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFReader;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Seq;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.http.header.MediaType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.swap.BuilderSwap;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlUtils;

public class RdfParserSession
extends ReaderParserSession {
    private final RdfParser ctx;
    private final Property pRoot;
    private final Property pValue;
    private final Property pType;
    private final Property pRdfType;
    private final Model model;
    private final RDFReader rdfReader;
    private final Set<Resource> urisVisited = new HashSet<Resource>();

    public static Builder create(RdfParser ctx) {
        return new Builder(ctx);
    }

    protected RdfParserSession(Builder builder) {
        super((ReaderParserSession.Builder)builder);
        this.ctx = builder.ctx;
        this.model = ModelFactory.createDefaultModel();
        this.addModelPrefix(this.ctx.getJuneauNs());
        this.addModelPrefix(this.ctx.getJuneauBpNs());
        this.pRoot = this.model.createProperty(this.ctx.getJuneauNs().getUri(), "root");
        this.pValue = this.model.createProperty(this.ctx.getJuneauNs().getUri(), "value");
        this.pType = this.model.createProperty(this.ctx.getJuneauBpNs().getUri(), "_type");
        this.pRdfType = this.model.createProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.rdfReader = this.model.getReader(this.ctx.getLanguage());
        if (!this.ctx.getLanguage().equals("N-TRIPLE")) {
            this.ctx.getJenaSettings().forEach((k, v) -> this.rdfReader.setProperty(k, v));
        }
    }

    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws IOException, ParseException, ExecutableException {
        RDFReader r = this.rdfReader;
        r.read(this.model, pipe.getBufferedReader(), null);
        List<Resource> roots = this.getRoots(this.model);
        if (this.isLooseCollections() && type.isCollectionOrArray()) {
            Collection c = null;
            c = type.isArray() || type.isArgs() ? CollectionUtils.list((Object[])new Object[0]) : (type.canCreateNewInstance(this.getOuter()) ? (Collection)type.newInstance(this.getOuter()) : new JsonList((BeanSession)this));
            AtomicInteger argIndex = new AtomicInteger(0);
            ArrayList c2 = c;
            roots.forEach(x -> c2.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex.getAndIncrement()) : type.getElementType(), (RDFNode)x, this.getOuter(), null)));
            if (type.isArray() || type.isArgs()) {
                return (T)this.toArray(type, c);
            }
            return (T)c;
        }
        if (roots.isEmpty()) {
            return (T)(type.isOptional() ? CollectionUtils.empty() : null);
        }
        if (roots.size() > 1) {
            throw new ParseException((ParserSession)this, "Too many root nodes found in model:  {0}", new Object[]{roots.size()});
        }
        Resource resource = roots.get(0);
        return this.parseAnything(type, (RDFNode)resource, this.getOuter(), null);
    }

    private final void addModelPrefix(Namespace ns) {
        this.model.setNsPrefix(ns.getName(), ns.getUri());
    }

    private String decodeString(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        if (s.isEmpty()) {
            return s;
        }
        if (this.isTrimWhitespace()) {
            s = s.trim();
        }
        s = XmlUtils.decode((String)s, null);
        if (this.isTrimStrings()) {
            s = s.trim();
        }
        return s;
    }

    private List<Resource> getRoots(Model m) {
        LinkedList<Resource> l = new LinkedList<Resource>();
        Property root = m.createProperty(this.getJuneauNs().getUri(), "root");
        ResIterator i = m.listResourcesWithProperty(root);
        while (i.hasNext()) {
            l.add((Resource)i.next());
        }
        if (!l.isEmpty()) {
            return l;
        }
        HashSet<RDFNode> objects = new HashSet<RDFNode>();
        StmtIterator i2 = m.listStatements();
        while (i2.hasNext()) {
            Statement st = (Statement)i2.next();
            Resource subject = st.getSubject();
            RDFNode object = st.getObject();
            if (!object.isResource() || object.equals(subject)) continue;
            objects.add(object);
        }
        i2 = m.listSubjects();
        while (i2.hasNext()) {
            Resource r = (Resource)i2.next();
            if (objects.contains(r)) continue;
            l.add(r);
        }
        return l;
    }

    private <T> BeanMap<T> parseIntoBeanMap(Resource r2, BeanMap<T> m) throws ParseException {
        BeanMeta bm = m.getMeta();
        RdfBeanMeta rbm = this.getRdfBeanMeta(bm);
        if (rbm.hasBeanUri() && r2.getURI() != null) {
            rbm.getBeanUriProperty().set(m, null, (Object)r2.getURI());
        }
        StmtIterator i = r2.listProperties();
        while (i.hasNext()) {
            RDFNode o;
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = this.decodeString(p.getLocalName());
            BeanPropertyMeta pMeta = m.getPropertyMeta(key);
            this.setCurrentProperty(pMeta);
            if (pMeta != null) {
                o = st.getObject();
                ClassMeta cm = pMeta.getClassMeta();
                if (cm.isCollectionOrArray() && this.isMultiValuedCollections(pMeta)) {
                    ClassMeta et = cm.getElementType();
                    T value = this.parseAnything(et, o, m.getBean(false), pMeta);
                    RdfParserSession.setName((ClassMeta)et, value, (Object)key);
                    try {
                        pMeta.add(m, key, value);
                    }
                    catch (BeanRuntimeException e) {
                        this.onBeanSetterException(pMeta, e);
                        throw e;
                    }
                } else {
                    T value = this.parseAnything(cm, o, m.getBean(false), pMeta);
                    RdfParserSession.setName((ClassMeta)cm, value, (Object)key);
                    try {
                        pMeta.set(m, key, value);
                    }
                    catch (BeanRuntimeException e) {
                        this.onBeanSetterException(pMeta, e);
                        throw e;
                    }
                }
            } else if (!p.equals(this.pRoot) && !p.equals(this.pType)) {
                o = st.getObject();
                T value = this.parseAnything(this.object(), o, m.getBean(false), null);
                this.onUnknownProperty(key, m, value);
            }
            this.setCurrentProperty(null);
        }
        return m;
    }

    private boolean isMultiValuedCollections(BeanPropertyMeta pMeta) {
        RdfBeanPropertyMeta bpRdf;
        RdfBeanPropertyMeta rdfBeanPropertyMeta = bpRdf = pMeta == null ? RdfBeanPropertyMeta.DEFAULT : this.getRdfBeanPropertyMeta(pMeta);
        if (bpRdf.getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
            return bpRdf.getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
        }
        return this.getCollectionFormat() == RdfCollectionFormat.MULTI_VALUED;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<?> eType, RDFNode n, Object outer, BeanPropertyMeta pMeta) throws ParseException {
        String c;
        ClassMeta tcm;
        Statement st;
        if (eType == null) {
            eType = this.object();
        }
        ObjectSwap swap = eType.getSwap((BeanSession)this);
        BuilderSwap builder = eType.getBuilderSwap((BeanSession)this);
        ClassMeta sType = null;
        sType = builder != null ? builder.getBuilderClassMeta((BeanSession)this) : (swap != null ? swap.getSwapClassMeta((BeanSession)this) : eType);
        if (sType.isOptional()) {
            return (T)CollectionUtils.optional(this.parseAnything(eType.getElementType(), n, outer, pMeta));
        }
        this.setCurrentClass(sType);
        if (!sType.canCreateNewInstance(outer) && n.isResource() && (st = n.asResource().getProperty(this.pType)) != null && (tcm = this.getClassMeta(c = st.getLiteral().getString(), pMeta, eType)) != null) {
            sType = eType = tcm;
        }
        Object o = null;
        if (!n.isResource() || n.asResource().getURI() == null || !n.asResource().getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil")) {
            BeanMap bm;
            Map m;
            Resource r;
            if (sType.isObject()) {
                if (n.isLiteral()) {
                    o = n.asLiteral().getValue();
                    if (o instanceof String) {
                        o = this.decodeString(o);
                    }
                } else {
                    if (!n.isResource()) throw new ParseException((ParserSession)this, "Unrecognized node type ''{0}'' for object", new Object[]{n});
                    r = n.asResource();
                    if (!this.urisVisited.add(r)) {
                        o = r.getURI();
                    } else if (r.getProperty(this.pValue) != null) {
                        o = this.parseAnything(this.object(), n.asResource().getProperty(this.pValue).getObject(), outer, null);
                    } else if (this.isSeq((RDFNode)r)) {
                        o = new JsonList((BeanSession)this);
                        this.parseIntoCollection((Container)r.as(Seq.class), (Collection)o, sType, pMeta);
                    } else if (this.isBag((RDFNode)r)) {
                        o = new JsonList((BeanSession)this);
                        this.parseIntoCollection((Container)r.as(Bag.class), (Collection)o, sType, pMeta);
                    } else if (r.canAs(RDFList.class)) {
                        o = new JsonList((BeanSession)this);
                        this.parseIntoCollection((RDFList)r.as(RDFList.class), (Collection)o, sType, pMeta);
                    } else {
                        String uri = r.getURI();
                        if (uri != null && !r.listProperties().hasNext()) {
                            o = r.getURI();
                        } else {
                            JsonMap m2 = new JsonMap((BeanSession)this);
                            this.parseIntoMap(r, (Map)m2, null, null, pMeta);
                            o = this.cast(m2, pMeta, eType);
                        }
                    }
                }
            } else if (sType.isBoolean()) {
                o = this.convertToType(this.getValue(n, outer), Boolean.TYPE);
            } else if (sType.isCharSequence()) {
                o = this.decodeString(this.getValue(n, outer));
            } else if (sType.isChar()) {
                o = StringUtils.parseCharacter((Object)this.decodeString(this.getValue(n, outer)));
            } else if (sType.isNumber()) {
                o = StringUtils.parseNumber((String)this.getValue(n, outer).toString(), (Class)sType.getInnerClass());
            } else if (sType.isMap()) {
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                m = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : this.newGenericMap(sType);
                o = this.parseIntoMap(r, m, eType.getKeyType(), eType.getValueType(), pMeta);
            } else if (sType.isCollectionOrArray() || sType.isArgs()) {
                o = sType.isArray() || sType.isArgs() ? CollectionUtils.list((Object[])new Object[0]) : (sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new JsonList((BeanSession)this));
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                if (this.isSeq((RDFNode)r)) {
                    this.parseIntoCollection((Container)r.as(Seq.class), (Collection)o, sType, pMeta);
                } else if (this.isBag((RDFNode)r)) {
                    this.parseIntoCollection((Container)r.as(Bag.class), (Collection)o, sType, pMeta);
                } else {
                    if (!r.canAs(RDFList.class)) throw new ParseException((ParserSession)this, "Unrecognized node type ''{0}'' for collection", new Object[]{n});
                    this.parseIntoCollection((RDFList)r.as(RDFList.class), (Collection)o, sType, pMeta);
                }
                if (sType.isArray() || sType.isArgs()) {
                    o = this.toArray(sType, (Collection)o);
                }
            } else if (builder != null) {
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                bm = this.toBeanMap(builder.create((BeanSession)this, eType));
                o = builder.build((BeanSession)this, this.parseIntoBeanMap(r, bm).getBean(), eType);
            } else if (sType.canCreateNewBean(outer)) {
                r = n.asResource();
                if (!this.urisVisited.add(r)) {
                    return null;
                }
                bm = this.newBeanMap(outer, sType.getInnerClass());
                o = this.parseIntoBeanMap(r, bm).getBean();
            } else if (sType.isUri() && n.isResource()) {
                o = sType.newInstanceFromString(outer, this.decodeString(n.asResource().getURI()));
            } else if (sType.canCreateNewInstanceFromString(outer)) {
                o = sType.newInstanceFromString(outer, this.decodeString(this.getValue(n, outer)));
            } else {
                if (!n.isResource()) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", new Object[]{sType.getInnerClass().getName(), sType.getNotABeanReason()});
                r = n.asResource();
                m = this.newGenericMap(sType);
                this.parseIntoMap(r, m, sType.getKeyType(), sType.getValueType(), pMeta);
                if (m.containsKey(this.getBeanTypePropertyName(eType))) {
                    o = this.cast((JsonMap)m, pMeta, eType);
                } else {
                    if (sType.getProxyInvocationHandler() == null) throw new ParseException((ParserSession)this, "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", new Object[]{sType.getInnerClass().getName(), sType.getNotABeanReason()});
                    o = this.newBeanMap(outer, sType.getInnerClass()).load(m).getBean();
                }
            }
        }
        if (swap != null && o != null) {
            o = this.unswap(swap, o, eType);
        }
        if (outer == null) return (T)o;
        RdfParserSession.setParent((ClassMeta)eType, (Object)o, (Object)outer);
        return (T)o;
    }

    private boolean isSeq(RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(this.pRdfType)) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq".equals(st.getResource().getURI());
        }
        return false;
    }

    private boolean isBag(RDFNode n) {
        Statement st;
        if (n.isResource() && (st = n.asResource().getProperty(this.pRdfType)) != null) {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag".equals(st.getResource().getURI());
        }
        return false;
    }

    private Object getValue(RDFNode n, Object outer) throws ParseException {
        Statement st;
        if (n.isLiteral()) {
            return n.asLiteral().getValue();
        }
        if (n.isResource() && (st = n.asResource().getProperty(this.pValue)) != null) {
            n = st.getObject();
            if (n.isLiteral()) {
                return n.asLiteral().getValue();
            }
            return this.parseAnything(this.object(), st.getObject(), outer, null);
        }
        throw new ParseException((ParserSession)this, "Unknown value type for node ''{0}''", new Object[]{n});
    }

    private <K, V> Map<K, V> parseIntoMap(Resource r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws ParseException {
        if (r.getURI() != null) {
            Object uri = this.convertAttrToType(m, "uri", keyType);
            Object value = this.convertAttrToType(m, r.getURI(), valueType);
            m.put(uri, value);
        }
        StmtIterator i = r.listProperties();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            Property p = st.getPredicate();
            String key = p.getLocalName();
            if (key.equals("root") && p.getURI().equals(this.getJuneauNs().getUri())) continue;
            key = this.decodeString(key);
            RDFNode o = st.getObject();
            Object key2 = this.convertAttrToType(m, key, keyType);
            Object value = this.parseAnything(valueType, o, m, pMeta);
            RdfParserSession.setName(valueType, value, (Object)key);
            m.put(key2, value);
        }
        return m;
    }

    private <E> Collection<E> parseIntoCollection(Container c, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws ParseException {
        int argIndex = 0;
        NodeIterator ni = c.iterator();
        while (ni.hasNext()) {
            Object e = this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), ni.next(), l, pMeta);
            l.add(e);
        }
        return l;
    }

    private <E> Collection<E> parseIntoCollection(RDFList list, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws ParseException {
        int argIndex = 0;
        ExtendedIterator ni = list.iterator();
        while (ni.hasNext()) {
            Object e = this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), (RDFNode)ni.next(), l, pMeta);
            l.add(e);
        }
        return l;
    }

    protected final RdfCollectionFormat getCollectionFormat() {
        return this.ctx.getCollectionFormat();
    }

    protected final Namespace getJuneauBpNs() {
        return this.ctx.getJuneauBpNs();
    }

    protected final Namespace getJuneauNs() {
        return this.ctx.getJuneauNs();
    }

    protected final String getLanguage() {
        return this.ctx.getLanguage();
    }

    protected final boolean isLooseCollections() {
        return this.ctx.isLooseCollections();
    }

    protected final Map<String, Object> getJenaSettings() {
        return this.ctx.getJenaSettings();
    }

    protected final boolean isTrimWhitespace() {
        return this.ctx.isTrimWhitespace();
    }

    protected RdfClassMeta getRdfClassMeta(ClassMeta<?> cm) {
        return this.ctx.getRdfClassMeta(cm);
    }

    protected RdfBeanMeta getRdfBeanMeta(BeanMeta<?> bm) {
        return this.ctx.getRdfBeanMeta(bm);
    }

    protected RdfBeanPropertyMeta getRdfBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getRdfBeanPropertyMeta(bpm);
    }

    protected XmlBeanPropertyMeta getXmlBeanPropertyMeta(BeanPropertyMeta bpm) {
        return this.ctx.getXmlBeanPropertyMeta(bpm);
    }

    @FluentSetters
    public static class Builder
    extends ReaderParserSession.Builder {
        RdfParser ctx;

        protected Builder(RdfParser ctx) {
            super((ReaderParser)ctx);
            this.ctx = ctx;
        }

        public RdfParserSession build() {
            return new RdfParserSession(this);
        }

        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply(type, apply);
            return this;
        }

        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        public Builder properties(Map<String, Object> value) {
            super.properties(value);
            return this;
        }

        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        public Builder localeDefault(Locale value) {
            super.localeDefault(value);
            return this;
        }

        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        public Builder outer(Object value) {
            super.outer(value);
            return this;
        }

        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }
    }
}

